"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.toRelativeSpec = exports.inferBrowserFromProject = exports.clamp = exports.b64url = exports.shortRef = exports.iso = void 0;
exports.getGithubMetadata = getGithubMetadata;
exports.getRepoName = getRepoName;
exports.buildAutoShardName = buildAutoShardName;
exports.getRunId = getRunId;
exports.getDatePartition = getDatePartition;
exports.getLinuxDistro = getLinuxDistro;
exports.inferOs = inferOs;
exports.fetchCommitInfo = fetchCommitInfo;
exports.buildReportUrl = buildReportUrl;
const path_1 = __importDefault(require("path"));
/** Generate ISO timestamp */
const iso = (d) => (d ? new Date(d) : new Date()).toISOString();
exports.iso = iso;
/** Extract short ref from full GitHub ref */
const shortRef = (ref) => {
    if (!ref)
        return undefined;
    const parts = ref.split('/');
    if (parts.length >= 3 && parts[0] === 'refs' && parts[1] === 'heads')
        return parts.slice(2).join('/');
    if (parts.length >= 3 && parts[0] === 'refs' && parts[1] === 'tags')
        return parts.slice(2).join('/');
    return ref;
};
exports.shortRef = shortRef;
/** Generate URL-safe base64 string */
const b64url = (s) => Buffer.from(s).toString('base64').replace(/=/g, '').replace(/\+/g, '-').replace(/\//g, '_');
exports.b64url = b64url;
/** Clamp number to range */
const clamp = (n, lo, hi) => Math.max(lo, Math.min(hi, n));
exports.clamp = clamp;
/** Infer browser name from Playwright project name */
const inferBrowserFromProject = (proj) => {
    if (!proj)
        return undefined;
    const p = proj.toLowerCase();
    if (p.includes('electron'))
        return 'electron';
    if (p.includes('chromium'))
        return 'chromium';
    if (p.includes('firefox'))
        return 'firefox';
    if (p.includes('webkit'))
        return 'webkit';
    if (p.includes('chrome'))
        return 'chrome';
    if (p.includes('edge'))
        return 'edge';
    if (p.includes('safari'))
        return 'safari';
    return undefined;
};
exports.inferBrowserFromProject = inferBrowserFromProject;
/** Convert absolute spec path to relative path (always uses forward slashes) */
const toRelativeSpec = (repoRoot, p) => {
    try {
        const relative = path_1.default.relative(repoRoot, p) || p;
        // Normalize to forward slashes for cross-platform consistency
        // Windows paths use backslashes, but we want uniform paths in the database
        return relative.replace(/\\/g, '/');
    }
    catch {
        return (p || 'unknown').replace(/\\/g, '/');
    }
};
exports.toRelativeSpec = toRelativeSpec;
/** Extract GitHub Actions metadata from environment */
function getGithubMetadata() {
    // For PRs: GITHUB_HEAD_REF has actual branch name (e.g., "feature/my-branch")
    // For pushes: GITHUB_HEAD_REF is empty, use shortRef(GITHUB_REF) (e.g., "main")
    const branchName = process.env.GITHUB_HEAD_REF || (0, exports.shortRef)(process.env.GITHUB_REF) || process.env.BRANCH;
    const sha = process.env.GITHUB_SHA || process.env.COMMIT_SHA;
    const workflowName = process.env.GITHUB_WORKFLOW || process.env.WORKFLOW_NAME;
    const jobName = process.env.GITHUB_JOB || process.env.JOB_NAME;
    let runUrl;
    if (process.env.GITHUB_SERVER_URL && process.env.GITHUB_REPOSITORY && process.env.GITHUB_RUN_ID) {
        runUrl = `${process.env.GITHUB_SERVER_URL}/${process.env.GITHUB_REPOSITORY}/actions/runs/${process.env.GITHUB_RUN_ID}`;
    }
    // Raw GITHUB_RUN_ID for building GitHub Actions URLs (getRunId() adds attempt/shard suffixes)
    const githubRunId = process.env.GITHUB_RUN_ID;
    // GITHUB_RUN_NUMBER is sequential per workflow - use for sorting by trigger order
    // Fall back to GITHUB_RUN_ID if RUN_NUMBER isn't available (e.g., in containers)
    let runNumber;
    if (process.env.GITHUB_RUN_NUMBER) {
        runNumber = parseInt(process.env.GITHUB_RUN_NUMBER, 10);
    }
    else if (githubRunId) {
        runNumber = parseInt(githubRunId, 10);
    }
    return { branchName, sha, workflowName, jobName, runUrl, runNumber, githubRunId };
}
/** Get repository name from environment or options */
function getRepoName(optionValue) {
    if (optionValue)
        return optionValue;
    const fromEnv = process.env.REPORTER_REPO_NAME || process.env.GITHUB_REPOSITORY;
    if (fromEnv) {
        // GITHUB_REPOSITORY is "owner/repo", extract just repo name
        const parts = fromEnv.split('/');
        return parts[parts.length - 1];
    }
    return 'local';
}
/**
 * Build auto-detected shard name from environment and Playwright config
 *
 * Priority:
 * 1. PW_PROJECT_NAME + OS + shard (e.g., "electron-ubuntu-1") - best for multi-OS matrix jobs
 * 2. GITHUB_JOB + shard (e.g., "e2e-ubuntu-run-shard-1-of-2") - fallback
 * 3. GITHUB_JOB only
 * 4. Playwright shard only
 *
 * @param config Playwright config with optional shard info
 * @returns Auto-detected shard name or undefined
 */
function buildAutoShardName(config) {
    const shardInfo = config?.shard;
    // Check for Playwright project name (commonly set by workflows as PW_PROJECT_NAME)
    // This is the best option for matrix jobs where GITHUB_JOB is the same for all matrix entries
    const projectName = process.env.PW_PROJECT_NAME || process.env.PLAYWRIGHT_PROJECT;
    if (projectName && shardInfo) {
        // Simplify project name (e.g., "e2e-electron" -> "electron")
        const simpleName = projectName.replace(/^e2e-/, '');
        // Include OS to differentiate same project across distros (ubuntu, rhel, debian, etc.)
        const os = inferOs();
        return `${simpleName}-${os}-${shardInfo.current}`;
    }
    // Fall back to GITHUB_JOB (static job key, same for all matrix entries)
    const job = process.env.GITHUB_JOB;
    if (job && shardInfo) {
        return `${job}-shard-${shardInfo.current}-of-${shardInfo.total}`;
    }
    if (job)
        return job;
    if (shardInfo)
        return `shard-${shardInfo.current}-of-${shardInfo.total}`;
    return undefined;
}
/**
 * Get run ID from environment or generate one
 *
 * For matrix jobs with multiple shards, set SHARD_NAME env var or pass shardName
 * to ensure each shard gets a unique runId:
 *   - Without shard: "123456789-1"
 *   - With shard: "123456789-1-windows-1"
 *
 * @param shardName Optional shard identifier (e.g., "windows-1", "chromium-2")
 * @param config Optional Playwright config for auto-detecting shard from --shard flag
 */
function getRunId(shardName, config) {
    // In GitHub Actions, use workflow run ID + attempt for uniqueness across retries
    const runId = process.env.GITHUB_RUN_ID;
    const attempt = process.env.GITHUB_RUN_ATTEMPT || '1';
    // Check for shard name: parameter > env var > auto-detection
    const shard = shardName || process.env.SHARD_NAME || buildAutoShardName(config);
    if (runId) {
        return shard ? `${runId}-${attempt}-${shard}` : `${runId}-${attempt}`;
    }
    // Local development: generate unique ID
    const localId = `local-${Date.now()}-${Math.random().toString(36).slice(2, 8)}`;
    return shard ? `${localId}-${shard}` : localId;
}
/** Get current date in YYYY-MM-DD format for partitioning */
function getDatePartition() {
    return new Date().toISOString().split('T')[0];
}
/**
 * Parse /etc/os-release content to detect Linux distribution
 * @param osReleaseContent Content of /etc/os-release file
 * @returns Detected distro or 'linux' as fallback
 */
function getLinuxDistro(osReleaseContent) {
    if (!osReleaseContent)
        return 'linux';
    // Parse ID and ID_LIKE from os-release
    const idMatch = osReleaseContent.match(/^ID=["']?([^"'\n]+)["']?/m);
    const idLikeMatch = osReleaseContent.match(/^ID_LIKE=["']?([^"'\n]+)["']?/m);
    const id = idMatch?.[1]?.toLowerCase() || '';
    const idLike = idLikeMatch?.[1]?.toLowerCase() || '';
    // Direct matches
    if (id === 'ubuntu')
        return 'ubuntu';
    if (id === 'debian')
        return 'debian';
    if (id === 'rhel' || id === 'rocky' || id === 'centos' || id === 'fedora' || id === 'almalinux')
        return 'rhel';
    if (id === 'opensuse' || id === 'opensuse-leap' || id === 'opensuse-tumbleweed' || id === 'sles')
        return 'suse';
    // Check ID_LIKE for derivatives
    if (idLike.includes('ubuntu'))
        return 'ubuntu';
    if (idLike.includes('debian'))
        return 'debian';
    if (idLike.includes('rhel') || idLike.includes('centos') || idLike.includes('fedora'))
        return 'rhel';
    if (idLike.includes('suse') || idLike.includes('opensuse'))
        return 'suse';
    return 'linux';
}
/** Infer OS from platform, with Linux distro detection */
function inferOs() {
    const platform = process.platform;
    if (platform === 'darwin')
        return 'mac';
    if (platform === 'win32')
        return 'win';
    // On Linux, try to detect specific distro
    try {
        const fs = require('fs');
        const osRelease = fs.readFileSync('/etc/os-release', 'utf-8');
        return getLinuxDistro(osRelease);
    }
    catch {
        // File doesn't exist or can't be read - fall back to generic linux
        return 'linux';
    }
}
/**
 * Get commit info using git commands
 * Works locally and in CI without requiring API tokens
 *
 * For PR workflows, GitHub creates a merge commit with a generic message like
 * "Merge abc123 into def456". This function detects that and falls back to
 * the PR's head commit message instead, which is more useful.
 */
async function fetchCommitInfo(sha) {
    const { execSync } = await Promise.resolve().then(() => __importStar(require('child_process')));
    const gitLog = (format, ref) => {
        // Quote the ref to handle special characters like ^ on Windows
        // In cmd.exe, ^ is the escape character and needs quoting
        return execSync(`git log -1 --format=${format} "${ref}"`, {
            encoding: 'utf-8',
            timeout: 5000,
            stdio: ['pipe', 'pipe', 'pipe'],
        }).trim();
    };
    try {
        // Use provided SHA or HEAD
        const ref = sha || 'HEAD';
        // Get commit subject line (first line only, no newlines)
        let message = gitLog('%s', ref);
        let author = gitLog('%an', ref);
        // Detect GitHub PR merge commit: "Merge <sha> into <sha>"
        // These auto-generated messages aren't useful, so we try to get
        // the actual PR head commit message instead (second parent of merge)
        const isPrMergeCommit = /^Merge [a-f0-9]+ into [a-f0-9]+/.test(message);
        if (isPrMergeCommit) {
            try {
                // Get message from PR's head commit (second parent of merge commit)
                // In GitHub's PR merge commits: ^1 = base branch, ^2 = PR head
                const headMessage = gitLog('%s', `${ref}^2`);
                const headAuthor = gitLog('%an', `${ref}^2`);
                if (headMessage) {
                    message = headMessage;
                    author = headAuthor || author;
                }
            }
            catch {
                // Failed to get head commit (might not be a merge commit after all)
                // Keep the original message
            }
        }
        return {
            message: message || undefined,
            author: author || undefined,
        };
    }
    catch (err) {
        // Git not available or not in a repo - silently return empty
        // This is expected in some CI environments or when testing the reporter itself
        return {};
    }
}
/**
 * Build the report URL for a test in the Playwright HTML report
 *
 * Requires REPORT_URL environment variable to be set by the workflow
 * (e.g., by gen-report-dir action or set-report-url step).
 *
 * @param testId Playwright's stable test.id for URL navigation
 */
function buildReportUrl(testId) {
    const reportUrl = process.env.REPORT_URL;
    if (!reportUrl)
        return undefined;
    return `${reportUrl}#?testId=${encodeURIComponent(testId)}`;
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/693b6d13ba5d61566bec7f5a4a46126eff7bbbe1/node_modules/@midleman/playwright-reporter/dist/utils.js.map