"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.uploadToS3 = uploadToS3;
exports.uploadFileToS3 = uploadFileToS3;
exports.createStorageWriter = createStorageWriter;
exports.getResultsKey = getResultsKey;
exports.getRunKey = getRunKey;
const client_s3_1 = require("@aws-sdk/client-s3");
const fs = __importStar(require("fs/promises"));
const path = __importStar(require("path"));
let s3Client = null;
function getS3Client(region) {
    if (!s3Client) {
        s3Client = new client_s3_1.S3Client({ region });
    }
    return s3Client;
}
/**
 * Upload a file to S3
 */
async function uploadToS3(config, key, body) {
    const client = getS3Client(config.region || 'us-east-1');
    const fullKey = config.prefix ? `${config.prefix}/${key}` : key;
    await client.send(new client_s3_1.PutObjectCommand({
        Bucket: config.bucket,
        Key: fullKey,
        Body: typeof body === 'string' ? Buffer.from(body) : body,
        ContentType: 'application/octet-stream',
    }));
}
/**
 * Upload a local file to S3
 */
async function uploadFileToS3(config, localPath, key) {
    const content = await fs.readFile(localPath);
    await uploadToS3(config, key, content);
}
/**
 * Create a storage writer based on configuration
 */
function createStorageWriter(s3Config, localOutputDir, verbose = false) {
    const log = verbose ? console.log.bind(console, '[reporter]') : () => { };
    if (s3Config) {
        return {
            async writeFile(key, localPath) {
                log(`Uploading to S3: s3://${s3Config.bucket}/${s3Config.prefix || ''}/${key}`);
                await uploadFileToS3(s3Config, localPath, key);
                // Clean up local temp file
                await fs.unlink(localPath).catch(() => { });
            },
            getOutputPath(key) {
                return `s3://${s3Config.bucket}/${s3Config.prefix || ''}/${key}`;
            },
        };
    }
    if (localOutputDir) {
        return {
            async writeFile(key, localPath) {
                const destPath = path.join(localOutputDir, key);
                await fs.mkdir(path.dirname(destPath), { recursive: true });
                await fs.rename(localPath, destPath);
                log(`Wrote to local: ${destPath}`);
            },
            getOutputPath(key) {
                return path.join(localOutputDir, key);
            },
        };
    }
    // Fallback: write to current directory
    return {
        async writeFile(key, localPath) {
            const destPath = path.join('test-results', key);
            await fs.mkdir(path.dirname(destPath), { recursive: true });
            await fs.rename(localPath, destPath);
            log(`Wrote to local (fallback): ${destPath}`);
        },
        getOutputPath(key) {
            return path.join('test-results', key);
        },
    };
}
/**
 * Generate S3 key for a run's results file
 * Format: {repoName}/{date}/{runId}/results.parquet
 */
function getResultsKey(repoName, date, runId) {
    return `${repoName}/${date}/${runId}/results.parquet`;
}
/**
 * Generate S3 key for a run's metadata file
 * Format: {repoName}/{date}/{runId}/run.parquet
 */
function getRunKey(repoName, date, runId) {
    return `${repoName}/${date}/${runId}/run.parquet`;
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/693b6d13ba5d61566bec7f5a4a46126eff7bbbe1/node_modules/@midleman/playwright-reporter/dist/storage/s3.js.map