"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateRunTotalsForTest = updateRunTotalsForTest;
exports.getLiveCounts = getLiveCounts;
exports.getFinalCounts = getFinalCounts;
/**
 * Update run-level totals for a single test key idempotently.
 */
function updateRunTotalsForTest(state, testKey, now) {
    const prev = state.countedStatusPerTest.get(testKey);
    if (prev !== now) {
        if (prev === 'flaky')
            state.totalFlaky = Math.max(0, state.totalFlaky - 1);
        else if (prev === 'passed')
            state.totalPassed = Math.max(0, state.totalPassed - 1);
        else if (prev === 'failed')
            state.totalFailed = Math.max(0, state.totalFailed - 1);
        else if (prev === 'skipped')
            state.totalSkipped = Math.max(0, state.totalSkipped - 1);
        if (now === 'flaky')
            state.totalFlaky += 1;
        else if (now === 'passed')
            state.totalPassed += 1;
        else if (now === 'failed')
            state.totalFailed += 1;
        else if (now === 'skipped')
            state.totalSkipped += 1;
        state.countedStatusPerTest.set(testKey, now);
    }
}
/**
 * Compute live counts starting from finalized totals and including buffered results.
 */
function getLiveCounts(state) {
    let passed = state.totalPassed;
    const failed = state.totalFailed;
    let skipped = state.totalSkipped;
    let flaky = state.totalFlaky;
    for (const specMap of state.buffers.values()) {
        for (const p of specMap.values()) {
            const s = p.status;
            if (!s)
                continue;
            if (s === 'passed')
                passed += 1;
            else if (s === 'flaky')
                flaky += 1;
            else if (s === 'skipped')
                skipped += 1;
            // do not count interim 'failed' attempts here
        }
    }
    return { passed, failed, skipped, flaky };
}
/**
 * Get final counts for run completion.
 */
function getFinalCounts(state) {
    return {
        passed: state.totalPassed,
        failed: state.totalFailed,
        skipped: state.totalSkipped,
        flaky: state.totalFlaky,
    };
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/693b6d13ba5d61566bec7f5a4a46126eff7bbbe1/node_modules/@midleman/playwright-reporter/dist/counts.js.map