"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureSpec = ensureSpec;
exports.setTest = setTest;
exports.getSpec = getSpec;
exports.deleteTest = deleteTest;
exports.deleteSpec = deleteSpec;
exports.specValues = specValues;
exports.specSize = specSize;
exports.listSpecs = listSpecs;
exports.allValues = allValues;
function ensureSpec(buffers, spec) {
    let m = buffers.get(spec);
    if (!m) {
        m = new Map();
        buffers.set(spec, m);
    }
    return m;
}
function setTest(buffers, spec, testKey, payload) {
    const m = ensureSpec(buffers, spec);
    m.set(testKey, payload);
}
function getSpec(buffers, spec) {
    return buffers.get(spec);
}
function deleteTest(buffers, spec, testKey) {
    const m = buffers.get(spec);
    if (!m)
        return;
    m.delete(testKey);
    if (m.size === 0)
        buffers.delete(spec);
}
function deleteSpec(buffers, spec) {
    buffers.delete(spec);
}
function specValues(buffers, spec) {
    const m = buffers.get(spec);
    return m ? Array.from(m.values()) : [];
}
function specSize(buffers, spec) {
    const m = buffers.get(spec);
    return m ? m.size : 0;
}
function listSpecs(buffers) {
    return Array.from(buffers.keys());
}
function allValues(buffers) {
    const results = [];
    for (const specMap of buffers.values()) {
        for (const result of specMap.values()) {
            results.push(result);
        }
    }
    return results;
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/693b6d13ba5d61566bec7f5a4a46126eff7bbbe1/node_modules/@midleman/playwright-reporter/dist/buffers.js.map