import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { UpdateAutomatedReasoningPolicyTestCaseRequestFilterSensitiveLog, } from "../models/models_0";
import { de_UpdateAutomatedReasoningPolicyTestCaseCommand, se_UpdateAutomatedReasoningPolicyTestCaseCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class UpdateAutomatedReasoningPolicyTestCaseCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "UpdateAutomatedReasoningPolicyTestCase", {})
    .n("BedrockClient", "UpdateAutomatedReasoningPolicyTestCaseCommand")
    .f(UpdateAutomatedReasoningPolicyTestCaseRequestFilterSensitiveLog, void 0)
    .ser(se_UpdateAutomatedReasoningPolicyTestCaseCommand)
    .de(de_UpdateAutomatedReasoningPolicyTestCaseCommand)
    .build() {
}
