import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ListAutomatedReasoningPoliciesResponseFilterSensitiveLog, } from "../models/models_0";
import { de_ListAutomatedReasoningPoliciesCommand, se_ListAutomatedReasoningPoliciesCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class ListAutomatedReasoningPoliciesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListAutomatedReasoningPolicies", {})
    .n("BedrockClient", "ListAutomatedReasoningPoliciesCommand")
    .f(void 0, ListAutomatedReasoningPoliciesResponseFilterSensitiveLog)
    .ser(se_ListAutomatedReasoningPoliciesCommand)
    .de(de_ListAutomatedReasoningPoliciesCommand)
    .build() {
}
