import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetAutomatedReasoningPolicyBuildWorkflowResponseFilterSensitiveLog, } from "../models/models_0";
import { de_GetAutomatedReasoningPolicyBuildWorkflowCommand, se_GetAutomatedReasoningPolicyBuildWorkflowCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class GetAutomatedReasoningPolicyBuildWorkflowCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetAutomatedReasoningPolicyBuildWorkflow", {})
    .n("BedrockClient", "GetAutomatedReasoningPolicyBuildWorkflowCommand")
    .f(void 0, GetAutomatedReasoningPolicyBuildWorkflowResponseFilterSensitiveLog)
    .ser(se_GetAutomatedReasoningPolicyBuildWorkflowCommand)
    .de(de_GetAutomatedReasoningPolicyBuildWorkflowCommand)
    .build() {
}
