import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ExportAutomatedReasoningPolicyVersionResponseFilterSensitiveLog, } from "../models/models_0";
import { de_ExportAutomatedReasoningPolicyVersionCommand, se_ExportAutomatedReasoningPolicyVersionCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class ExportAutomatedReasoningPolicyVersionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ExportAutomatedReasoningPolicyVersion", {})
    .n("BedrockClient", "ExportAutomatedReasoningPolicyVersionCommand")
    .f(void 0, ExportAutomatedReasoningPolicyVersionResponseFilterSensitiveLog)
    .ser(se_ExportAutomatedReasoningPolicyVersionCommand)
    .de(de_ExportAutomatedReasoningPolicyVersionCommand)
    .build() {
}
