import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CreateAutomatedReasoningPolicyVersionResponseFilterSensitiveLog, } from "../models/models_0";
import { de_CreateAutomatedReasoningPolicyVersionCommand, se_CreateAutomatedReasoningPolicyVersionCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class CreateAutomatedReasoningPolicyVersionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateAutomatedReasoningPolicyVersion", {})
    .n("BedrockClient", "CreateAutomatedReasoningPolicyVersionCommand")
    .f(void 0, CreateAutomatedReasoningPolicyVersionResponseFilterSensitiveLog)
    .ser(se_CreateAutomatedReasoningPolicyVersionCommand)
    .de(de_CreateAutomatedReasoningPolicyVersionCommand)
    .build() {
}
