'use strict';

var middlewareHostHeader = require('@aws-sdk/middleware-host-header');
var middlewareLogger = require('@aws-sdk/middleware-logger');
var middlewareRecursionDetection = require('@aws-sdk/middleware-recursion-detection');
var middlewareUserAgent = require('@aws-sdk/middleware-user-agent');
var configResolver = require('@smithy/config-resolver');
var core = require('@smithy/core');
var middlewareContentLength = require('@smithy/middleware-content-length');
var middlewareEndpoint = require('@smithy/middleware-endpoint');
var middlewareRetry = require('@smithy/middleware-retry');
var smithyClient = require('@smithy/smithy-client');
var httpAuthSchemeProvider = require('./auth/httpAuthSchemeProvider');
var runtimeConfig = require('./runtimeConfig');
var regionConfigResolver = require('@aws-sdk/region-config-resolver');
var protocolHttp = require('@smithy/protocol-http');
var middlewareSerde = require('@smithy/middleware-serde');
var core$1 = require('@aws-sdk/core');
var uuid = require('@smithy/uuid');

const resolveClientEndpointParameters = (options) => {
    return Object.assign(options, {
        useDualstackEndpoint: options.useDualstackEndpoint ?? false,
        useFipsEndpoint: options.useFipsEndpoint ?? false,
        defaultSigningName: "bedrock",
    });
};
const commonParams = {
    UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
    Endpoint: { type: "builtInParams", name: "endpoint" },
    Region: { type: "builtInParams", name: "region" },
    UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
};

const getHttpAuthExtensionConfiguration = (runtimeConfig) => {
    const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
    let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
    let _credentials = runtimeConfig.credentials;
    let _token = runtimeConfig.token;
    return {
        setHttpAuthScheme(httpAuthScheme) {
            const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
            if (index === -1) {
                _httpAuthSchemes.push(httpAuthScheme);
            }
            else {
                _httpAuthSchemes.splice(index, 1, httpAuthScheme);
            }
        },
        httpAuthSchemes() {
            return _httpAuthSchemes;
        },
        setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
            _httpAuthSchemeProvider = httpAuthSchemeProvider;
        },
        httpAuthSchemeProvider() {
            return _httpAuthSchemeProvider;
        },
        setCredentials(credentials) {
            _credentials = credentials;
        },
        credentials() {
            return _credentials;
        },
        setToken(token) {
            _token = token;
        },
        token() {
            return _token;
        },
    };
};
const resolveHttpAuthRuntimeConfig = (config) => {
    return {
        httpAuthSchemes: config.httpAuthSchemes(),
        httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
        credentials: config.credentials(),
        token: config.token(),
    };
};

const resolveRuntimeExtensions = (runtimeConfig, extensions) => {
    const extensionConfiguration = Object.assign(regionConfigResolver.getAwsRegionExtensionConfiguration(runtimeConfig), smithyClient.getDefaultExtensionConfiguration(runtimeConfig), protocolHttp.getHttpHandlerExtensionConfiguration(runtimeConfig), getHttpAuthExtensionConfiguration(runtimeConfig));
    extensions.forEach((extension) => extension.configure(extensionConfiguration));
    return Object.assign(runtimeConfig, regionConfigResolver.resolveAwsRegionExtensionConfiguration(extensionConfiguration), smithyClient.resolveDefaultRuntimeConfig(extensionConfiguration), protocolHttp.resolveHttpHandlerRuntimeConfig(extensionConfiguration), resolveHttpAuthRuntimeConfig(extensionConfiguration));
};

class BedrockClient extends smithyClient.Client {
    config;
    constructor(...[configuration]) {
        const _config_0 = runtimeConfig.getRuntimeConfig(configuration || {});
        super(_config_0);
        this.initConfig = _config_0;
        const _config_1 = resolveClientEndpointParameters(_config_0);
        const _config_2 = middlewareUserAgent.resolveUserAgentConfig(_config_1);
        const _config_3 = middlewareRetry.resolveRetryConfig(_config_2);
        const _config_4 = configResolver.resolveRegionConfig(_config_3);
        const _config_5 = middlewareHostHeader.resolveHostHeaderConfig(_config_4);
        const _config_6 = middlewareEndpoint.resolveEndpointConfig(_config_5);
        const _config_7 = httpAuthSchemeProvider.resolveHttpAuthSchemeConfig(_config_6);
        const _config_8 = resolveRuntimeExtensions(_config_7, configuration?.extensions || []);
        this.config = _config_8;
        this.middlewareStack.use(middlewareUserAgent.getUserAgentPlugin(this.config));
        this.middlewareStack.use(middlewareRetry.getRetryPlugin(this.config));
        this.middlewareStack.use(middlewareContentLength.getContentLengthPlugin(this.config));
        this.middlewareStack.use(middlewareHostHeader.getHostHeaderPlugin(this.config));
        this.middlewareStack.use(middlewareLogger.getLoggerPlugin(this.config));
        this.middlewareStack.use(middlewareRecursionDetection.getRecursionDetectionPlugin(this.config));
        this.middlewareStack.use(core.getHttpAuthSchemeEndpointRuleSetPlugin(this.config, {
            httpAuthSchemeParametersProvider: httpAuthSchemeProvider.defaultBedrockHttpAuthSchemeParametersProvider,
            identityProviderConfigProvider: async (config) => new core.DefaultIdentityProviderConfig({
                "aws.auth#sigv4": config.credentials,
                "smithy.api#httpBearerAuth": config.token,
            }),
        }));
        this.middlewareStack.use(core.getHttpSigningPlugin(this.config));
    }
    destroy() {
        super.destroy();
    }
}

class BedrockServiceException extends smithyClient.ServiceException {
    constructor(options) {
        super(options);
        Object.setPrototypeOf(this, BedrockServiceException.prototype);
    }
}

class AccessDeniedException extends BedrockServiceException {
    name = "AccessDeniedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "AccessDeniedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, AccessDeniedException.prototype);
    }
}
const AgreementStatus = {
    AVAILABLE: "AVAILABLE",
    ERROR: "ERROR",
    NOT_AVAILABLE: "NOT_AVAILABLE",
    PENDING: "PENDING",
};
class InternalServerException extends BedrockServiceException {
    name = "InternalServerException";
    $fault = "server";
    constructor(opts) {
        super({
            name: "InternalServerException",
            $fault: "server",
            ...opts,
        });
        Object.setPrototypeOf(this, InternalServerException.prototype);
    }
}
class ResourceNotFoundException extends BedrockServiceException {
    name = "ResourceNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ResourceNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceNotFoundException.prototype);
    }
}
class ThrottlingException extends BedrockServiceException {
    name = "ThrottlingException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ThrottlingException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ThrottlingException.prototype);
    }
}
class ValidationException extends BedrockServiceException {
    name = "ValidationException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ValidationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ValidationException.prototype);
    }
}
class ConflictException extends BedrockServiceException {
    name = "ConflictException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ConflictException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ConflictException.prototype);
    }
}
class ServiceQuotaExceededException extends BedrockServiceException {
    name = "ServiceQuotaExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ServiceQuotaExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ServiceQuotaExceededException.prototype);
    }
}
class TooManyTagsException extends BedrockServiceException {
    name = "TooManyTagsException";
    $fault = "client";
    resourceName;
    constructor(opts) {
        super({
            name: "TooManyTagsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyTagsException.prototype);
        this.resourceName = opts.resourceName;
    }
}
const AutomatedReasoningCheckResult = {
    IMPOSSIBLE: "IMPOSSIBLE",
    INVALID: "INVALID",
    NO_TRANSLATION: "NO_TRANSLATION",
    SATISFIABLE: "SATISFIABLE",
    TOO_COMPLEX: "TOO_COMPLEX",
    TRANSLATION_AMBIGUOUS: "TRANSLATION_AMBIGUOUS",
    VALID: "VALID",
};
class ResourceInUseException extends BedrockServiceException {
    name = "ResourceInUseException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ResourceInUseException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceInUseException.prototype);
    }
}
exports.AutomatedReasoningPolicyTypeValueAnnotation = void 0;
(function (AutomatedReasoningPolicyTypeValueAnnotation) {
    AutomatedReasoningPolicyTypeValueAnnotation.visit = (value, visitor) => {
        if (value.addTypeValue !== undefined)
            return visitor.addTypeValue(value.addTypeValue);
        if (value.updateTypeValue !== undefined)
            return visitor.updateTypeValue(value.updateTypeValue);
        if (value.deleteTypeValue !== undefined)
            return visitor.deleteTypeValue(value.deleteTypeValue);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.AutomatedReasoningPolicyTypeValueAnnotation || (exports.AutomatedReasoningPolicyTypeValueAnnotation = {}));
exports.AutomatedReasoningPolicyAnnotation = void 0;
(function (AutomatedReasoningPolicyAnnotation) {
    AutomatedReasoningPolicyAnnotation.visit = (value, visitor) => {
        if (value.addType !== undefined)
            return visitor.addType(value.addType);
        if (value.updateType !== undefined)
            return visitor.updateType(value.updateType);
        if (value.deleteType !== undefined)
            return visitor.deleteType(value.deleteType);
        if (value.addVariable !== undefined)
            return visitor.addVariable(value.addVariable);
        if (value.updateVariable !== undefined)
            return visitor.updateVariable(value.updateVariable);
        if (value.deleteVariable !== undefined)
            return visitor.deleteVariable(value.deleteVariable);
        if (value.addRule !== undefined)
            return visitor.addRule(value.addRule);
        if (value.updateRule !== undefined)
            return visitor.updateRule(value.updateRule);
        if (value.deleteRule !== undefined)
            return visitor.deleteRule(value.deleteRule);
        if (value.addRuleFromNaturalLanguage !== undefined)
            return visitor.addRuleFromNaturalLanguage(value.addRuleFromNaturalLanguage);
        if (value.updateFromRulesFeedback !== undefined)
            return visitor.updateFromRulesFeedback(value.updateFromRulesFeedback);
        if (value.updateFromScenarioFeedback !== undefined)
            return visitor.updateFromScenarioFeedback(value.updateFromScenarioFeedback);
        if (value.ingestContent !== undefined)
            return visitor.ingestContent(value.ingestContent);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.AutomatedReasoningPolicyAnnotation || (exports.AutomatedReasoningPolicyAnnotation = {}));
const AutomatedReasoningPolicyBuildWorkflowType = {
    IMPORT_POLICY: "IMPORT_POLICY",
    INGEST_CONTENT: "INGEST_CONTENT",
    REFINE_POLICY: "REFINE_POLICY",
};
const AutomatedReasoningPolicyBuildDocumentContentType = {
    PDF: "pdf",
    TEXT: "txt",
};
const AutomatedReasoningPolicyBuildWorkflowStatus = {
    BUILDING: "BUILDING",
    CANCELLED: "CANCELLED",
    CANCEL_REQUESTED: "CANCEL_REQUESTED",
    COMPLETED: "COMPLETED",
    FAILED: "FAILED",
    PREPROCESSING: "PREPROCESSING",
    SCHEDULED: "SCHEDULED",
    TESTING: "TESTING",
};
const AutomatedReasoningPolicyBuildResultAssetType = {
    BUILD_LOG: "BUILD_LOG",
    POLICY_DEFINITION: "POLICY_DEFINITION",
    QUALITY_REPORT: "QUALITY_REPORT",
};
exports.AutomatedReasoningPolicyMutation = void 0;
(function (AutomatedReasoningPolicyMutation) {
    AutomatedReasoningPolicyMutation.visit = (value, visitor) => {
        if (value.addType !== undefined)
            return visitor.addType(value.addType);
        if (value.updateType !== undefined)
            return visitor.updateType(value.updateType);
        if (value.deleteType !== undefined)
            return visitor.deleteType(value.deleteType);
        if (value.addVariable !== undefined)
            return visitor.addVariable(value.addVariable);
        if (value.updateVariable !== undefined)
            return visitor.updateVariable(value.updateVariable);
        if (value.deleteVariable !== undefined)
            return visitor.deleteVariable(value.deleteVariable);
        if (value.addRule !== undefined)
            return visitor.addRule(value.addRule);
        if (value.updateRule !== undefined)
            return visitor.updateRule(value.updateRule);
        if (value.deleteRule !== undefined)
            return visitor.deleteRule(value.deleteRule);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.AutomatedReasoningPolicyMutation || (exports.AutomatedReasoningPolicyMutation = {}));
exports.AutomatedReasoningPolicyBuildStepContext = void 0;
(function (AutomatedReasoningPolicyBuildStepContext) {
    AutomatedReasoningPolicyBuildStepContext.visit = (value, visitor) => {
        if (value.planning !== undefined)
            return visitor.planning(value.planning);
        if (value.mutation !== undefined)
            return visitor.mutation(value.mutation);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.AutomatedReasoningPolicyBuildStepContext || (exports.AutomatedReasoningPolicyBuildStepContext = {}));
const AutomatedReasoningPolicyBuildMessageType = {
    ERROR: "ERROR",
    INFO: "INFO",
    WARNING: "WARNING",
};
exports.AutomatedReasoningPolicyDefinitionElement = void 0;
(function (AutomatedReasoningPolicyDefinitionElement) {
    AutomatedReasoningPolicyDefinitionElement.visit = (value, visitor) => {
        if (value.policyDefinitionVariable !== undefined)
            return visitor.policyDefinitionVariable(value.policyDefinitionVariable);
        if (value.policyDefinitionType !== undefined)
            return visitor.policyDefinitionType(value.policyDefinitionType);
        if (value.policyDefinitionRule !== undefined)
            return visitor.policyDefinitionRule(value.policyDefinitionRule);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.AutomatedReasoningPolicyDefinitionElement || (exports.AutomatedReasoningPolicyDefinitionElement = {}));
const AutomatedReasoningPolicyAnnotationStatus = {
    APPLIED: "APPLIED",
    FAILED: "FAILED",
};
exports.AutomatedReasoningPolicyBuildResultAssets = void 0;
(function (AutomatedReasoningPolicyBuildResultAssets) {
    AutomatedReasoningPolicyBuildResultAssets.visit = (value, visitor) => {
        if (value.policyDefinition !== undefined)
            return visitor.policyDefinition(value.policyDefinition);
        if (value.qualityReport !== undefined)
            return visitor.qualityReport(value.qualityReport);
        if (value.buildLog !== undefined)
            return visitor.buildLog(value.buildLog);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.AutomatedReasoningPolicyBuildResultAssets || (exports.AutomatedReasoningPolicyBuildResultAssets = {}));
const AutomatedReasoningCheckLogicWarningType = {
    ALWAYS_FALSE: "ALWAYS_FALSE",
    ALWAYS_TRUE: "ALWAYS_TRUE",
};
exports.AutomatedReasoningCheckFinding = void 0;
(function (AutomatedReasoningCheckFinding) {
    AutomatedReasoningCheckFinding.visit = (value, visitor) => {
        if (value.valid !== undefined)
            return visitor.valid(value.valid);
        if (value.invalid !== undefined)
            return visitor.invalid(value.invalid);
        if (value.satisfiable !== undefined)
            return visitor.satisfiable(value.satisfiable);
        if (value.impossible !== undefined)
            return visitor.impossible(value.impossible);
        if (value.translationAmbiguous !== undefined)
            return visitor.translationAmbiguous(value.translationAmbiguous);
        if (value.tooComplex !== undefined)
            return visitor.tooComplex(value.tooComplex);
        if (value.noTranslations !== undefined)
            return visitor.noTranslations(value.noTranslations);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.AutomatedReasoningCheckFinding || (exports.AutomatedReasoningCheckFinding = {}));
const AutomatedReasoningPolicyTestRunResult = {
    FAILED: "FAILED",
    PASSED: "PASSED",
};
const AutomatedReasoningPolicyTestRunStatus = {
    COMPLETED: "COMPLETED",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
    NOT_STARTED: "NOT_STARTED",
    SCHEDULED: "SCHEDULED",
};
exports.AutomatedReasoningPolicyWorkflowTypeContent = void 0;
(function (AutomatedReasoningPolicyWorkflowTypeContent) {
    AutomatedReasoningPolicyWorkflowTypeContent.visit = (value, visitor) => {
        if (value.documents !== undefined)
            return visitor.documents(value.documents);
        if (value.policyRepairAssets !== undefined)
            return visitor.policyRepairAssets(value.policyRepairAssets);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.AutomatedReasoningPolicyWorkflowTypeContent || (exports.AutomatedReasoningPolicyWorkflowTypeContent = {}));
exports.EndpointConfig = void 0;
(function (EndpointConfig) {
    EndpointConfig.visit = (value, visitor) => {
        if (value.sageMaker !== undefined)
            return visitor.sageMaker(value.sageMaker);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.EndpointConfig || (exports.EndpointConfig = {}));
const Status = {
    INCOMPATIBLE_ENDPOINT: "INCOMPATIBLE_ENDPOINT",
    REGISTERED: "REGISTERED",
};
class ServiceUnavailableException extends BedrockServiceException {
    name = "ServiceUnavailableException";
    $fault = "server";
    constructor(opts) {
        super({
            name: "ServiceUnavailableException",
            $fault: "server",
            ...opts,
        });
        Object.setPrototypeOf(this, ServiceUnavailableException.prototype);
    }
}
const CustomModelDeploymentStatus = {
    ACTIVE: "Active",
    CREATING: "Creating",
    FAILED: "Failed",
};
const SortModelsBy = {
    CREATION_TIME: "CreationTime",
};
const SortOrder = {
    ASCENDING: "Ascending",
    DESCENDING: "Descending",
};
exports.ModelDataSource = void 0;
(function (ModelDataSource) {
    ModelDataSource.visit = (value, visitor) => {
        if (value.s3DataSource !== undefined)
            return visitor.s3DataSource(value.s3DataSource);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.ModelDataSource || (exports.ModelDataSource = {}));
exports.CustomizationConfig = void 0;
(function (CustomizationConfig) {
    CustomizationConfig.visit = (value, visitor) => {
        if (value.distillationConfig !== undefined)
            return visitor.distillationConfig(value.distillationConfig);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.CustomizationConfig || (exports.CustomizationConfig = {}));
const CustomizationType = {
    CONTINUED_PRE_TRAINING: "CONTINUED_PRE_TRAINING",
    DISTILLATION: "DISTILLATION",
    FINE_TUNING: "FINE_TUNING",
    IMPORTED: "IMPORTED",
};
const ModelStatus = {
    ACTIVE: "Active",
    CREATING: "Creating",
    FAILED: "Failed",
};
exports.InvocationLogSource = void 0;
(function (InvocationLogSource) {
    InvocationLogSource.visit = (value, visitor) => {
        if (value.s3Uri !== undefined)
            return visitor.s3Uri(value.s3Uri);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.InvocationLogSource || (exports.InvocationLogSource = {}));
exports.RequestMetadataFilters = void 0;
(function (RequestMetadataFilters) {
    RequestMetadataFilters.visit = (value, visitor) => {
        if (value.equals !== undefined)
            return visitor.equals(value.equals);
        if (value.notEquals !== undefined)
            return visitor.notEquals(value.notEquals);
        if (value.andAll !== undefined)
            return visitor.andAll(value.andAll);
        if (value.orAll !== undefined)
            return visitor.orAll(value.orAll);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.RequestMetadataFilters || (exports.RequestMetadataFilters = {}));
const EvaluationJobStatus = {
    COMPLETED: "Completed",
    DELETING: "Deleting",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    STOPPED: "Stopped",
    STOPPING: "Stopping",
};
const ApplicationType = {
    MODEL_EVALUATION: "ModelEvaluation",
    RAG_EVALUATION: "RagEvaluation",
};
exports.RatingScaleItemValue = void 0;
(function (RatingScaleItemValue) {
    RatingScaleItemValue.visit = (value, visitor) => {
        if (value.stringValue !== undefined)
            return visitor.stringValue(value.stringValue);
        if (value.floatValue !== undefined)
            return visitor.floatValue(value.floatValue);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.RatingScaleItemValue || (exports.RatingScaleItemValue = {}));
exports.AutomatedEvaluationCustomMetricSource = void 0;
(function (AutomatedEvaluationCustomMetricSource) {
    AutomatedEvaluationCustomMetricSource.visit = (value, visitor) => {
        if (value.customMetricDefinition !== undefined)
            return visitor.customMetricDefinition(value.customMetricDefinition);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.AutomatedEvaluationCustomMetricSource || (exports.AutomatedEvaluationCustomMetricSource = {}));
exports.EvaluationDatasetLocation = void 0;
(function (EvaluationDatasetLocation) {
    EvaluationDatasetLocation.visit = (value, visitor) => {
        if (value.s3Uri !== undefined)
            return visitor.s3Uri(value.s3Uri);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.EvaluationDatasetLocation || (exports.EvaluationDatasetLocation = {}));
const EvaluationTaskType = {
    CLASSIFICATION: "Classification",
    CUSTOM: "Custom",
    GENERATION: "Generation",
    QUESTION_AND_ANSWER: "QuestionAndAnswer",
    SUMMARIZATION: "Summarization",
};
exports.EvaluatorModelConfig = void 0;
(function (EvaluatorModelConfig) {
    EvaluatorModelConfig.visit = (value, visitor) => {
        if (value.bedrockEvaluatorModels !== undefined)
            return visitor.bedrockEvaluatorModels(value.bedrockEvaluatorModels);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.EvaluatorModelConfig || (exports.EvaluatorModelConfig = {}));
exports.EvaluationConfig = void 0;
(function (EvaluationConfig) {
    EvaluationConfig.visit = (value, visitor) => {
        if (value.automated !== undefined)
            return visitor.automated(value.automated);
        if (value.human !== undefined)
            return visitor.human(value.human);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.EvaluationConfig || (exports.EvaluationConfig = {}));
const PerformanceConfigLatency = {
    OPTIMIZED: "optimized",
    STANDARD: "standard",
};
exports.EvaluationModelConfig = void 0;
(function (EvaluationModelConfig) {
    EvaluationModelConfig.visit = (value, visitor) => {
        if (value.bedrockModel !== undefined)
            return visitor.bedrockModel(value.bedrockModel);
        if (value.precomputedInferenceSource !== undefined)
            return visitor.precomputedInferenceSource(value.precomputedInferenceSource);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.EvaluationModelConfig || (exports.EvaluationModelConfig = {}));
const ExternalSourceType = {
    BYTE_CONTENT: "BYTE_CONTENT",
    S3: "S3",
};
const QueryTransformationType = {
    QUERY_DECOMPOSITION: "QUERY_DECOMPOSITION",
};
const AttributeType = {
    BOOLEAN: "BOOLEAN",
    NUMBER: "NUMBER",
    STRING: "STRING",
    STRING_LIST: "STRING_LIST",
};
const SearchType = {
    HYBRID: "HYBRID",
    SEMANTIC: "SEMANTIC",
};
const RerankingMetadataSelectionMode = {
    ALL: "ALL",
    SELECTIVE: "SELECTIVE",
};
exports.RerankingMetadataSelectiveModeConfiguration = void 0;
(function (RerankingMetadataSelectiveModeConfiguration) {
    RerankingMetadataSelectiveModeConfiguration.visit = (value, visitor) => {
        if (value.fieldsToInclude !== undefined)
            return visitor.fieldsToInclude(value.fieldsToInclude);
        if (value.fieldsToExclude !== undefined)
            return visitor.fieldsToExclude(value.fieldsToExclude);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.RerankingMetadataSelectiveModeConfiguration || (exports.RerankingMetadataSelectiveModeConfiguration = {}));
const VectorSearchRerankingConfigurationType = {
    BEDROCK_RERANKING_MODEL: "BEDROCK_RERANKING_MODEL",
};
const RetrieveAndGenerateType = {
    EXTERNAL_SOURCES: "EXTERNAL_SOURCES",
    KNOWLEDGE_BASE: "KNOWLEDGE_BASE",
};
exports.EvaluationPrecomputedRagSourceConfig = void 0;
(function (EvaluationPrecomputedRagSourceConfig) {
    EvaluationPrecomputedRagSourceConfig.visit = (value, visitor) => {
        if (value.retrieveSourceConfig !== undefined)
            return visitor.retrieveSourceConfig(value.retrieveSourceConfig);
        if (value.retrieveAndGenerateSourceConfig !== undefined)
            return visitor.retrieveAndGenerateSourceConfig(value.retrieveAndGenerateSourceConfig);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.EvaluationPrecomputedRagSourceConfig || (exports.EvaluationPrecomputedRagSourceConfig = {}));
const EvaluationJobType = {
    AUTOMATED: "Automated",
    HUMAN: "Human",
};
const SortJobsBy = {
    CREATION_TIME: "CreationTime",
};
const GuardrailContentFilterAction = {
    BLOCK: "BLOCK",
    NONE: "NONE",
};
const GuardrailModality = {
    IMAGE: "IMAGE",
    TEXT: "TEXT",
};
const GuardrailFilterStrength = {
    HIGH: "HIGH",
    LOW: "LOW",
    MEDIUM: "MEDIUM",
    NONE: "NONE",
};
const GuardrailContentFilterType = {
    HATE: "HATE",
    INSULTS: "INSULTS",
    MISCONDUCT: "MISCONDUCT",
    PROMPT_ATTACK: "PROMPT_ATTACK",
    SEXUAL: "SEXUAL",
    VIOLENCE: "VIOLENCE",
};
const GuardrailContentFiltersTierName = {
    CLASSIC: "CLASSIC",
    STANDARD: "STANDARD",
};
const GuardrailContextualGroundingAction = {
    BLOCK: "BLOCK",
    NONE: "NONE",
};
const GuardrailContextualGroundingFilterType = {
    GROUNDING: "GROUNDING",
    RELEVANCE: "RELEVANCE",
};
const GuardrailSensitiveInformationAction = {
    ANONYMIZE: "ANONYMIZE",
    BLOCK: "BLOCK",
    NONE: "NONE",
};
const GuardrailPiiEntityType = {
    ADDRESS: "ADDRESS",
    AGE: "AGE",
    AWS_ACCESS_KEY: "AWS_ACCESS_KEY",
    AWS_SECRET_KEY: "AWS_SECRET_KEY",
    CA_HEALTH_NUMBER: "CA_HEALTH_NUMBER",
    CA_SOCIAL_INSURANCE_NUMBER: "CA_SOCIAL_INSURANCE_NUMBER",
    CREDIT_DEBIT_CARD_CVV: "CREDIT_DEBIT_CARD_CVV",
    CREDIT_DEBIT_CARD_EXPIRY: "CREDIT_DEBIT_CARD_EXPIRY",
    CREDIT_DEBIT_CARD_NUMBER: "CREDIT_DEBIT_CARD_NUMBER",
    DRIVER_ID: "DRIVER_ID",
    EMAIL: "EMAIL",
    INTERNATIONAL_BANK_ACCOUNT_NUMBER: "INTERNATIONAL_BANK_ACCOUNT_NUMBER",
    IP_ADDRESS: "IP_ADDRESS",
    LICENSE_PLATE: "LICENSE_PLATE",
    MAC_ADDRESS: "MAC_ADDRESS",
    NAME: "NAME",
    PASSWORD: "PASSWORD",
    PHONE: "PHONE",
    PIN: "PIN",
    SWIFT_CODE: "SWIFT_CODE",
    UK_NATIONAL_HEALTH_SERVICE_NUMBER: "UK_NATIONAL_HEALTH_SERVICE_NUMBER",
    UK_NATIONAL_INSURANCE_NUMBER: "UK_NATIONAL_INSURANCE_NUMBER",
    UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER: "UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER",
    URL: "URL",
    USERNAME: "USERNAME",
    US_BANK_ACCOUNT_NUMBER: "US_BANK_ACCOUNT_NUMBER",
    US_BANK_ROUTING_NUMBER: "US_BANK_ROUTING_NUMBER",
    US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER: "US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER",
    US_PASSPORT_NUMBER: "US_PASSPORT_NUMBER",
    US_SOCIAL_SECURITY_NUMBER: "US_SOCIAL_SECURITY_NUMBER",
    VEHICLE_IDENTIFICATION_NUMBER: "VEHICLE_IDENTIFICATION_NUMBER",
};
const GuardrailTopicsTierName = {
    CLASSIC: "CLASSIC",
    STANDARD: "STANDARD",
};
const GuardrailTopicAction = {
    BLOCK: "BLOCK",
    NONE: "NONE",
};
const GuardrailTopicType = {
    DENY: "DENY",
};
const GuardrailWordAction = {
    BLOCK: "BLOCK",
    NONE: "NONE",
};
const AutomatedReasoningPolicyDefinitionRuleFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.expression && { expression: smithyClient.SENSITIVE_STRING }),
    ...(obj.alternateExpression && { alternateExpression: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyDefinitionTypeValueFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyDefinitionTypeFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
    ...(obj.values && {
        values: obj.values.map((item) => AutomatedReasoningPolicyDefinitionTypeValueFilterSensitiveLog(item)),
    }),
});
const AutomatedReasoningPolicyDefinitionVariableFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.type && { type: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyDefinitionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.types && { types: obj.types.map((item) => AutomatedReasoningPolicyDefinitionTypeFilterSensitiveLog(item)) }),
    ...(obj.rules && { rules: obj.rules.map((item) => AutomatedReasoningPolicyDefinitionRuleFilterSensitiveLog(item)) }),
    ...(obj.variables && {
        variables: obj.variables.map((item) => AutomatedReasoningPolicyDefinitionVariableFilterSensitiveLog(item)),
    }),
});
const CreateAutomatedReasoningPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
    ...(obj.policyDefinition && {
        policyDefinition: AutomatedReasoningPolicyDefinitionFilterSensitiveLog(obj.policyDefinition),
    }),
});
const CreateAutomatedReasoningPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const CreateAutomatedReasoningPolicyTestCaseRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.guardContent && { guardContent: smithyClient.SENSITIVE_STRING }),
    ...(obj.queryContent && { queryContent: smithyClient.SENSITIVE_STRING }),
});
const CreateAutomatedReasoningPolicyVersionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const ExportAutomatedReasoningPolicyVersionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.policyDefinition && {
        policyDefinition: AutomatedReasoningPolicyDefinitionFilterSensitiveLog(obj.policyDefinition),
    }),
});
const GetAutomatedReasoningPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyAddRuleAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.expression && { expression: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.naturalLanguage && { naturalLanguage: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyAddTypeAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
    ...(obj.values && {
        values: obj.values.map((item) => AutomatedReasoningPolicyDefinitionTypeValueFilterSensitiveLog(item)),
    }),
});
const AutomatedReasoningPolicyAddVariableAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.type && { type: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyDeleteTypeAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyDeleteVariableAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyIngestContentAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.content && { content: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.feedback && { feedback: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.scenarioExpression && { scenarioExpression: smithyClient.SENSITIVE_STRING }),
    ...(obj.feedback && { feedback: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyUpdateRuleAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.expression && { expression: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyAddTypeValueFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyUpdateTypeValueFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyTypeValueAnnotationFilterSensitiveLog = (obj) => {
    if (obj.addTypeValue !== undefined)
        return { addTypeValue: AutomatedReasoningPolicyAddTypeValueFilterSensitiveLog(obj.addTypeValue) };
    if (obj.updateTypeValue !== undefined)
        return { updateTypeValue: AutomatedReasoningPolicyUpdateTypeValueFilterSensitiveLog(obj.updateTypeValue) };
    if (obj.deleteTypeValue !== undefined)
        return { deleteTypeValue: obj.deleteTypeValue };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const AutomatedReasoningPolicyUpdateTypeAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.newName && { newName: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
    ...(obj.values && {
        values: obj.values.map((item) => AutomatedReasoningPolicyTypeValueAnnotationFilterSensitiveLog(item)),
    }),
});
const AutomatedReasoningPolicyUpdateVariableAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.newName && { newName: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyAnnotationFilterSensitiveLog = (obj) => {
    if (obj.addType !== undefined)
        return { addType: AutomatedReasoningPolicyAddTypeAnnotationFilterSensitiveLog(obj.addType) };
    if (obj.updateType !== undefined)
        return { updateType: AutomatedReasoningPolicyUpdateTypeAnnotationFilterSensitiveLog(obj.updateType) };
    if (obj.deleteType !== undefined)
        return { deleteType: AutomatedReasoningPolicyDeleteTypeAnnotationFilterSensitiveLog(obj.deleteType) };
    if (obj.addVariable !== undefined)
        return { addVariable: AutomatedReasoningPolicyAddVariableAnnotationFilterSensitiveLog(obj.addVariable) };
    if (obj.updateVariable !== undefined)
        return { updateVariable: AutomatedReasoningPolicyUpdateVariableAnnotationFilterSensitiveLog(obj.updateVariable) };
    if (obj.deleteVariable !== undefined)
        return { deleteVariable: AutomatedReasoningPolicyDeleteVariableAnnotationFilterSensitiveLog(obj.deleteVariable) };
    if (obj.addRule !== undefined)
        return { addRule: AutomatedReasoningPolicyAddRuleAnnotationFilterSensitiveLog(obj.addRule) };
    if (obj.updateRule !== undefined)
        return { updateRule: AutomatedReasoningPolicyUpdateRuleAnnotationFilterSensitiveLog(obj.updateRule) };
    if (obj.deleteRule !== undefined)
        return { deleteRule: obj.deleteRule };
    if (obj.addRuleFromNaturalLanguage !== undefined)
        return {
            addRuleFromNaturalLanguage: AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotationFilterSensitiveLog(obj.addRuleFromNaturalLanguage),
        };
    if (obj.updateFromRulesFeedback !== undefined)
        return {
            updateFromRulesFeedback: AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotationFilterSensitiveLog(obj.updateFromRulesFeedback),
        };
    if (obj.updateFromScenarioFeedback !== undefined)
        return {
            updateFromScenarioFeedback: AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotationFilterSensitiveLog(obj.updateFromScenarioFeedback),
        };
    if (obj.ingestContent !== undefined)
        return { ingestContent: AutomatedReasoningPolicyIngestContentAnnotationFilterSensitiveLog(obj.ingestContent) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const GetAutomatedReasoningPolicyAnnotationsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.annotations && {
        annotations: obj.annotations.map((item) => AutomatedReasoningPolicyAnnotationFilterSensitiveLog(item)),
    }),
});
const GetAutomatedReasoningPolicyBuildWorkflowResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.documentName && { documentName: smithyClient.SENSITIVE_STRING }),
    ...(obj.documentDescription && { documentDescription: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyAddRuleMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.rule && { rule: AutomatedReasoningPolicyDefinitionRuleFilterSensitiveLog(obj.rule) }),
});
const AutomatedReasoningPolicyAddTypeMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.type && { type: AutomatedReasoningPolicyDefinitionTypeFilterSensitiveLog(obj.type) }),
});
const AutomatedReasoningPolicyAddVariableMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.variable && { variable: AutomatedReasoningPolicyDefinitionVariableFilterSensitiveLog(obj.variable) }),
});
const AutomatedReasoningPolicyDeleteTypeMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyDeleteVariableMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyUpdateRuleMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.rule && { rule: AutomatedReasoningPolicyDefinitionRuleFilterSensitiveLog(obj.rule) }),
});
const AutomatedReasoningPolicyUpdateTypeMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.type && { type: AutomatedReasoningPolicyDefinitionTypeFilterSensitiveLog(obj.type) }),
});
const AutomatedReasoningPolicyUpdateVariableMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.variable && { variable: AutomatedReasoningPolicyDefinitionVariableFilterSensitiveLog(obj.variable) }),
});
const AutomatedReasoningPolicyMutationFilterSensitiveLog = (obj) => {
    if (obj.addType !== undefined)
        return { addType: AutomatedReasoningPolicyAddTypeMutationFilterSensitiveLog(obj.addType) };
    if (obj.updateType !== undefined)
        return { updateType: AutomatedReasoningPolicyUpdateTypeMutationFilterSensitiveLog(obj.updateType) };
    if (obj.deleteType !== undefined)
        return { deleteType: AutomatedReasoningPolicyDeleteTypeMutationFilterSensitiveLog(obj.deleteType) };
    if (obj.addVariable !== undefined)
        return { addVariable: AutomatedReasoningPolicyAddVariableMutationFilterSensitiveLog(obj.addVariable) };
    if (obj.updateVariable !== undefined)
        return { updateVariable: AutomatedReasoningPolicyUpdateVariableMutationFilterSensitiveLog(obj.updateVariable) };
    if (obj.deleteVariable !== undefined)
        return { deleteVariable: AutomatedReasoningPolicyDeleteVariableMutationFilterSensitiveLog(obj.deleteVariable) };
    if (obj.addRule !== undefined)
        return { addRule: AutomatedReasoningPolicyAddRuleMutationFilterSensitiveLog(obj.addRule) };
    if (obj.updateRule !== undefined)
        return { updateRule: AutomatedReasoningPolicyUpdateRuleMutationFilterSensitiveLog(obj.updateRule) };
    if (obj.deleteRule !== undefined)
        return { deleteRule: obj.deleteRule };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const AutomatedReasoningPolicyBuildStepContextFilterSensitiveLog = (obj) => {
    if (obj.planning !== undefined)
        return { planning: obj.planning };
    if (obj.mutation !== undefined)
        return { mutation: AutomatedReasoningPolicyMutationFilterSensitiveLog(obj.mutation) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const AutomatedReasoningPolicyDefinitionElementFilterSensitiveLog = (obj) => {
    if (obj.policyDefinitionVariable !== undefined)
        return {
            policyDefinitionVariable: AutomatedReasoningPolicyDefinitionVariableFilterSensitiveLog(obj.policyDefinitionVariable),
        };
    if (obj.policyDefinitionType !== undefined)
        return { policyDefinitionType: AutomatedReasoningPolicyDefinitionTypeFilterSensitiveLog(obj.policyDefinitionType) };
    if (obj.policyDefinitionRule !== undefined)
        return { policyDefinitionRule: AutomatedReasoningPolicyDefinitionRuleFilterSensitiveLog(obj.policyDefinitionRule) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const AutomatedReasoningPolicyBuildStepFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.context && { context: AutomatedReasoningPolicyBuildStepContextFilterSensitiveLog(obj.context) }),
    ...(obj.priorElement && {
        priorElement: AutomatedReasoningPolicyDefinitionElementFilterSensitiveLog(obj.priorElement),
    }),
});
const AutomatedReasoningPolicyBuildLogEntryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.annotation && { annotation: AutomatedReasoningPolicyAnnotationFilterSensitiveLog(obj.annotation) }),
    ...(obj.buildSteps && {
        buildSteps: obj.buildSteps.map((item) => AutomatedReasoningPolicyBuildStepFilterSensitiveLog(item)),
    }),
});
const AutomatedReasoningPolicyBuildLogFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.entries && {
        entries: obj.entries.map((item) => AutomatedReasoningPolicyBuildLogEntryFilterSensitiveLog(item)),
    }),
});
const AutomatedReasoningPolicyDisjointRuleSetFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.variables && { variables: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyDefinitionTypeValuePairFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.typeName && { typeName: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyDefinitionQualityReportFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.unusedTypes && { unusedTypes: smithyClient.SENSITIVE_STRING }),
    ...(obj.unusedTypeValues && {
        unusedTypeValues: obj.unusedTypeValues.map((item) => AutomatedReasoningPolicyDefinitionTypeValuePairFilterSensitiveLog(item)),
    }),
    ...(obj.unusedVariables && { unusedVariables: smithyClient.SENSITIVE_STRING }),
    ...(obj.disjointRuleSets && {
        disjointRuleSets: obj.disjointRuleSets.map((item) => AutomatedReasoningPolicyDisjointRuleSetFilterSensitiveLog(item)),
    }),
});
const AutomatedReasoningPolicyBuildResultAssetsFilterSensitiveLog = (obj) => {
    if (obj.policyDefinition !== undefined)
        return { policyDefinition: AutomatedReasoningPolicyDefinitionFilterSensitiveLog(obj.policyDefinition) };
    if (obj.qualityReport !== undefined)
        return { qualityReport: AutomatedReasoningPolicyDefinitionQualityReportFilterSensitiveLog(obj.qualityReport) };
    if (obj.buildLog !== undefined)
        return { buildLog: AutomatedReasoningPolicyBuildLogFilterSensitiveLog(obj.buildLog) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const GetAutomatedReasoningPolicyBuildWorkflowResultAssetsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.buildWorkflowAssets && {
        buildWorkflowAssets: AutomatedReasoningPolicyBuildResultAssetsFilterSensitiveLog(obj.buildWorkflowAssets),
    }),
});
const AutomatedReasoningPolicyScenarioFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.expression && { expression: smithyClient.SENSITIVE_STRING }),
    ...(obj.alternateExpression && { alternateExpression: smithyClient.SENSITIVE_STRING }),
});
const GetAutomatedReasoningPolicyNextScenarioResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.scenario && { scenario: AutomatedReasoningPolicyScenarioFilterSensitiveLog(obj.scenario) }),
});
const AutomatedReasoningPolicyTestCaseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.guardContent && { guardContent: smithyClient.SENSITIVE_STRING }),
    ...(obj.queryContent && { queryContent: smithyClient.SENSITIVE_STRING }),
});
const GetAutomatedReasoningPolicyTestCaseResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.testCase && { testCase: AutomatedReasoningPolicyTestCaseFilterSensitiveLog(obj.testCase) }),
});
const AutomatedReasoningLogicStatementFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.logic && { logic: smithyClient.SENSITIVE_STRING }),
    ...(obj.naturalLanguage && { naturalLanguage: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningCheckLogicWarningFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.premises && {
        premises: obj.premises.map((item) => AutomatedReasoningLogicStatementFilterSensitiveLog(item)),
    }),
    ...(obj.claims && { claims: obj.claims.map((item) => AutomatedReasoningLogicStatementFilterSensitiveLog(item)) }),
});
const AutomatedReasoningCheckInputTextReferenceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.text && { text: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningCheckTranslationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.premises && {
        premises: obj.premises.map((item) => AutomatedReasoningLogicStatementFilterSensitiveLog(item)),
    }),
    ...(obj.claims && { claims: obj.claims.map((item) => AutomatedReasoningLogicStatementFilterSensitiveLog(item)) }),
    ...(obj.untranslatedPremises && {
        untranslatedPremises: obj.untranslatedPremises.map((item) => AutomatedReasoningCheckInputTextReferenceFilterSensitiveLog(item)),
    }),
    ...(obj.untranslatedClaims && {
        untranslatedClaims: obj.untranslatedClaims.map((item) => AutomatedReasoningCheckInputTextReferenceFilterSensitiveLog(item)),
    }),
});
const AutomatedReasoningCheckImpossibleFindingFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.translation && { translation: AutomatedReasoningCheckTranslationFilterSensitiveLog(obj.translation) }),
    ...(obj.logicWarning && { logicWarning: AutomatedReasoningCheckLogicWarningFilterSensitiveLog(obj.logicWarning) }),
});
const AutomatedReasoningCheckInvalidFindingFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.translation && { translation: AutomatedReasoningCheckTranslationFilterSensitiveLog(obj.translation) }),
    ...(obj.logicWarning && { logicWarning: AutomatedReasoningCheckLogicWarningFilterSensitiveLog(obj.logicWarning) }),
});
const AutomatedReasoningCheckScenarioFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.statements && {
        statements: obj.statements.map((item) => AutomatedReasoningLogicStatementFilterSensitiveLog(item)),
    }),
});
const AutomatedReasoningCheckSatisfiableFindingFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.translation && { translation: AutomatedReasoningCheckTranslationFilterSensitiveLog(obj.translation) }),
    ...(obj.claimsTrueScenario && {
        claimsTrueScenario: AutomatedReasoningCheckScenarioFilterSensitiveLog(obj.claimsTrueScenario),
    }),
    ...(obj.claimsFalseScenario && {
        claimsFalseScenario: AutomatedReasoningCheckScenarioFilterSensitiveLog(obj.claimsFalseScenario),
    }),
    ...(obj.logicWarning && { logicWarning: AutomatedReasoningCheckLogicWarningFilterSensitiveLog(obj.logicWarning) }),
});
const AutomatedReasoningCheckTranslationOptionFilterSensitiveLog = (obj) => ({
    ...obj,
});
const AutomatedReasoningCheckTranslationAmbiguousFindingFilterSensitiveLog = (obj) => ({
    ...obj,
});
const AutomatedReasoningCheckValidFindingFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.translation && { translation: AutomatedReasoningCheckTranslationFilterSensitiveLog(obj.translation) }),
    ...(obj.claimsTrueScenario && {
        claimsTrueScenario: AutomatedReasoningCheckScenarioFilterSensitiveLog(obj.claimsTrueScenario),
    }),
    ...(obj.logicWarning && { logicWarning: AutomatedReasoningCheckLogicWarningFilterSensitiveLog(obj.logicWarning) }),
});
const AutomatedReasoningCheckFindingFilterSensitiveLog = (obj) => {
    if (obj.valid !== undefined)
        return { valid: AutomatedReasoningCheckValidFindingFilterSensitiveLog(obj.valid) };
    if (obj.invalid !== undefined)
        return { invalid: AutomatedReasoningCheckInvalidFindingFilterSensitiveLog(obj.invalid) };
    if (obj.satisfiable !== undefined)
        return { satisfiable: AutomatedReasoningCheckSatisfiableFindingFilterSensitiveLog(obj.satisfiable) };
    if (obj.impossible !== undefined)
        return { impossible: AutomatedReasoningCheckImpossibleFindingFilterSensitiveLog(obj.impossible) };
    if (obj.translationAmbiguous !== undefined)
        return {
            translationAmbiguous: AutomatedReasoningCheckTranslationAmbiguousFindingFilterSensitiveLog(obj.translationAmbiguous),
        };
    if (obj.tooComplex !== undefined)
        return { tooComplex: obj.tooComplex };
    if (obj.noTranslations !== undefined)
        return { noTranslations: obj.noTranslations };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const AutomatedReasoningPolicyTestResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.testCase && { testCase: AutomatedReasoningPolicyTestCaseFilterSensitiveLog(obj.testCase) }),
    ...(obj.testFindings && {
        testFindings: obj.testFindings.map((item) => AutomatedReasoningCheckFindingFilterSensitiveLog(item)),
    }),
});
const GetAutomatedReasoningPolicyTestResultResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.testResult && { testResult: AutomatedReasoningPolicyTestResultFilterSensitiveLog(obj.testResult) }),
});
const AutomatedReasoningPolicySummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const ListAutomatedReasoningPoliciesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.automatedReasoningPolicySummaries && {
        automatedReasoningPolicySummaries: obj.automatedReasoningPolicySummaries.map((item) => AutomatedReasoningPolicySummaryFilterSensitiveLog(item)),
    }),
});
const ListAutomatedReasoningPolicyTestCasesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.testCases && {
        testCases: obj.testCases.map((item) => AutomatedReasoningPolicyTestCaseFilterSensitiveLog(item)),
    }),
});
const ListAutomatedReasoningPolicyTestResultsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.testResults && {
        testResults: obj.testResults.map((item) => AutomatedReasoningPolicyTestResultFilterSensitiveLog(item)),
    }),
});
const AutomatedReasoningPolicyBuildWorkflowDocumentFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.document && { document: smithyClient.SENSITIVE_STRING }),
    ...(obj.documentName && { documentName: smithyClient.SENSITIVE_STRING }),
    ...(obj.documentDescription && { documentDescription: smithyClient.SENSITIVE_STRING }),
});
const AutomatedReasoningPolicyBuildWorkflowRepairContentFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.annotations && {
        annotations: obj.annotations.map((item) => AutomatedReasoningPolicyAnnotationFilterSensitiveLog(item)),
    }),
});
const AutomatedReasoningPolicyWorkflowTypeContentFilterSensitiveLog = (obj) => {
    if (obj.documents !== undefined)
        return {
            documents: obj.documents.map((item) => AutomatedReasoningPolicyBuildWorkflowDocumentFilterSensitiveLog(item)),
        };
    if (obj.policyRepairAssets !== undefined)
        return {
            policyRepairAssets: AutomatedReasoningPolicyBuildWorkflowRepairContentFilterSensitiveLog(obj.policyRepairAssets),
        };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const AutomatedReasoningPolicyBuildWorkflowSourceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.policyDefinition && {
        policyDefinition: AutomatedReasoningPolicyDefinitionFilterSensitiveLog(obj.policyDefinition),
    }),
    ...(obj.workflowContent && {
        workflowContent: AutomatedReasoningPolicyWorkflowTypeContentFilterSensitiveLog(obj.workflowContent),
    }),
});
const StartAutomatedReasoningPolicyBuildWorkflowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.sourceContent && {
        sourceContent: AutomatedReasoningPolicyBuildWorkflowSourceFilterSensitiveLog(obj.sourceContent),
    }),
});
const UpdateAutomatedReasoningPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.policyDefinition && {
        policyDefinition: AutomatedReasoningPolicyDefinitionFilterSensitiveLog(obj.policyDefinition),
    }),
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const UpdateAutomatedReasoningPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
});
const UpdateAutomatedReasoningPolicyAnnotationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.annotations && {
        annotations: obj.annotations.map((item) => AutomatedReasoningPolicyAnnotationFilterSensitiveLog(item)),
    }),
});
const UpdateAutomatedReasoningPolicyTestCaseRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.guardContent && { guardContent: smithyClient.SENSITIVE_STRING }),
    ...(obj.queryContent && { queryContent: smithyClient.SENSITIVE_STRING }),
});
const RequestMetadataBaseFiltersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.equals && { equals: smithyClient.SENSITIVE_STRING }),
    ...(obj.notEquals && { notEquals: smithyClient.SENSITIVE_STRING }),
});
const RequestMetadataFiltersFilterSensitiveLog = (obj) => {
    if (obj.equals !== undefined)
        return { equals: smithyClient.SENSITIVE_STRING };
    if (obj.notEquals !== undefined)
        return { notEquals: smithyClient.SENSITIVE_STRING };
    if (obj.andAll !== undefined)
        return { andAll: obj.andAll.map((item) => RequestMetadataBaseFiltersFilterSensitiveLog(item)) };
    if (obj.orAll !== undefined)
        return { orAll: obj.orAll.map((item) => RequestMetadataBaseFiltersFilterSensitiveLog(item)) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const InvocationLogsConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.invocationLogSource && { invocationLogSource: obj.invocationLogSource }),
    ...(obj.requestMetadataFilters && {
        requestMetadataFilters: RequestMetadataFiltersFilterSensitiveLog(obj.requestMetadataFilters),
    }),
});
const TrainingDataConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.invocationLogsConfig && {
        invocationLogsConfig: InvocationLogsConfigFilterSensitiveLog(obj.invocationLogsConfig),
    }),
});
const GetCustomModelResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.trainingDataConfig && { trainingDataConfig: TrainingDataConfigFilterSensitiveLog(obj.trainingDataConfig) }),
    ...(obj.customizationConfig && { customizationConfig: obj.customizationConfig }),
});
const BatchDeleteEvaluationJobRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobIdentifiers && { jobIdentifiers: smithyClient.SENSITIVE_STRING }),
});
const BatchDeleteEvaluationJobErrorFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobIdentifier && { jobIdentifier: smithyClient.SENSITIVE_STRING }),
});
const BatchDeleteEvaluationJobItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobIdentifier && { jobIdentifier: smithyClient.SENSITIVE_STRING }),
});
const BatchDeleteEvaluationJobResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.errors && { errors: obj.errors.map((item) => BatchDeleteEvaluationJobErrorFilterSensitiveLog(item)) }),
    ...(obj.evaluationJobs && {
        evaluationJobs: obj.evaluationJobs.map((item) => BatchDeleteEvaluationJobItemFilterSensitiveLog(item)),
    }),
});
const CustomMetricDefinitionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.ratingScale && { ratingScale: obj.ratingScale.map((item) => item) }),
});
const AutomatedEvaluationCustomMetricSourceFilterSensitiveLog = (obj) => {
    if (obj.customMetricDefinition !== undefined)
        return { customMetricDefinition: smithyClient.SENSITIVE_STRING };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const AutomatedEvaluationCustomMetricConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.customMetrics && {
        customMetrics: obj.customMetrics.map((item) => AutomatedEvaluationCustomMetricSourceFilterSensitiveLog(item)),
    }),
});
const EvaluationDatasetFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.datasetLocation && { datasetLocation: obj.datasetLocation }),
});
const EvaluationDatasetMetricConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.dataset && { dataset: EvaluationDatasetFilterSensitiveLog(obj.dataset) }),
    ...(obj.metricNames && { metricNames: smithyClient.SENSITIVE_STRING }),
});
const AutomatedEvaluationConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.datasetMetricConfigs && {
        datasetMetricConfigs: obj.datasetMetricConfigs.map((item) => EvaluationDatasetMetricConfigFilterSensitiveLog(item)),
    }),
    ...(obj.evaluatorModelConfig && { evaluatorModelConfig: obj.evaluatorModelConfig }),
    ...(obj.customMetricConfig && {
        customMetricConfig: AutomatedEvaluationCustomMetricConfigFilterSensitiveLog(obj.customMetricConfig),
    }),
});
const HumanEvaluationCustomMetricFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const HumanWorkflowConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.instructions && { instructions: smithyClient.SENSITIVE_STRING }),
});
const HumanEvaluationConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.humanWorkflowConfig && {
        humanWorkflowConfig: HumanWorkflowConfigFilterSensitiveLog(obj.humanWorkflowConfig),
    }),
    ...(obj.customMetrics && {
        customMetrics: obj.customMetrics.map((item) => HumanEvaluationCustomMetricFilterSensitiveLog(item)),
    }),
    ...(obj.datasetMetricConfigs && {
        datasetMetricConfigs: obj.datasetMetricConfigs.map((item) => EvaluationDatasetMetricConfigFilterSensitiveLog(item)),
    }),
});
const EvaluationConfigFilterSensitiveLog = (obj) => {
    if (obj.automated !== undefined)
        return { automated: AutomatedEvaluationConfigFilterSensitiveLog(obj.automated) };
    if (obj.human !== undefined)
        return { human: HumanEvaluationConfigFilterSensitiveLog(obj.human) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const EvaluationBedrockModelFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inferenceParams && { inferenceParams: smithyClient.SENSITIVE_STRING }),
});
const EvaluationModelConfigFilterSensitiveLog = (obj) => {
    if (obj.bedrockModel !== undefined)
        return { bedrockModel: EvaluationBedrockModelFilterSensitiveLog(obj.bedrockModel) };
    if (obj.precomputedInferenceSource !== undefined)
        return { precomputedInferenceSource: obj.precomputedInferenceSource };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const PromptTemplateFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.textPromptTemplate && { textPromptTemplate: smithyClient.SENSITIVE_STRING }),
});
const ExternalSourcesGenerationConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.promptTemplate && { promptTemplate: PromptTemplateFilterSensitiveLog(obj.promptTemplate) }),
});
const ByteContentDocFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.identifier && { identifier: smithyClient.SENSITIVE_STRING }),
    ...(obj.data && { data: smithyClient.SENSITIVE_STRING }),
});
const ExternalSourceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.byteContent && { byteContent: ByteContentDocFilterSensitiveLog(obj.byteContent) }),
});
const ExternalSourcesRetrieveAndGenerateConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.sources && { sources: obj.sources.map((item) => ExternalSourceFilterSensitiveLog(item)) }),
    ...(obj.generationConfiguration && {
        generationConfiguration: ExternalSourcesGenerationConfigurationFilterSensitiveLog(obj.generationConfiguration),
    }),
});
const GenerationConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.promptTemplate && { promptTemplate: PromptTemplateFilterSensitiveLog(obj.promptTemplate) }),
});
const MetadataAttributeSchemaFilterSensitiveLog = (obj) => ({
    ...obj,
});
const ImplicitFilterConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.metadataAttributes && { metadataAttributes: smithyClient.SENSITIVE_STRING }),
});
const RerankingMetadataSelectiveModeConfigurationFilterSensitiveLog = (obj) => {
    if (obj.fieldsToInclude !== undefined)
        return { fieldsToInclude: smithyClient.SENSITIVE_STRING };
    if (obj.fieldsToExclude !== undefined)
        return { fieldsToExclude: smithyClient.SENSITIVE_STRING };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const MetadataConfigurationForRerankingFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.selectiveModeConfiguration && {
        selectiveModeConfiguration: RerankingMetadataSelectiveModeConfigurationFilterSensitiveLog(obj.selectiveModeConfiguration),
    }),
});
const VectorSearchBedrockRerankingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.metadataConfiguration && {
        metadataConfiguration: MetadataConfigurationForRerankingFilterSensitiveLog(obj.metadataConfiguration),
    }),
});
const VectorSearchRerankingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.bedrockRerankingConfiguration && {
        bedrockRerankingConfiguration: VectorSearchBedrockRerankingConfigurationFilterSensitiveLog(obj.bedrockRerankingConfiguration),
    }),
});
const GetEvaluationJobRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobIdentifier && { jobIdentifier: smithyClient.SENSITIVE_STRING }),
});
const StopEvaluationJobRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobIdentifier && { jobIdentifier: smithyClient.SENSITIVE_STRING }),
});
const GuardrailContentFilterConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inputModalities && { inputModalities: smithyClient.SENSITIVE_STRING }),
    ...(obj.outputModalities && { outputModalities: smithyClient.SENSITIVE_STRING }),
    ...(obj.inputAction && { inputAction: smithyClient.SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: smithyClient.SENSITIVE_STRING }),
});
const GuardrailContentFiltersTierConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.tierName && { tierName: smithyClient.SENSITIVE_STRING }),
});
const GuardrailContentPolicyConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.filtersConfig && {
        filtersConfig: obj.filtersConfig.map((item) => GuardrailContentFilterConfigFilterSensitiveLog(item)),
    }),
    ...(obj.tierConfig && { tierConfig: GuardrailContentFiltersTierConfigFilterSensitiveLog(obj.tierConfig) }),
});
const GuardrailContextualGroundingFilterConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.action && { action: smithyClient.SENSITIVE_STRING }),
});
const GuardrailContextualGroundingPolicyConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.filtersConfig && {
        filtersConfig: obj.filtersConfig.map((item) => GuardrailContextualGroundingFilterConfigFilterSensitiveLog(item)),
    }),
});
const GuardrailTopicsTierConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.tierName && { tierName: smithyClient.SENSITIVE_STRING }),
});
const GuardrailTopicConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.definition && { definition: smithyClient.SENSITIVE_STRING }),
    ...(obj.examples && { examples: smithyClient.SENSITIVE_STRING }),
    ...(obj.inputAction && { inputAction: smithyClient.SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: smithyClient.SENSITIVE_STRING }),
});
const GuardrailTopicPolicyConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.topicsConfig && {
        topicsConfig: obj.topicsConfig.map((item) => GuardrailTopicConfigFilterSensitiveLog(item)),
    }),
    ...(obj.tierConfig && { tierConfig: GuardrailTopicsTierConfigFilterSensitiveLog(obj.tierConfig) }),
});

const GuardrailManagedWordsType = {
    PROFANITY: "PROFANITY",
};
const GuardrailStatus = {
    CREATING: "CREATING",
    DELETING: "DELETING",
    FAILED: "FAILED",
    READY: "READY",
    UPDATING: "UPDATING",
    VERSIONING: "VERSIONING",
};
exports.InferenceProfileModelSource = void 0;
(function (InferenceProfileModelSource) {
    InferenceProfileModelSource.visit = (value, visitor) => {
        if (value.copyFrom !== undefined)
            return visitor.copyFrom(value.copyFrom);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.InferenceProfileModelSource || (exports.InferenceProfileModelSource = {}));
const InferenceProfileStatus = {
    ACTIVE: "ACTIVE",
};
const InferenceProfileType = {
    APPLICATION: "APPLICATION",
    SYSTEM_DEFINED: "SYSTEM_DEFINED",
};
const ModelCopyJobStatus = {
    COMPLETED: "Completed",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
};
const ModelImportJobStatus = {
    COMPLETED: "Completed",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
};
const S3InputFormat = {
    JSONL: "JSONL",
};
exports.ModelInvocationJobInputDataConfig = void 0;
(function (ModelInvocationJobInputDataConfig) {
    ModelInvocationJobInputDataConfig.visit = (value, visitor) => {
        if (value.s3InputDataConfig !== undefined)
            return visitor.s3InputDataConfig(value.s3InputDataConfig);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.ModelInvocationJobInputDataConfig || (exports.ModelInvocationJobInputDataConfig = {}));
exports.ModelInvocationJobOutputDataConfig = void 0;
(function (ModelInvocationJobOutputDataConfig) {
    ModelInvocationJobOutputDataConfig.visit = (value, visitor) => {
        if (value.s3OutputDataConfig !== undefined)
            return visitor.s3OutputDataConfig(value.s3OutputDataConfig);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.ModelInvocationJobOutputDataConfig || (exports.ModelInvocationJobOutputDataConfig = {}));
const ModelInvocationJobStatus = {
    COMPLETED: "Completed",
    EXPIRED: "Expired",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PARTIALLY_COMPLETED: "PartiallyCompleted",
    SCHEDULED: "Scheduled",
    STOPPED: "Stopped",
    STOPPING: "Stopping",
    SUBMITTED: "Submitted",
    VALIDATING: "Validating",
};
const ModelCustomization = {
    CONTINUED_PRE_TRAINING: "CONTINUED_PRE_TRAINING",
    DISTILLATION: "DISTILLATION",
    FINE_TUNING: "FINE_TUNING",
};
const InferenceType = {
    ON_DEMAND: "ON_DEMAND",
    PROVISIONED: "PROVISIONED",
};
const ModelModality = {
    EMBEDDING: "EMBEDDING",
    IMAGE: "IMAGE",
    TEXT: "TEXT",
};
const FoundationModelLifecycleStatus = {
    ACTIVE: "ACTIVE",
    LEGACY: "LEGACY",
};
const PromptRouterStatus = {
    AVAILABLE: "AVAILABLE",
};
const PromptRouterType = {
    CUSTOM: "custom",
    DEFAULT: "default",
};
const CommitmentDuration = {
    ONE_MONTH: "OneMonth",
    SIX_MONTHS: "SixMonths",
};
const ProvisionedModelStatus = {
    CREATING: "Creating",
    FAILED: "Failed",
    IN_SERVICE: "InService",
    UPDATING: "Updating",
};
const SortByProvisionedModels = {
    CREATION_TIME: "CreationTime",
};
const AuthorizationStatus = {
    AUTHORIZED: "AUTHORIZED",
    NOT_AUTHORIZED: "NOT_AUTHORIZED",
};
const EntitlementAvailability = {
    AVAILABLE: "AVAILABLE",
    NOT_AVAILABLE: "NOT_AVAILABLE",
};
const RegionAvailability = {
    AVAILABLE: "AVAILABLE",
    NOT_AVAILABLE: "NOT_AVAILABLE",
};
const OfferType = {
    ALL: "ALL",
    PUBLIC: "PUBLIC",
};
const ModelCustomizationJobStatus = {
    COMPLETED: "Completed",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    STOPPED: "Stopped",
    STOPPING: "Stopping",
};
const JobStatusDetails = {
    COMPLETED: "Completed",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    NOT_STARTED: "NotStarted",
    STOPPED: "Stopped",
    STOPPING: "Stopping",
};
const FineTuningJobStatus = {
    COMPLETED: "Completed",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    STOPPED: "Stopped",
    STOPPING: "Stopping",
};
exports.RetrievalFilter = void 0;
(function (RetrievalFilter) {
    RetrievalFilter.visit = (value, visitor) => {
        if (value.equals !== undefined)
            return visitor.equals(value.equals);
        if (value.notEquals !== undefined)
            return visitor.notEquals(value.notEquals);
        if (value.greaterThan !== undefined)
            return visitor.greaterThan(value.greaterThan);
        if (value.greaterThanOrEquals !== undefined)
            return visitor.greaterThanOrEquals(value.greaterThanOrEquals);
        if (value.lessThan !== undefined)
            return visitor.lessThan(value.lessThan);
        if (value.lessThanOrEquals !== undefined)
            return visitor.lessThanOrEquals(value.lessThanOrEquals);
        if (value.in !== undefined)
            return visitor.in(value.in);
        if (value.notIn !== undefined)
            return visitor.notIn(value.notIn);
        if (value.startsWith !== undefined)
            return visitor.startsWith(value.startsWith);
        if (value.listContains !== undefined)
            return visitor.listContains(value.listContains);
        if (value.stringContains !== undefined)
            return visitor.stringContains(value.stringContains);
        if (value.andAll !== undefined)
            return visitor.andAll(value.andAll);
        if (value.orAll !== undefined)
            return visitor.orAll(value.orAll);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.RetrievalFilter || (exports.RetrievalFilter = {}));
exports.KnowledgeBaseConfig = void 0;
(function (KnowledgeBaseConfig) {
    KnowledgeBaseConfig.visit = (value, visitor) => {
        if (value.retrieveConfig !== undefined)
            return visitor.retrieveConfig(value.retrieveConfig);
        if (value.retrieveAndGenerateConfig !== undefined)
            return visitor.retrieveAndGenerateConfig(value.retrieveAndGenerateConfig);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.KnowledgeBaseConfig || (exports.KnowledgeBaseConfig = {}));
exports.RAGConfig = void 0;
(function (RAGConfig) {
    RAGConfig.visit = (value, visitor) => {
        if (value.knowledgeBaseConfig !== undefined)
            return visitor.knowledgeBaseConfig(value.knowledgeBaseConfig);
        if (value.precomputedRagSourceConfig !== undefined)
            return visitor.precomputedRagSourceConfig(value.precomputedRagSourceConfig);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.RAGConfig || (exports.RAGConfig = {}));
exports.EvaluationInferenceConfig = void 0;
(function (EvaluationInferenceConfig) {
    EvaluationInferenceConfig.visit = (value, visitor) => {
        if (value.models !== undefined)
            return visitor.models(value.models);
        if (value.ragConfigs !== undefined)
            return visitor.ragConfigs(value.ragConfigs);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(exports.EvaluationInferenceConfig || (exports.EvaluationInferenceConfig = {}));
const GuardrailManagedWordsConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inputAction && { inputAction: smithyClient.SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: smithyClient.SENSITIVE_STRING }),
});
const GuardrailWordConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inputAction && { inputAction: smithyClient.SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: smithyClient.SENSITIVE_STRING }),
});
const GuardrailWordPolicyConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.wordsConfig && { wordsConfig: obj.wordsConfig.map((item) => GuardrailWordConfigFilterSensitiveLog(item)) }),
    ...(obj.managedWordListsConfig && {
        managedWordListsConfig: obj.managedWordListsConfig.map((item) => GuardrailManagedWordsConfigFilterSensitiveLog(item)),
    }),
});
const CreateGuardrailRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
    ...(obj.topicPolicyConfig && {
        topicPolicyConfig: GuardrailTopicPolicyConfigFilterSensitiveLog(obj.topicPolicyConfig),
    }),
    ...(obj.contentPolicyConfig && {
        contentPolicyConfig: GuardrailContentPolicyConfigFilterSensitiveLog(obj.contentPolicyConfig),
    }),
    ...(obj.wordPolicyConfig && { wordPolicyConfig: GuardrailWordPolicyConfigFilterSensitiveLog(obj.wordPolicyConfig) }),
    ...(obj.contextualGroundingPolicyConfig && {
        contextualGroundingPolicyConfig: GuardrailContextualGroundingPolicyConfigFilterSensitiveLog(obj.contextualGroundingPolicyConfig),
    }),
    ...(obj.blockedInputMessaging && { blockedInputMessaging: smithyClient.SENSITIVE_STRING }),
    ...(obj.blockedOutputsMessaging && { blockedOutputsMessaging: smithyClient.SENSITIVE_STRING }),
});
const CreateGuardrailVersionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const GuardrailContentFilterFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inputModalities && { inputModalities: smithyClient.SENSITIVE_STRING }),
    ...(obj.outputModalities && { outputModalities: smithyClient.SENSITIVE_STRING }),
    ...(obj.inputAction && { inputAction: smithyClient.SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: smithyClient.SENSITIVE_STRING }),
});
const GuardrailContentFiltersTierFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.tierName && { tierName: smithyClient.SENSITIVE_STRING }),
});
const GuardrailContentPolicyFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.filters && { filters: obj.filters.map((item) => GuardrailContentFilterFilterSensitiveLog(item)) }),
    ...(obj.tier && { tier: GuardrailContentFiltersTierFilterSensitiveLog(obj.tier) }),
});
const GuardrailContextualGroundingFilterFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.action && { action: smithyClient.SENSITIVE_STRING }),
});
const GuardrailContextualGroundingPolicyFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.filters && {
        filters: obj.filters.map((item) => GuardrailContextualGroundingFilterFilterSensitiveLog(item)),
    }),
});
const GuardrailTopicsTierFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.tierName && { tierName: smithyClient.SENSITIVE_STRING }),
});
const GuardrailTopicFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.definition && { definition: smithyClient.SENSITIVE_STRING }),
    ...(obj.examples && { examples: smithyClient.SENSITIVE_STRING }),
    ...(obj.inputAction && { inputAction: smithyClient.SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: smithyClient.SENSITIVE_STRING }),
});
const GuardrailTopicPolicyFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.topics && { topics: obj.topics.map((item) => GuardrailTopicFilterSensitiveLog(item)) }),
    ...(obj.tier && { tier: GuardrailTopicsTierFilterSensitiveLog(obj.tier) }),
});
const GuardrailManagedWordsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inputAction && { inputAction: smithyClient.SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: smithyClient.SENSITIVE_STRING }),
});
const GuardrailWordFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inputAction && { inputAction: smithyClient.SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: smithyClient.SENSITIVE_STRING }),
});
const GuardrailWordPolicyFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.words && { words: obj.words.map((item) => GuardrailWordFilterSensitiveLog(item)) }),
    ...(obj.managedWordLists && {
        managedWordLists: obj.managedWordLists.map((item) => GuardrailManagedWordsFilterSensitiveLog(item)),
    }),
});
const GetGuardrailResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
    ...(obj.topicPolicy && { topicPolicy: GuardrailTopicPolicyFilterSensitiveLog(obj.topicPolicy) }),
    ...(obj.contentPolicy && { contentPolicy: GuardrailContentPolicyFilterSensitiveLog(obj.contentPolicy) }),
    ...(obj.wordPolicy && { wordPolicy: GuardrailWordPolicyFilterSensitiveLog(obj.wordPolicy) }),
    ...(obj.contextualGroundingPolicy && {
        contextualGroundingPolicy: GuardrailContextualGroundingPolicyFilterSensitiveLog(obj.contextualGroundingPolicy),
    }),
    ...(obj.statusReasons && { statusReasons: smithyClient.SENSITIVE_STRING }),
    ...(obj.failureRecommendations && { failureRecommendations: smithyClient.SENSITIVE_STRING }),
    ...(obj.blockedInputMessaging && { blockedInputMessaging: smithyClient.SENSITIVE_STRING }),
    ...(obj.blockedOutputsMessaging && { blockedOutputsMessaging: smithyClient.SENSITIVE_STRING }),
});
const GuardrailSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const ListGuardrailsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.guardrails && { guardrails: obj.guardrails.map((item) => GuardrailSummaryFilterSensitiveLog(item)) }),
});
const UpdateGuardrailRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: smithyClient.SENSITIVE_STRING }),
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
    ...(obj.topicPolicyConfig && {
        topicPolicyConfig: GuardrailTopicPolicyConfigFilterSensitiveLog(obj.topicPolicyConfig),
    }),
    ...(obj.contentPolicyConfig && {
        contentPolicyConfig: GuardrailContentPolicyConfigFilterSensitiveLog(obj.contentPolicyConfig),
    }),
    ...(obj.wordPolicyConfig && { wordPolicyConfig: GuardrailWordPolicyConfigFilterSensitiveLog(obj.wordPolicyConfig) }),
    ...(obj.contextualGroundingPolicyConfig && {
        contextualGroundingPolicyConfig: GuardrailContextualGroundingPolicyConfigFilterSensitiveLog(obj.contextualGroundingPolicyConfig),
    }),
    ...(obj.blockedInputMessaging && { blockedInputMessaging: smithyClient.SENSITIVE_STRING }),
    ...(obj.blockedOutputsMessaging && { blockedOutputsMessaging: smithyClient.SENSITIVE_STRING }),
});
const CreateInferenceProfileRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
    ...(obj.modelSource && { modelSource: obj.modelSource }),
});
const GetInferenceProfileResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const InferenceProfileSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const ListInferenceProfilesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inferenceProfileSummaries && {
        inferenceProfileSummaries: obj.inferenceProfileSummaries.map((item) => InferenceProfileSummaryFilterSensitiveLog(item)),
    }),
});
const GetModelInvocationJobResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.message && { message: smithyClient.SENSITIVE_STRING }),
    ...(obj.inputDataConfig && { inputDataConfig: obj.inputDataConfig }),
    ...(obj.outputDataConfig && { outputDataConfig: obj.outputDataConfig }),
});
const ModelInvocationJobSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.message && { message: smithyClient.SENSITIVE_STRING }),
    ...(obj.inputDataConfig && { inputDataConfig: obj.inputDataConfig }),
    ...(obj.outputDataConfig && { outputDataConfig: obj.outputDataConfig }),
});
const ListModelInvocationJobsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.invocationJobSummaries && {
        invocationJobSummaries: obj.invocationJobSummaries.map((item) => ModelInvocationJobSummaryFilterSensitiveLog(item)),
    }),
});
const CreatePromptRouterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const GetPromptRouterResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const PromptRouterSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: smithyClient.SENSITIVE_STRING }),
});
const ListPromptRoutersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.promptRouterSummaries && {
        promptRouterSummaries: obj.promptRouterSummaries.map((item) => PromptRouterSummaryFilterSensitiveLog(item)),
    }),
});
const CreateModelCustomizationJobRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.trainingDataConfig && { trainingDataConfig: TrainingDataConfigFilterSensitiveLog(obj.trainingDataConfig) }),
    ...(obj.customizationConfig && { customizationConfig: obj.customizationConfig }),
});
const GetModelCustomizationJobResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.trainingDataConfig && { trainingDataConfig: TrainingDataConfigFilterSensitiveLog(obj.trainingDataConfig) }),
    ...(obj.customizationConfig && { customizationConfig: obj.customizationConfig }),
});
const RetrievalFilterFilterSensitiveLog = (obj) => {
    if (obj.equals !== undefined)
        return { equals: obj.equals };
    if (obj.notEquals !== undefined)
        return { notEquals: obj.notEquals };
    if (obj.greaterThan !== undefined)
        return { greaterThan: obj.greaterThan };
    if (obj.greaterThanOrEquals !== undefined)
        return { greaterThanOrEquals: obj.greaterThanOrEquals };
    if (obj.lessThan !== undefined)
        return { lessThan: obj.lessThan };
    if (obj.lessThanOrEquals !== undefined)
        return { lessThanOrEquals: obj.lessThanOrEquals };
    if (obj.in !== undefined)
        return { in: obj.in };
    if (obj.notIn !== undefined)
        return { notIn: obj.notIn };
    if (obj.startsWith !== undefined)
        return { startsWith: obj.startsWith };
    if (obj.listContains !== undefined)
        return { listContains: obj.listContains };
    if (obj.stringContains !== undefined)
        return { stringContains: obj.stringContains };
    if (obj.andAll !== undefined)
        return { andAll: smithyClient.SENSITIVE_STRING };
    if (obj.orAll !== undefined)
        return { orAll: smithyClient.SENSITIVE_STRING };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const KnowledgeBaseVectorSearchConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.filter && { filter: smithyClient.SENSITIVE_STRING }),
    ...(obj.implicitFilterConfiguration && {
        implicitFilterConfiguration: ImplicitFilterConfigurationFilterSensitiveLog(obj.implicitFilterConfiguration),
    }),
    ...(obj.rerankingConfiguration && {
        rerankingConfiguration: VectorSearchRerankingConfigurationFilterSensitiveLog(obj.rerankingConfiguration),
    }),
});
const KnowledgeBaseRetrievalConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.vectorSearchConfiguration && {
        vectorSearchConfiguration: KnowledgeBaseVectorSearchConfigurationFilterSensitiveLog(obj.vectorSearchConfiguration),
    }),
});
const KnowledgeBaseRetrieveAndGenerateConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.retrievalConfiguration && {
        retrievalConfiguration: KnowledgeBaseRetrievalConfigurationFilterSensitiveLog(obj.retrievalConfiguration),
    }),
    ...(obj.generationConfiguration && {
        generationConfiguration: GenerationConfigurationFilterSensitiveLog(obj.generationConfiguration),
    }),
});
const RetrieveConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.knowledgeBaseRetrievalConfiguration && {
        knowledgeBaseRetrievalConfiguration: KnowledgeBaseRetrievalConfigurationFilterSensitiveLog(obj.knowledgeBaseRetrievalConfiguration),
    }),
});
const RetrieveAndGenerateConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.knowledgeBaseConfiguration && {
        knowledgeBaseConfiguration: KnowledgeBaseRetrieveAndGenerateConfigurationFilterSensitiveLog(obj.knowledgeBaseConfiguration),
    }),
    ...(obj.externalSourcesConfiguration && {
        externalSourcesConfiguration: ExternalSourcesRetrieveAndGenerateConfigurationFilterSensitiveLog(obj.externalSourcesConfiguration),
    }),
});
const KnowledgeBaseConfigFilterSensitiveLog = (obj) => {
    if (obj.retrieveConfig !== undefined)
        return { retrieveConfig: RetrieveConfigFilterSensitiveLog(obj.retrieveConfig) };
    if (obj.retrieveAndGenerateConfig !== undefined)
        return {
            retrieveAndGenerateConfig: RetrieveAndGenerateConfigurationFilterSensitiveLog(obj.retrieveAndGenerateConfig),
        };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const RAGConfigFilterSensitiveLog = (obj) => {
    if (obj.knowledgeBaseConfig !== undefined)
        return { knowledgeBaseConfig: KnowledgeBaseConfigFilterSensitiveLog(obj.knowledgeBaseConfig) };
    if (obj.precomputedRagSourceConfig !== undefined)
        return { precomputedRagSourceConfig: obj.precomputedRagSourceConfig };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const EvaluationInferenceConfigFilterSensitiveLog = (obj) => {
    if (obj.models !== undefined)
        return { models: obj.models.map((item) => EvaluationModelConfigFilterSensitiveLog(item)) };
    if (obj.ragConfigs !== undefined)
        return { ragConfigs: obj.ragConfigs.map((item) => RAGConfigFilterSensitiveLog(item)) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
const CreateEvaluationJobRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobDescription && { jobDescription: smithyClient.SENSITIVE_STRING }),
    ...(obj.evaluationConfig && { evaluationConfig: EvaluationConfigFilterSensitiveLog(obj.evaluationConfig) }),
    ...(obj.inferenceConfig && { inferenceConfig: EvaluationInferenceConfigFilterSensitiveLog(obj.inferenceConfig) }),
});
const GetEvaluationJobResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobDescription && { jobDescription: smithyClient.SENSITIVE_STRING }),
    ...(obj.evaluationConfig && { evaluationConfig: EvaluationConfigFilterSensitiveLog(obj.evaluationConfig) }),
    ...(obj.inferenceConfig && { inferenceConfig: EvaluationInferenceConfigFilterSensitiveLog(obj.inferenceConfig) }),
});

const se_BatchDeleteEvaluationJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/evaluation-jobs/batch-delete");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        jobIdentifiers: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CancelAutomatedReasoningPolicyBuildWorkflowCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}/build-workflows/{buildWorkflowId}/cancel");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("buildWorkflowId", () => input.buildWorkflowId, "{buildWorkflowId}", false);
    let body;
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateAutomatedReasoningPolicyCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/automated-reasoning-policies");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        description: [],
        kmsKeyId: [],
        name: [],
        policyDefinition: (_) => smithyClient._json(_),
        tags: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateAutomatedReasoningPolicyTestCaseCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/automated-reasoning-policies/{policyArn}/test-cases");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        confidenceThreshold: (_) => smithyClient.serializeFloat(_),
        expectedAggregatedFindingsResult: [],
        guardContent: [],
        queryContent: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateAutomatedReasoningPolicyVersionCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/automated-reasoning-policies/{policyArn}/versions");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        lastUpdatedDefinitionHash: [],
        tags: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateCustomModelCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/custom-models/create-custom-model");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        modelKmsKeyArn: [],
        modelName: [],
        modelSourceConfig: (_) => smithyClient._json(_),
        modelTags: (_) => smithyClient._json(_),
        roleArn: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateCustomModelDeploymentCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/model-customization/custom-model-deployments");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        description: [],
        modelArn: [],
        modelDeploymentName: [],
        tags: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateEvaluationJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/evaluation-jobs");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        applicationType: [],
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        customerEncryptionKeyId: [],
        evaluationConfig: (_) => se_EvaluationConfig(_),
        inferenceConfig: (_) => se_EvaluationInferenceConfig(_, context),
        jobDescription: [],
        jobName: [],
        jobTags: (_) => smithyClient._json(_),
        outputDataConfig: (_) => smithyClient._json(_),
        roleArn: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateFoundationModelAgreementCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/create-foundation-model-agreement");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        modelId: [],
        offerToken: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateGuardrailCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/guardrails");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        automatedReasoningPolicyConfig: (_) => se_GuardrailAutomatedReasoningPolicyConfig(_),
        blockedInputMessaging: [],
        blockedOutputsMessaging: [],
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        contentPolicyConfig: (_) => smithyClient._json(_),
        contextualGroundingPolicyConfig: (_) => se_GuardrailContextualGroundingPolicyConfig(_),
        crossRegionConfig: (_) => smithyClient._json(_),
        description: [],
        kmsKeyId: [],
        name: [],
        sensitiveInformationPolicyConfig: (_) => smithyClient._json(_),
        tags: (_) => smithyClient._json(_),
        topicPolicyConfig: (_) => smithyClient._json(_),
        wordPolicyConfig: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateGuardrailVersionCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/guardrails/{guardrailIdentifier}");
    b.p("guardrailIdentifier", () => input.guardrailIdentifier, "{guardrailIdentifier}", false);
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        description: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateInferenceProfileCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/inference-profiles");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        description: [],
        inferenceProfileName: [],
        modelSource: (_) => smithyClient._json(_),
        tags: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateMarketplaceModelEndpointCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/marketplace-model/endpoints");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        acceptEula: [],
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        endpointConfig: (_) => smithyClient._json(_),
        endpointName: [],
        modelSourceIdentifier: [],
        tags: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateModelCopyJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/model-copy-jobs");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        modelKmsKeyId: [],
        sourceModelArn: [],
        targetModelName: [],
        targetModelTags: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateModelCustomizationJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/model-customization-jobs");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        baseModelIdentifier: [],
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        customModelKmsKeyId: [],
        customModelName: [],
        customModelTags: (_) => smithyClient._json(_),
        customizationConfig: (_) => smithyClient._json(_),
        customizationType: [],
        hyperParameters: (_) => smithyClient._json(_),
        jobName: [],
        jobTags: (_) => smithyClient._json(_),
        outputDataConfig: (_) => smithyClient._json(_),
        roleArn: [],
        trainingDataConfig: (_) => smithyClient._json(_),
        validationDataConfig: (_) => smithyClient._json(_),
        vpcConfig: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateModelImportJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/model-import-jobs");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [],
        importedModelKmsKeyId: [],
        importedModelName: [],
        importedModelTags: (_) => smithyClient._json(_),
        jobName: [],
        jobTags: (_) => smithyClient._json(_),
        modelDataSource: (_) => smithyClient._json(_),
        roleArn: [],
        vpcConfig: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateModelInvocationJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/model-invocation-job");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        inputDataConfig: (_) => smithyClient._json(_),
        jobName: [],
        modelId: [],
        outputDataConfig: (_) => smithyClient._json(_),
        roleArn: [],
        tags: (_) => smithyClient._json(_),
        timeoutDurationInHours: [],
        vpcConfig: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreatePromptRouterCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/prompt-routers");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        description: [],
        fallbackModel: (_) => smithyClient._json(_),
        models: (_) => smithyClient._json(_),
        promptRouterName: [],
        routingCriteria: (_) => se_RoutingCriteria(_),
        tags: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_CreateProvisionedModelThroughputCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/provisioned-model-throughput");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        commitmentDuration: [],
        modelId: [],
        modelUnits: [],
        provisionedModelName: [],
        tags: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_DeleteAutomatedReasoningPolicyCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    const query = smithyClient.map({
        [_f]: [() => input.force !== void 0, () => input[_f].toString()],
    });
    let body;
    b.m("DELETE").h(headers).q(query).b(body);
    return b.build();
};
const se_DeleteAutomatedReasoningPolicyBuildWorkflowCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}/build-workflows/{buildWorkflowId}");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("buildWorkflowId", () => input.buildWorkflowId, "{buildWorkflowId}", false);
    const query = smithyClient.map({
        [_uA]: [
            smithyClient.expectNonNull(input.lastUpdatedAt, `lastUpdatedAt`) != null,
            () => smithyClient.serializeDateTime(input[_lUA]).toString(),
        ],
    });
    let body;
    b.m("DELETE").h(headers).q(query).b(body);
    return b.build();
};
const se_DeleteAutomatedReasoningPolicyTestCaseCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}/test-cases/{testCaseId}");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("testCaseId", () => input.testCaseId, "{testCaseId}", false);
    const query = smithyClient.map({
        [_uA]: [
            smithyClient.expectNonNull(input.lastUpdatedAt, `lastUpdatedAt`) != null,
            () => smithyClient.serializeDateTime(input[_lUA]).toString(),
        ],
    });
    let body;
    b.m("DELETE").h(headers).q(query).b(body);
    return b.build();
};
const se_DeleteCustomModelCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/custom-models/{modelIdentifier}");
    b.p("modelIdentifier", () => input.modelIdentifier, "{modelIdentifier}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
const se_DeleteCustomModelDeploymentCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/model-customization/custom-model-deployments/{customModelDeploymentIdentifier}");
    b.p("customModelDeploymentIdentifier", () => input.customModelDeploymentIdentifier, "{customModelDeploymentIdentifier}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
const se_DeleteFoundationModelAgreementCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/delete-foundation-model-agreement");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        modelId: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_DeleteGuardrailCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/guardrails/{guardrailIdentifier}");
    b.p("guardrailIdentifier", () => input.guardrailIdentifier, "{guardrailIdentifier}", false);
    const query = smithyClient.map({
        [_gV]: [, input[_gV]],
    });
    let body;
    b.m("DELETE").h(headers).q(query).b(body);
    return b.build();
};
const se_DeleteImportedModelCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/imported-models/{modelIdentifier}");
    b.p("modelIdentifier", () => input.modelIdentifier, "{modelIdentifier}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
const se_DeleteInferenceProfileCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/inference-profiles/{inferenceProfileIdentifier}");
    b.p("inferenceProfileIdentifier", () => input.inferenceProfileIdentifier, "{inferenceProfileIdentifier}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
const se_DeleteMarketplaceModelEndpointCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/marketplace-model/endpoints/{endpointArn}");
    b.p("endpointArn", () => input.endpointArn, "{endpointArn}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
const se_DeleteModelInvocationLoggingConfigurationCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/logging/modelinvocations");
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
const se_DeletePromptRouterCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/prompt-routers/{promptRouterArn}");
    b.p("promptRouterArn", () => input.promptRouterArn, "{promptRouterArn}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
const se_DeleteProvisionedModelThroughputCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/provisioned-model-throughput/{provisionedModelId}");
    b.p("provisionedModelId", () => input.provisionedModelId, "{provisionedModelId}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
const se_DeregisterMarketplaceModelEndpointCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/marketplace-model/endpoints/{endpointArn}/registration");
    b.p("endpointArn", () => input.endpointArn, "{endpointArn}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
const se_ExportAutomatedReasoningPolicyVersionCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}/export");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetAutomatedReasoningPolicyCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetAutomatedReasoningPolicyAnnotationsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}/build-workflows/{buildWorkflowId}/annotations");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("buildWorkflowId", () => input.buildWorkflowId, "{buildWorkflowId}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetAutomatedReasoningPolicyBuildWorkflowCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}/build-workflows/{buildWorkflowId}");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("buildWorkflowId", () => input.buildWorkflowId, "{buildWorkflowId}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetAutomatedReasoningPolicyBuildWorkflowResultAssetsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}/build-workflows/{buildWorkflowId}/result-assets");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("buildWorkflowId", () => input.buildWorkflowId, "{buildWorkflowId}", false);
    const query = smithyClient.map({
        [_aT]: [, smithyClient.expectNonNull(input[_aT], `assetType`)],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_GetAutomatedReasoningPolicyNextScenarioCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}/build-workflows/{buildWorkflowId}/scenarios");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("buildWorkflowId", () => input.buildWorkflowId, "{buildWorkflowId}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetAutomatedReasoningPolicyTestCaseCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}/test-cases/{testCaseId}");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("testCaseId", () => input.testCaseId, "{testCaseId}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetAutomatedReasoningPolicyTestResultCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}/build-workflows/{buildWorkflowId}/test-cases/{testCaseId}/test-results");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("buildWorkflowId", () => input.buildWorkflowId, "{buildWorkflowId}", false);
    b.p("testCaseId", () => input.testCaseId, "{testCaseId}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetCustomModelCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/custom-models/{modelIdentifier}");
    b.p("modelIdentifier", () => input.modelIdentifier, "{modelIdentifier}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetCustomModelDeploymentCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/model-customization/custom-model-deployments/{customModelDeploymentIdentifier}");
    b.p("customModelDeploymentIdentifier", () => input.customModelDeploymentIdentifier, "{customModelDeploymentIdentifier}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetEvaluationJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/evaluation-jobs/{jobIdentifier}");
    b.p("jobIdentifier", () => input.jobIdentifier, "{jobIdentifier}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetFoundationModelCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/foundation-models/{modelIdentifier}");
    b.p("modelIdentifier", () => input.modelIdentifier, "{modelIdentifier}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetFoundationModelAvailabilityCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/foundation-model-availability/{modelId}");
    b.p("modelId", () => input.modelId, "{modelId}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetGuardrailCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/guardrails/{guardrailIdentifier}");
    b.p("guardrailIdentifier", () => input.guardrailIdentifier, "{guardrailIdentifier}", false);
    const query = smithyClient.map({
        [_gV]: [, input[_gV]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_GetImportedModelCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/imported-models/{modelIdentifier}");
    b.p("modelIdentifier", () => input.modelIdentifier, "{modelIdentifier}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetInferenceProfileCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/inference-profiles/{inferenceProfileIdentifier}");
    b.p("inferenceProfileIdentifier", () => input.inferenceProfileIdentifier, "{inferenceProfileIdentifier}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetMarketplaceModelEndpointCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/marketplace-model/endpoints/{endpointArn}");
    b.p("endpointArn", () => input.endpointArn, "{endpointArn}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetModelCopyJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/model-copy-jobs/{jobArn}");
    b.p("jobArn", () => input.jobArn, "{jobArn}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetModelCustomizationJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/model-customization-jobs/{jobIdentifier}");
    b.p("jobIdentifier", () => input.jobIdentifier, "{jobIdentifier}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetModelImportJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/model-import-jobs/{jobIdentifier}");
    b.p("jobIdentifier", () => input.jobIdentifier, "{jobIdentifier}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetModelInvocationJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/model-invocation-job/{jobIdentifier}");
    b.p("jobIdentifier", () => input.jobIdentifier, "{jobIdentifier}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetModelInvocationLoggingConfigurationCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/logging/modelinvocations");
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetPromptRouterCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/prompt-routers/{promptRouterArn}");
    b.p("promptRouterArn", () => input.promptRouterArn, "{promptRouterArn}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetProvisionedModelThroughputCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/provisioned-model-throughput/{provisionedModelId}");
    b.p("provisionedModelId", () => input.provisionedModelId, "{provisionedModelId}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_GetUseCaseForModelAccessCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/use-case-for-model-access");
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
const se_ListAutomatedReasoningPoliciesCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies");
    const query = smithyClient.map({
        [_pA]: [, input[_pA]],
        [_nT]: [, input[_nT]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListAutomatedReasoningPolicyBuildWorkflowsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}/build-workflows");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    const query = smithyClient.map({
        [_nT]: [, input[_nT]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListAutomatedReasoningPolicyTestCasesCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}/test-cases");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    const query = smithyClient.map({
        [_nT]: [, input[_nT]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListAutomatedReasoningPolicyTestResultsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/automated-reasoning-policies/{policyArn}/build-workflows/{buildWorkflowId}/test-results");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("buildWorkflowId", () => input.buildWorkflowId, "{buildWorkflowId}", false);
    const query = smithyClient.map({
        [_nT]: [, input[_nT]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListCustomModelDeploymentsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/model-customization/custom-model-deployments");
    const query = smithyClient.map({
        [_cB]: [() => input.createdBefore !== void 0, () => smithyClient.serializeDateTime(input[_cB]).toString()],
        [_cA]: [() => input.createdAfter !== void 0, () => smithyClient.serializeDateTime(input[_cA]).toString()],
        [_nC]: [, input[_nC]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_sB]: [, input[_sB]],
        [_sO]: [, input[_sO]],
        [_sE]: [, input[_sE]],
        [_mAE]: [, input[_mAE]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListCustomModelsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/custom-models");
    const query = smithyClient.map({
        [_cTB]: [() => input.creationTimeBefore !== void 0, () => smithyClient.serializeDateTime(input[_cTB]).toString()],
        [_cTA]: [() => input.creationTimeAfter !== void 0, () => smithyClient.serializeDateTime(input[_cTA]).toString()],
        [_nC]: [, input[_nC]],
        [_bMAE]: [, input[_bMAE]],
        [_fMAE]: [, input[_fMAE]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_sB]: [, input[_sB]],
        [_sO]: [, input[_sO]],
        [_iO]: [() => input.isOwned !== void 0, () => input[_iO].toString()],
        [_mS]: [, input[_mS]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListEvaluationJobsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/evaluation-jobs");
    const query = smithyClient.map({
        [_cTA]: [() => input.creationTimeAfter !== void 0, () => smithyClient.serializeDateTime(input[_cTA]).toString()],
        [_cTB]: [() => input.creationTimeBefore !== void 0, () => smithyClient.serializeDateTime(input[_cTB]).toString()],
        [_sE]: [, input[_sE]],
        [_aTE]: [, input[_aTE]],
        [_nC]: [, input[_nC]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_sB]: [, input[_sB]],
        [_sO]: [, input[_sO]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListFoundationModelAgreementOffersCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/list-foundation-model-agreement-offers/{modelId}");
    b.p("modelId", () => input.modelId, "{modelId}", false);
    const query = smithyClient.map({
        [_oT]: [, input[_oT]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListFoundationModelsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/foundation-models");
    const query = smithyClient.map({
        [_bP]: [, input[_bP]],
        [_bCT]: [, input[_bCT]],
        [_bOM]: [, input[_bOM]],
        [_bIT]: [, input[_bIT]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListGuardrailsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/guardrails");
    const query = smithyClient.map({
        [_gI]: [, input[_gI]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListImportedModelsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/imported-models");
    const query = smithyClient.map({
        [_cTB]: [() => input.creationTimeBefore !== void 0, () => smithyClient.serializeDateTime(input[_cTB]).toString()],
        [_cTA]: [() => input.creationTimeAfter !== void 0, () => smithyClient.serializeDateTime(input[_cTA]).toString()],
        [_nC]: [, input[_nC]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_sB]: [, input[_sB]],
        [_sO]: [, input[_sO]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListInferenceProfilesCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/inference-profiles");
    const query = smithyClient.map({
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_t]: [, input[_tE]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListMarketplaceModelEndpointsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/marketplace-model/endpoints");
    const query = smithyClient.map({
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_mSI]: [, input[_mSE]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListModelCopyJobsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/model-copy-jobs");
    const query = smithyClient.map({
        [_cTA]: [() => input.creationTimeAfter !== void 0, () => smithyClient.serializeDateTime(input[_cTA]).toString()],
        [_cTB]: [() => input.creationTimeBefore !== void 0, () => smithyClient.serializeDateTime(input[_cTB]).toString()],
        [_sE]: [, input[_sE]],
        [_sAE]: [, input[_sAE]],
        [_sMAE]: [, input[_sMAE]],
        [_oMNC]: [, input[_tMNC]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_sB]: [, input[_sB]],
        [_sO]: [, input[_sO]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListModelCustomizationJobsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/model-customization-jobs");
    const query = smithyClient.map({
        [_cTA]: [() => input.creationTimeAfter !== void 0, () => smithyClient.serializeDateTime(input[_cTA]).toString()],
        [_cTB]: [() => input.creationTimeBefore !== void 0, () => smithyClient.serializeDateTime(input[_cTB]).toString()],
        [_sE]: [, input[_sE]],
        [_nC]: [, input[_nC]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_sB]: [, input[_sB]],
        [_sO]: [, input[_sO]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListModelImportJobsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/model-import-jobs");
    const query = smithyClient.map({
        [_cTA]: [() => input.creationTimeAfter !== void 0, () => smithyClient.serializeDateTime(input[_cTA]).toString()],
        [_cTB]: [() => input.creationTimeBefore !== void 0, () => smithyClient.serializeDateTime(input[_cTB]).toString()],
        [_sE]: [, input[_sE]],
        [_nC]: [, input[_nC]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_sB]: [, input[_sB]],
        [_sO]: [, input[_sO]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListModelInvocationJobsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/model-invocation-jobs");
    const query = smithyClient.map({
        [_sTA]: [() => input.submitTimeAfter !== void 0, () => smithyClient.serializeDateTime(input[_sTA]).toString()],
        [_sTB]: [() => input.submitTimeBefore !== void 0, () => smithyClient.serializeDateTime(input[_sTB]).toString()],
        [_sE]: [, input[_sE]],
        [_nC]: [, input[_nC]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_sB]: [, input[_sB]],
        [_sO]: [, input[_sO]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListPromptRoutersCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/prompt-routers");
    const query = smithyClient.map({
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_t]: [, input[_t]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListProvisionedModelThroughputsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/provisioned-model-throughputs");
    const query = smithyClient.map({
        [_cTA]: [() => input.creationTimeAfter !== void 0, () => smithyClient.serializeDateTime(input[_cTA]).toString()],
        [_cTB]: [() => input.creationTimeBefore !== void 0, () => smithyClient.serializeDateTime(input[_cTB]).toString()],
        [_sE]: [, input[_sE]],
        [_mAE]: [, input[_mAE]],
        [_nC]: [, input[_nC]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_sB]: [, input[_sB]],
        [_sO]: [, input[_sO]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
const se_ListTagsForResourceCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/listTagsForResource");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        resourceARN: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_PutModelInvocationLoggingConfigurationCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/logging/modelinvocations");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        loggingConfig: (_) => smithyClient._json(_),
    }));
    b.m("PUT").h(headers).b(body);
    return b.build();
};
const se_PutUseCaseForModelAccessCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/use-case-for-model-access");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        formData: (_) => context.base64Encoder(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_RegisterMarketplaceModelEndpointCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/marketplace-model/endpoints/{endpointIdentifier}/registration");
    b.p("endpointIdentifier", () => input.endpointIdentifier, "{endpointIdentifier}", false);
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        modelSourceIdentifier: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_StartAutomatedReasoningPolicyBuildWorkflowCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = smithyClient.map({}, smithyClient.isSerializableHeaderValue, {
        "content-type": "application/json",
        [_xact]: input[_cRT] ?? uuid.v4(),
    });
    b.bp("/automated-reasoning-policies/{policyArn}/build-workflows/{buildWorkflowType}/start");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("buildWorkflowType", () => input.buildWorkflowType, "{buildWorkflowType}", false);
    let body;
    if (input.sourceContent !== undefined) {
        body = se_AutomatedReasoningPolicyBuildWorkflowSource(input.sourceContent, context);
    }
    if (body === undefined) {
        body = {};
    }
    body = JSON.stringify(body);
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_StartAutomatedReasoningPolicyTestWorkflowCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/automated-reasoning-policies/{policyArn}/build-workflows/{buildWorkflowId}/test-workflows");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("buildWorkflowId", () => input.buildWorkflowId, "{buildWorkflowId}", false);
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        testCaseIds: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_StopEvaluationJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/evaluation-job/{jobIdentifier}/stop");
    b.p("jobIdentifier", () => input.jobIdentifier, "{jobIdentifier}", false);
    let body;
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_StopModelCustomizationJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/model-customization-jobs/{jobIdentifier}/stop");
    b.p("jobIdentifier", () => input.jobIdentifier, "{jobIdentifier}", false);
    let body;
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_StopModelInvocationJobCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {};
    b.bp("/model-invocation-job/{jobIdentifier}/stop");
    b.p("jobIdentifier", () => input.jobIdentifier, "{jobIdentifier}", false);
    let body;
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_TagResourceCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/tagResource");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        resourceARN: [],
        tags: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_UntagResourceCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/untagResource");
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        resourceARN: [],
        tagKeys: (_) => smithyClient._json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
const se_UpdateAutomatedReasoningPolicyCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/automated-reasoning-policies/{policyArn}");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        description: [],
        name: [],
        policyDefinition: (_) => smithyClient._json(_),
    }));
    b.m("PATCH").h(headers).b(body);
    return b.build();
};
const se_UpdateAutomatedReasoningPolicyAnnotationsCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/automated-reasoning-policies/{policyArn}/build-workflows/{buildWorkflowId}/annotations");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("buildWorkflowId", () => input.buildWorkflowId, "{buildWorkflowId}", false);
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        annotations: (_) => smithyClient._json(_),
        lastUpdatedAnnotationSetHash: [],
    }));
    b.m("PATCH").h(headers).b(body);
    return b.build();
};
const se_UpdateAutomatedReasoningPolicyTestCaseCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/automated-reasoning-policies/{policyArn}/test-cases/{testCaseId}");
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    b.p("testCaseId", () => input.testCaseId, "{testCaseId}", false);
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        confidenceThreshold: (_) => smithyClient.serializeFloat(_),
        expectedAggregatedFindingsResult: [],
        guardContent: [],
        lastUpdatedAt: (_) => smithyClient.serializeDateTime(_),
        queryContent: [],
    }));
    b.m("PATCH").h(headers).b(body);
    return b.build();
};
const se_UpdateGuardrailCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/guardrails/{guardrailIdentifier}");
    b.p("guardrailIdentifier", () => input.guardrailIdentifier, "{guardrailIdentifier}", false);
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        automatedReasoningPolicyConfig: (_) => se_GuardrailAutomatedReasoningPolicyConfig(_),
        blockedInputMessaging: [],
        blockedOutputsMessaging: [],
        contentPolicyConfig: (_) => smithyClient._json(_),
        contextualGroundingPolicyConfig: (_) => se_GuardrailContextualGroundingPolicyConfig(_),
        crossRegionConfig: (_) => smithyClient._json(_),
        description: [],
        kmsKeyId: [],
        name: [],
        sensitiveInformationPolicyConfig: (_) => smithyClient._json(_),
        topicPolicyConfig: (_) => smithyClient._json(_),
        wordPolicyConfig: (_) => smithyClient._json(_),
    }));
    b.m("PUT").h(headers).b(body);
    return b.build();
};
const se_UpdateMarketplaceModelEndpointCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/marketplace-model/endpoints/{endpointArn}");
    b.p("endpointArn", () => input.endpointArn, "{endpointArn}", false);
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        clientRequestToken: [true, (_) => _ ?? uuid.v4()],
        endpointConfig: (_) => smithyClient._json(_),
    }));
    b.m("PATCH").h(headers).b(body);
    return b.build();
};
const se_UpdateProvisionedModelThroughputCommand = async (input, context) => {
    const b = core.requestBuilder(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/provisioned-model-throughput/{provisionedModelId}");
    b.p("provisionedModelId", () => input.provisionedModelId, "{provisionedModelId}", false);
    let body;
    body = JSON.stringify(smithyClient.take(input, {
        desiredModelId: [],
        desiredProvisionedModelName: [],
    }));
    b.m("PATCH").h(headers).b(body);
    return b.build();
};
const de_BatchDeleteEvaluationJobCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        errors: smithyClient._json,
        evaluationJobs: smithyClient._json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CancelAutomatedReasoningPolicyBuildWorkflowCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_CreateAutomatedReasoningPolicyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        definitionHash: smithyClient.expectString,
        description: smithyClient.expectString,
        name: smithyClient.expectString,
        policyArn: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        version: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateAutomatedReasoningPolicyTestCaseCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        policyArn: smithyClient.expectString,
        testCaseId: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateAutomatedReasoningPolicyVersionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        definitionHash: smithyClient.expectString,
        description: smithyClient.expectString,
        name: smithyClient.expectString,
        policyArn: smithyClient.expectString,
        version: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateCustomModelCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        modelArn: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateCustomModelDeploymentCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        customModelDeploymentArn: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateEvaluationJobCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        jobArn: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateFoundationModelAgreementCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        modelId: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateGuardrailCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        guardrailArn: smithyClient.expectString,
        guardrailId: smithyClient.expectString,
        version: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateGuardrailVersionCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        guardrailId: smithyClient.expectString,
        version: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateInferenceProfileCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        inferenceProfileArn: smithyClient.expectString,
        status: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateMarketplaceModelEndpointCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        marketplaceModelEndpoint: (_) => de_MarketplaceModelEndpoint(_),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateModelCopyJobCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        jobArn: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateModelCustomizationJobCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        jobArn: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateModelImportJobCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        jobArn: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateModelInvocationJobCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        jobArn: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreatePromptRouterCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        promptRouterArn: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateProvisionedModelThroughputCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        provisionedModelArn: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_DeleteAutomatedReasoningPolicyCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_DeleteAutomatedReasoningPolicyBuildWorkflowCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_DeleteAutomatedReasoningPolicyTestCaseCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_DeleteCustomModelCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_DeleteCustomModelDeploymentCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_DeleteFoundationModelAgreementCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_DeleteGuardrailCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_DeleteImportedModelCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_DeleteInferenceProfileCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_DeleteMarketplaceModelEndpointCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_DeleteModelInvocationLoggingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_DeletePromptRouterCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_DeleteProvisionedModelThroughputCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_DeregisterMarketplaceModelEndpointCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_ExportAutomatedReasoningPolicyVersionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectObject(await core$1.parseJsonBody(output.body, context));
    contents.policyDefinition = smithyClient._json(data);
    return contents;
};
const de_GetAutomatedReasoningPolicyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        definitionHash: smithyClient.expectString,
        description: smithyClient.expectString,
        kmsKeyArn: smithyClient.expectString,
        name: smithyClient.expectString,
        policyArn: smithyClient.expectString,
        policyId: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        version: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetAutomatedReasoningPolicyAnnotationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        annotationSetHash: smithyClient.expectString,
        annotations: smithyClient._json,
        buildWorkflowId: smithyClient.expectString,
        name: smithyClient.expectString,
        policyArn: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetAutomatedReasoningPolicyBuildWorkflowCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        buildWorkflowId: smithyClient.expectString,
        buildWorkflowType: smithyClient.expectString,
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        documentContentType: smithyClient.expectString,
        documentDescription: smithyClient.expectString,
        documentName: smithyClient.expectString,
        policyArn: smithyClient.expectString,
        status: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetAutomatedReasoningPolicyBuildWorkflowResultAssetsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        buildWorkflowAssets: (_) => de_AutomatedReasoningPolicyBuildResultAssets(core$1.awsExpectUnion(_)),
        buildWorkflowId: smithyClient.expectString,
        policyArn: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetAutomatedReasoningPolicyNextScenarioCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        policyArn: smithyClient.expectString,
        scenario: smithyClient._json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetAutomatedReasoningPolicyTestCaseCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        policyArn: smithyClient.expectString,
        testCase: (_) => de_AutomatedReasoningPolicyTestCase(_),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetAutomatedReasoningPolicyTestResultCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        testResult: (_) => de_AutomatedReasoningPolicyTestResult(_),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetCustomModelCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        baseModelArn: smithyClient.expectString,
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        customizationConfig: (_) => smithyClient._json(core$1.awsExpectUnion(_)),
        customizationType: smithyClient.expectString,
        failureMessage: smithyClient.expectString,
        hyperParameters: smithyClient._json,
        jobArn: smithyClient.expectString,
        jobName: smithyClient.expectString,
        modelArn: smithyClient.expectString,
        modelKmsKeyArn: smithyClient.expectString,
        modelName: smithyClient.expectString,
        modelStatus: smithyClient.expectString,
        outputDataConfig: smithyClient._json,
        trainingDataConfig: smithyClient._json,
        trainingMetrics: (_) => de_TrainingMetrics(_),
        validationDataConfig: smithyClient._json,
        validationMetrics: (_) => de_ValidationMetrics(_),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetCustomModelDeploymentCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        customModelDeploymentArn: smithyClient.expectString,
        description: smithyClient.expectString,
        failureMessage: smithyClient.expectString,
        lastUpdatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        modelArn: smithyClient.expectString,
        modelDeploymentName: smithyClient.expectString,
        status: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetEvaluationJobCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        applicationType: smithyClient.expectString,
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        customerEncryptionKeyId: smithyClient.expectString,
        evaluationConfig: (_) => de_EvaluationConfig(core$1.awsExpectUnion(_)),
        failureMessages: smithyClient._json,
        inferenceConfig: (_) => de_EvaluationInferenceConfig(core$1.awsExpectUnion(_), context),
        jobArn: smithyClient.expectString,
        jobDescription: smithyClient.expectString,
        jobName: smithyClient.expectString,
        jobType: smithyClient.expectString,
        lastModifiedTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        outputDataConfig: smithyClient._json,
        roleArn: smithyClient.expectString,
        status: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetFoundationModelCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        modelDetails: smithyClient._json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetFoundationModelAvailabilityCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        agreementAvailability: smithyClient._json,
        authorizationStatus: smithyClient.expectString,
        entitlementAvailability: smithyClient.expectString,
        modelId: smithyClient.expectString,
        regionAvailability: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetGuardrailCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        automatedReasoningPolicy: (_) => de_GuardrailAutomatedReasoningPolicy(_),
        blockedInputMessaging: smithyClient.expectString,
        blockedOutputsMessaging: smithyClient.expectString,
        contentPolicy: smithyClient._json,
        contextualGroundingPolicy: (_) => de_GuardrailContextualGroundingPolicy(_),
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        crossRegionDetails: smithyClient._json,
        description: smithyClient.expectString,
        failureRecommendations: smithyClient._json,
        guardrailArn: smithyClient.expectString,
        guardrailId: smithyClient.expectString,
        kmsKeyArn: smithyClient.expectString,
        name: smithyClient.expectString,
        sensitiveInformationPolicy: smithyClient._json,
        status: smithyClient.expectString,
        statusReasons: smithyClient._json,
        topicPolicy: smithyClient._json,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        version: smithyClient.expectString,
        wordPolicy: smithyClient._json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetImportedModelCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        customModelUnits: smithyClient._json,
        instructSupported: smithyClient.expectBoolean,
        jobArn: smithyClient.expectString,
        jobName: smithyClient.expectString,
        modelArchitecture: smithyClient.expectString,
        modelArn: smithyClient.expectString,
        modelDataSource: (_) => smithyClient._json(core$1.awsExpectUnion(_)),
        modelKmsKeyArn: smithyClient.expectString,
        modelName: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetInferenceProfileCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        description: smithyClient.expectString,
        inferenceProfileArn: smithyClient.expectString,
        inferenceProfileId: smithyClient.expectString,
        inferenceProfileName: smithyClient.expectString,
        models: smithyClient._json,
        status: smithyClient.expectString,
        type: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetMarketplaceModelEndpointCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        marketplaceModelEndpoint: (_) => de_MarketplaceModelEndpoint(_),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetModelCopyJobCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        failureMessage: smithyClient.expectString,
        jobArn: smithyClient.expectString,
        sourceAccountId: smithyClient.expectString,
        sourceModelArn: smithyClient.expectString,
        sourceModelName: smithyClient.expectString,
        status: smithyClient.expectString,
        targetModelArn: smithyClient.expectString,
        targetModelKmsKeyArn: smithyClient.expectString,
        targetModelName: smithyClient.expectString,
        targetModelTags: smithyClient._json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetModelCustomizationJobCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        baseModelArn: smithyClient.expectString,
        clientRequestToken: smithyClient.expectString,
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        customizationConfig: (_) => smithyClient._json(core$1.awsExpectUnion(_)),
        customizationType: smithyClient.expectString,
        endTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        failureMessage: smithyClient.expectString,
        hyperParameters: smithyClient._json,
        jobArn: smithyClient.expectString,
        jobName: smithyClient.expectString,
        lastModifiedTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        outputDataConfig: smithyClient._json,
        outputModelArn: smithyClient.expectString,
        outputModelKmsKeyArn: smithyClient.expectString,
        outputModelName: smithyClient.expectString,
        roleArn: smithyClient.expectString,
        status: smithyClient.expectString,
        statusDetails: (_) => de_StatusDetails(_),
        trainingDataConfig: smithyClient._json,
        trainingMetrics: (_) => de_TrainingMetrics(_),
        validationDataConfig: smithyClient._json,
        validationMetrics: (_) => de_ValidationMetrics(_),
        vpcConfig: smithyClient._json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetModelImportJobCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        endTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        failureMessage: smithyClient.expectString,
        importedModelArn: smithyClient.expectString,
        importedModelKmsKeyArn: smithyClient.expectString,
        importedModelName: smithyClient.expectString,
        jobArn: smithyClient.expectString,
        jobName: smithyClient.expectString,
        lastModifiedTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        modelDataSource: (_) => smithyClient._json(core$1.awsExpectUnion(_)),
        roleArn: smithyClient.expectString,
        status: smithyClient.expectString,
        vpcConfig: smithyClient._json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetModelInvocationJobCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        clientRequestToken: smithyClient.expectString,
        endTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        inputDataConfig: (_) => smithyClient._json(core$1.awsExpectUnion(_)),
        jobArn: smithyClient.expectString,
        jobExpirationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        jobName: smithyClient.expectString,
        lastModifiedTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        message: smithyClient.expectString,
        modelId: smithyClient.expectString,
        outputDataConfig: (_) => smithyClient._json(core$1.awsExpectUnion(_)),
        roleArn: smithyClient.expectString,
        status: smithyClient.expectString,
        submitTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        timeoutDurationInHours: smithyClient.expectInt32,
        vpcConfig: smithyClient._json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetModelInvocationLoggingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        loggingConfig: smithyClient._json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetPromptRouterCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        description: smithyClient.expectString,
        fallbackModel: smithyClient._json,
        models: smithyClient._json,
        promptRouterArn: smithyClient.expectString,
        promptRouterName: smithyClient.expectString,
        routingCriteria: (_) => de_RoutingCriteria(_),
        status: smithyClient.expectString,
        type: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetProvisionedModelThroughputCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        commitmentDuration: smithyClient.expectString,
        commitmentExpirationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        desiredModelArn: smithyClient.expectString,
        desiredModelUnits: smithyClient.expectInt32,
        failureMessage: smithyClient.expectString,
        foundationModelArn: smithyClient.expectString,
        lastModifiedTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        modelArn: smithyClient.expectString,
        modelUnits: smithyClient.expectInt32,
        provisionedModelArn: smithyClient.expectString,
        provisionedModelName: smithyClient.expectString,
        status: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetUseCaseForModelAccessCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        formData: context.base64Decoder,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListAutomatedReasoningPoliciesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        automatedReasoningPolicySummaries: (_) => de_AutomatedReasoningPolicySummaries(_),
        nextToken: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListAutomatedReasoningPolicyBuildWorkflowsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        automatedReasoningPolicyBuildWorkflowSummaries: (_) => de_AutomatedReasoningPolicyBuildWorkflowSummaries(_),
        nextToken: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListAutomatedReasoningPolicyTestCasesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        nextToken: smithyClient.expectString,
        testCases: (_) => de_AutomatedReasoningPolicyTestCaseList(_),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListAutomatedReasoningPolicyTestResultsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        nextToken: smithyClient.expectString,
        testResults: (_) => de_AutomatedReasoningPolicyTestList(_),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListCustomModelDeploymentsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        modelDeploymentSummaries: (_) => de_CustomModelDeploymentSummaryList(_),
        nextToken: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListCustomModelsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        modelSummaries: (_) => de_CustomModelSummaryList(_),
        nextToken: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListEvaluationJobsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        jobSummaries: (_) => de_EvaluationSummaries(_),
        nextToken: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListFoundationModelAgreementOffersCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        modelId: smithyClient.expectString,
        offers: smithyClient._json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListFoundationModelsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        modelSummaries: smithyClient._json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListGuardrailsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        guardrails: (_) => de_GuardrailSummaries(_),
        nextToken: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListImportedModelsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        modelSummaries: (_) => de_ImportedModelSummaryList(_),
        nextToken: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListInferenceProfilesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        inferenceProfileSummaries: (_) => de_InferenceProfileSummaries(_),
        nextToken: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListMarketplaceModelEndpointsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        marketplaceModelEndpoints: (_) => de_MarketplaceModelEndpointSummaries(_),
        nextToken: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListModelCopyJobsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        modelCopyJobSummaries: (_) => de_ModelCopyJobSummaries(_),
        nextToken: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListModelCustomizationJobsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        modelCustomizationJobSummaries: (_) => de_ModelCustomizationJobSummaries(_),
        nextToken: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListModelImportJobsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        modelImportJobSummaries: (_) => de_ModelImportJobSummaries(_),
        nextToken: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListModelInvocationJobsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        invocationJobSummaries: (_) => de_ModelInvocationJobSummaries(_),
        nextToken: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListPromptRoutersCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        nextToken: smithyClient.expectString,
        promptRouterSummaries: (_) => de_PromptRouterSummaries(_),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListProvisionedModelThroughputsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        nextToken: smithyClient.expectString,
        provisionedModelSummaries: (_) => de_ProvisionedModelSummaries(_),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        tags: smithyClient._json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_PutModelInvocationLoggingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_PutUseCaseForModelAccessCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_RegisterMarketplaceModelEndpointCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        marketplaceModelEndpoint: (_) => de_MarketplaceModelEndpoint(_),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_StartAutomatedReasoningPolicyBuildWorkflowCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        buildWorkflowId: smithyClient.expectString,
        policyArn: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_StartAutomatedReasoningPolicyTestWorkflowCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        policyArn: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_StopEvaluationJobCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_StopModelCustomizationJobCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_StopModelInvocationJobCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_TagResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_UntagResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_UpdateAutomatedReasoningPolicyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        definitionHash: smithyClient.expectString,
        name: smithyClient.expectString,
        policyArn: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdateAutomatedReasoningPolicyAnnotationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        annotationSetHash: smithyClient.expectString,
        buildWorkflowId: smithyClient.expectString,
        policyArn: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdateAutomatedReasoningPolicyTestCaseCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        policyArn: smithyClient.expectString,
        testCaseId: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdateGuardrailCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        guardrailArn: smithyClient.expectString,
        guardrailId: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        version: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdateMarketplaceModelEndpointCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    const data = smithyClient.expectNonNull(smithyClient.expectObject(await core$1.parseJsonBody(output.body, context)), "body");
    const doc = smithyClient.take(data, {
        marketplaceModelEndpoint: (_) => de_MarketplaceModelEndpoint(_),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdateProvisionedModelThroughputCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = smithyClient.map({
        $metadata: deserializeMetadata(output),
    });
    await smithyClient.collectBody(output.body, context);
    return contents;
};
const de_CommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await core$1.parseJsonErrorBody(output.body, context),
    };
    const errorCode = core$1.loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.bedrock#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput);
        case "ConflictException":
        case "com.amazonaws.bedrock#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput);
        case "InternalServerException":
        case "com.amazonaws.bedrock#InternalServerException":
            throw await de_InternalServerExceptionRes(parsedOutput);
        case "ResourceNotFoundException":
        case "com.amazonaws.bedrock#ResourceNotFoundException":
            throw await de_ResourceNotFoundExceptionRes(parsedOutput);
        case "ThrottlingException":
        case "com.amazonaws.bedrock#ThrottlingException":
            throw await de_ThrottlingExceptionRes(parsedOutput);
        case "ValidationException":
        case "com.amazonaws.bedrock#ValidationException":
            throw await de_ValidationExceptionRes(parsedOutput);
        case "ServiceQuotaExceededException":
        case "com.amazonaws.bedrock#ServiceQuotaExceededException":
            throw await de_ServiceQuotaExceededExceptionRes(parsedOutput);
        case "TooManyTagsException":
        case "com.amazonaws.bedrock#TooManyTagsException":
            throw await de_TooManyTagsExceptionRes(parsedOutput);
        case "ResourceInUseException":
        case "com.amazonaws.bedrock#ResourceInUseException":
            throw await de_ResourceInUseExceptionRes(parsedOutput);
        case "ServiceUnavailableException":
        case "com.amazonaws.bedrock#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const throwDefaultError = smithyClient.withBaseException(BedrockServiceException);
const de_AccessDeniedExceptionRes = async (parsedOutput, context) => {
    const contents = smithyClient.map({});
    const data = parsedOutput.body;
    const doc = smithyClient.take(data, {
        message: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    const exception = new AccessDeniedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return smithyClient.decorateServiceException(exception, parsedOutput.body);
};
const de_ConflictExceptionRes = async (parsedOutput, context) => {
    const contents = smithyClient.map({});
    const data = parsedOutput.body;
    const doc = smithyClient.take(data, {
        message: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    const exception = new ConflictException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return smithyClient.decorateServiceException(exception, parsedOutput.body);
};
const de_InternalServerExceptionRes = async (parsedOutput, context) => {
    const contents = smithyClient.map({});
    const data = parsedOutput.body;
    const doc = smithyClient.take(data, {
        message: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    const exception = new InternalServerException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return smithyClient.decorateServiceException(exception, parsedOutput.body);
};
const de_ResourceInUseExceptionRes = async (parsedOutput, context) => {
    const contents = smithyClient.map({});
    const data = parsedOutput.body;
    const doc = smithyClient.take(data, {
        message: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    const exception = new ResourceInUseException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return smithyClient.decorateServiceException(exception, parsedOutput.body);
};
const de_ResourceNotFoundExceptionRes = async (parsedOutput, context) => {
    const contents = smithyClient.map({});
    const data = parsedOutput.body;
    const doc = smithyClient.take(data, {
        message: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    const exception = new ResourceNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return smithyClient.decorateServiceException(exception, parsedOutput.body);
};
const de_ServiceQuotaExceededExceptionRes = async (parsedOutput, context) => {
    const contents = smithyClient.map({});
    const data = parsedOutput.body;
    const doc = smithyClient.take(data, {
        message: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    const exception = new ServiceQuotaExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return smithyClient.decorateServiceException(exception, parsedOutput.body);
};
const de_ServiceUnavailableExceptionRes = async (parsedOutput, context) => {
    const contents = smithyClient.map({});
    const data = parsedOutput.body;
    const doc = smithyClient.take(data, {
        message: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    const exception = new ServiceUnavailableException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return smithyClient.decorateServiceException(exception, parsedOutput.body);
};
const de_ThrottlingExceptionRes = async (parsedOutput, context) => {
    const contents = smithyClient.map({});
    const data = parsedOutput.body;
    const doc = smithyClient.take(data, {
        message: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    const exception = new ThrottlingException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return smithyClient.decorateServiceException(exception, parsedOutput.body);
};
const de_TooManyTagsExceptionRes = async (parsedOutput, context) => {
    const contents = smithyClient.map({});
    const data = parsedOutput.body;
    const doc = smithyClient.take(data, {
        message: smithyClient.expectString,
        resourceName: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    const exception = new TooManyTagsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return smithyClient.decorateServiceException(exception, parsedOutput.body);
};
const de_ValidationExceptionRes = async (parsedOutput, context) => {
    const contents = smithyClient.map({});
    const data = parsedOutput.body;
    const doc = smithyClient.take(data, {
        message: smithyClient.expectString,
    });
    Object.assign(contents, doc);
    const exception = new ValidationException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return smithyClient.decorateServiceException(exception, parsedOutput.body);
};
const se_AdditionalModelRequestFields = (input, context) => {
    return Object.entries(input).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = se_AdditionalModelRequestFieldsValue(value);
        return acc;
    }, {});
};
const se_AdditionalModelRequestFieldsValue = (input, context) => {
    return input;
};
const se_AutomatedEvaluationConfig = (input, context) => {
    return smithyClient.take(input, {
        customMetricConfig: (_) => se_AutomatedEvaluationCustomMetricConfig(_),
        datasetMetricConfigs: smithyClient._json,
        evaluatorModelConfig: smithyClient._json,
    });
};
const se_AutomatedEvaluationCustomMetricConfig = (input, context) => {
    return smithyClient.take(input, {
        customMetrics: (_) => se_AutomatedEvaluationCustomMetrics(_),
        evaluatorModelConfig: smithyClient._json,
    });
};
const se_AutomatedEvaluationCustomMetrics = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_AutomatedEvaluationCustomMetricSource(entry);
    });
};
const se_AutomatedEvaluationCustomMetricSource = (input, context) => {
    return exports.AutomatedEvaluationCustomMetricSource.visit(input, {
        customMetricDefinition: (value) => ({ customMetricDefinition: se_CustomMetricDefinition(value) }),
        _: (name, value) => ({ [name]: value }),
    });
};
const se_AutomatedReasoningPolicyBuildWorkflowDocument = (input, context) => {
    return smithyClient.take(input, {
        document: context.base64Encoder,
        documentContentType: [],
        documentDescription: [],
        documentName: [],
    });
};
const se_AutomatedReasoningPolicyBuildWorkflowDocumentList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_AutomatedReasoningPolicyBuildWorkflowDocument(entry, context);
    });
};
const se_AutomatedReasoningPolicyBuildWorkflowSource = (input, context) => {
    return smithyClient.take(input, {
        policyDefinition: smithyClient._json,
        workflowContent: (_) => se_AutomatedReasoningPolicyWorkflowTypeContent(_, context),
    });
};
const se_AutomatedReasoningPolicyWorkflowTypeContent = (input, context) => {
    return exports.AutomatedReasoningPolicyWorkflowTypeContent.visit(input, {
        documents: (value) => ({ documents: se_AutomatedReasoningPolicyBuildWorkflowDocumentList(value, context) }),
        policyRepairAssets: (value) => ({ policyRepairAssets: smithyClient._json(value) }),
        _: (name, value) => ({ [name]: value }),
    });
};
const se_ByteContentDoc = (input, context) => {
    return smithyClient.take(input, {
        contentType: [],
        data: context.base64Encoder,
        identifier: [],
    });
};
const se_CustomMetricDefinition = (input, context) => {
    return smithyClient.take(input, {
        instructions: [],
        name: [],
        ratingScale: (_) => se_RatingScale(_),
    });
};
const se_EvaluationConfig = (input, context) => {
    return exports.EvaluationConfig.visit(input, {
        automated: (value) => ({ automated: se_AutomatedEvaluationConfig(value) }),
        human: (value) => ({ human: smithyClient._json(value) }),
        _: (name, value) => ({ [name]: value }),
    });
};
const se_EvaluationInferenceConfig = (input, context) => {
    return exports.EvaluationInferenceConfig.visit(input, {
        models: (value) => ({ models: smithyClient._json(value) }),
        ragConfigs: (value) => ({ ragConfigs: se_RagConfigs(value, context) }),
        _: (name, value) => ({ [name]: value }),
    });
};
const se_ExternalSource = (input, context) => {
    return smithyClient.take(input, {
        byteContent: (_) => se_ByteContentDoc(_, context),
        s3Location: smithyClient._json,
        sourceType: [],
    });
};
const se_ExternalSources = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_ExternalSource(entry, context);
    });
};
const se_ExternalSourcesGenerationConfiguration = (input, context) => {
    return smithyClient.take(input, {
        additionalModelRequestFields: (_) => se_AdditionalModelRequestFields(_),
        guardrailConfiguration: smithyClient._json,
        kbInferenceConfig: (_) => se_KbInferenceConfig(_),
        promptTemplate: smithyClient._json,
    });
};
const se_ExternalSourcesRetrieveAndGenerateConfiguration = (input, context) => {
    return smithyClient.take(input, {
        generationConfiguration: (_) => se_ExternalSourcesGenerationConfiguration(_),
        modelArn: [],
        sources: (_) => se_ExternalSources(_, context),
    });
};
const se_FilterAttribute = (input, context) => {
    return smithyClient.take(input, {
        key: [],
        value: (_) => se_FilterValue(_),
    });
};
const se_FilterValue = (input, context) => {
    return input;
};
const se_GenerationConfiguration = (input, context) => {
    return smithyClient.take(input, {
        additionalModelRequestFields: (_) => se_AdditionalModelRequestFields(_),
        guardrailConfiguration: smithyClient._json,
        kbInferenceConfig: (_) => se_KbInferenceConfig(_),
        promptTemplate: smithyClient._json,
    });
};
const se_GuardrailAutomatedReasoningPolicyConfig = (input, context) => {
    return smithyClient.take(input, {
        confidenceThreshold: smithyClient.serializeFloat,
        policies: smithyClient._json,
    });
};
const se_GuardrailContextualGroundingFilterConfig = (input, context) => {
    return smithyClient.take(input, {
        action: [],
        enabled: [],
        threshold: smithyClient.serializeFloat,
        type: [],
    });
};
const se_GuardrailContextualGroundingFiltersConfig = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_GuardrailContextualGroundingFilterConfig(entry);
    });
};
const se_GuardrailContextualGroundingPolicyConfig = (input, context) => {
    return smithyClient.take(input, {
        filtersConfig: (_) => se_GuardrailContextualGroundingFiltersConfig(_),
    });
};
const se_KbInferenceConfig = (input, context) => {
    return smithyClient.take(input, {
        textInferenceConfig: (_) => se_TextInferenceConfig(_),
    });
};
const se_KnowledgeBaseConfig = (input, context) => {
    return exports.KnowledgeBaseConfig.visit(input, {
        retrieveAndGenerateConfig: (value) => ({
            retrieveAndGenerateConfig: se_RetrieveAndGenerateConfiguration(value, context),
        }),
        retrieveConfig: (value) => ({ retrieveConfig: se_RetrieveConfig(value) }),
        _: (name, value) => ({ [name]: value }),
    });
};
const se_KnowledgeBaseRetrievalConfiguration = (input, context) => {
    return smithyClient.take(input, {
        vectorSearchConfiguration: (_) => se_KnowledgeBaseVectorSearchConfiguration(_),
    });
};
const se_KnowledgeBaseRetrieveAndGenerateConfiguration = (input, context) => {
    return smithyClient.take(input, {
        generationConfiguration: (_) => se_GenerationConfiguration(_),
        knowledgeBaseId: [],
        modelArn: [],
        orchestrationConfiguration: smithyClient._json,
        retrievalConfiguration: (_) => se_KnowledgeBaseRetrievalConfiguration(_),
    });
};
const se_KnowledgeBaseVectorSearchConfiguration = (input, context) => {
    return smithyClient.take(input, {
        filter: (_) => se_RetrievalFilter(_),
        implicitFilterConfiguration: smithyClient._json,
        numberOfResults: [],
        overrideSearchType: [],
        rerankingConfiguration: (_) => se_VectorSearchRerankingConfiguration(_),
    });
};
const se_RAGConfig = (input, context) => {
    return exports.RAGConfig.visit(input, {
        knowledgeBaseConfig: (value) => ({ knowledgeBaseConfig: se_KnowledgeBaseConfig(value, context) }),
        precomputedRagSourceConfig: (value) => ({ precomputedRagSourceConfig: smithyClient._json(value) }),
        _: (name, value) => ({ [name]: value }),
    });
};
const se_RagConfigs = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_RAGConfig(entry, context);
    });
};
const se_RatingScale = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_RatingScaleItem(entry);
    });
};
const se_RatingScaleItem = (input, context) => {
    return smithyClient.take(input, {
        definition: [],
        value: (_) => se_RatingScaleItemValue(_),
    });
};
const se_RatingScaleItemValue = (input, context) => {
    return exports.RatingScaleItemValue.visit(input, {
        floatValue: (value) => ({ floatValue: smithyClient.serializeFloat(value) }),
        stringValue: (value) => ({ stringValue: value }),
        _: (name, value) => ({ [name]: value }),
    });
};
const se_RetrievalFilter = (input, context) => {
    return exports.RetrievalFilter.visit(input, {
        andAll: (value) => ({ andAll: se_RetrievalFilterList(value) }),
        equals: (value) => ({ equals: se_FilterAttribute(value) }),
        greaterThan: (value) => ({ greaterThan: se_FilterAttribute(value) }),
        greaterThanOrEquals: (value) => ({ greaterThanOrEquals: se_FilterAttribute(value) }),
        in: (value) => ({ in: se_FilterAttribute(value) }),
        lessThan: (value) => ({ lessThan: se_FilterAttribute(value) }),
        lessThanOrEquals: (value) => ({ lessThanOrEquals: se_FilterAttribute(value) }),
        listContains: (value) => ({ listContains: se_FilterAttribute(value) }),
        notEquals: (value) => ({ notEquals: se_FilterAttribute(value) }),
        notIn: (value) => ({ notIn: se_FilterAttribute(value) }),
        orAll: (value) => ({ orAll: se_RetrievalFilterList(value) }),
        startsWith: (value) => ({ startsWith: se_FilterAttribute(value) }),
        stringContains: (value) => ({ stringContains: se_FilterAttribute(value) }),
        _: (name, value) => ({ [name]: value }),
    });
};
const se_RetrievalFilterList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_RetrievalFilter(entry);
    });
};
const se_RetrieveAndGenerateConfiguration = (input, context) => {
    return smithyClient.take(input, {
        externalSourcesConfiguration: (_) => se_ExternalSourcesRetrieveAndGenerateConfiguration(_, context),
        knowledgeBaseConfiguration: (_) => se_KnowledgeBaseRetrieveAndGenerateConfiguration(_),
        type: [],
    });
};
const se_RetrieveConfig = (input, context) => {
    return smithyClient.take(input, {
        knowledgeBaseId: [],
        knowledgeBaseRetrievalConfiguration: (_) => se_KnowledgeBaseRetrievalConfiguration(_),
    });
};
const se_RoutingCriteria = (input, context) => {
    return smithyClient.take(input, {
        responseQualityDifference: smithyClient.serializeFloat,
    });
};
const se_TextInferenceConfig = (input, context) => {
    return smithyClient.take(input, {
        maxTokens: [],
        stopSequences: smithyClient._json,
        temperature: smithyClient.serializeFloat,
        topP: smithyClient.serializeFloat,
    });
};
const se_VectorSearchBedrockRerankingConfiguration = (input, context) => {
    return smithyClient.take(input, {
        metadataConfiguration: smithyClient._json,
        modelConfiguration: (_) => se_VectorSearchBedrockRerankingModelConfiguration(_),
        numberOfRerankedResults: [],
    });
};
const se_VectorSearchBedrockRerankingModelConfiguration = (input, context) => {
    return smithyClient.take(input, {
        additionalModelRequestFields: (_) => se_AdditionalModelRequestFields(_),
        modelArn: [],
    });
};
const se_VectorSearchRerankingConfiguration = (input, context) => {
    return smithyClient.take(input, {
        bedrockRerankingConfiguration: (_) => se_VectorSearchBedrockRerankingConfiguration(_),
        type: [],
    });
};
const de_AdditionalModelRequestFields = (output, context) => {
    return Object.entries(output).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = de_AdditionalModelRequestFieldsValue(value);
        return acc;
    }, {});
};
const de_AdditionalModelRequestFieldsValue = (output, context) => {
    return output;
};
const de_AutomatedEvaluationConfig = (output, context) => {
    return smithyClient.take(output, {
        customMetricConfig: (_) => de_AutomatedEvaluationCustomMetricConfig(_),
        datasetMetricConfigs: smithyClient._json,
        evaluatorModelConfig: (_) => smithyClient._json(core$1.awsExpectUnion(_)),
    });
};
const de_AutomatedEvaluationCustomMetricConfig = (output, context) => {
    return smithyClient.take(output, {
        customMetrics: (_) => de_AutomatedEvaluationCustomMetrics(_),
        evaluatorModelConfig: smithyClient._json,
    });
};
const de_AutomatedEvaluationCustomMetrics = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AutomatedEvaluationCustomMetricSource(core$1.awsExpectUnion(entry));
    });
    return retVal;
};
const de_AutomatedEvaluationCustomMetricSource = (output, context) => {
    if (output.customMetricDefinition != null) {
        return {
            customMetricDefinition: de_CustomMetricDefinition(output.customMetricDefinition),
        };
    }
    return { $unknown: Object.entries(output)[0] };
};
const de_AutomatedReasoningCheckFinding = (output, context) => {
    if (output.impossible != null) {
        return {
            impossible: de_AutomatedReasoningCheckImpossibleFinding(output.impossible),
        };
    }
    if (output.invalid != null) {
        return {
            invalid: de_AutomatedReasoningCheckInvalidFinding(output.invalid),
        };
    }
    if (output.noTranslations != null) {
        return {
            noTranslations: smithyClient._json(output.noTranslations),
        };
    }
    if (output.satisfiable != null) {
        return {
            satisfiable: de_AutomatedReasoningCheckSatisfiableFinding(output.satisfiable),
        };
    }
    if (output.tooComplex != null) {
        return {
            tooComplex: smithyClient._json(output.tooComplex),
        };
    }
    if (output.translationAmbiguous != null) {
        return {
            translationAmbiguous: de_AutomatedReasoningCheckTranslationAmbiguousFinding(output.translationAmbiguous),
        };
    }
    if (output.valid != null) {
        return {
            valid: de_AutomatedReasoningCheckValidFinding(output.valid),
        };
    }
    return { $unknown: Object.entries(output)[0] };
};
const de_AutomatedReasoningCheckFindingList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AutomatedReasoningCheckFinding(core$1.awsExpectUnion(entry));
    });
    return retVal;
};
const de_AutomatedReasoningCheckImpossibleFinding = (output, context) => {
    return smithyClient.take(output, {
        contradictingRules: smithyClient._json,
        logicWarning: smithyClient._json,
        translation: (_) => de_AutomatedReasoningCheckTranslation(_),
    });
};
const de_AutomatedReasoningCheckInvalidFinding = (output, context) => {
    return smithyClient.take(output, {
        contradictingRules: smithyClient._json,
        logicWarning: smithyClient._json,
        translation: (_) => de_AutomatedReasoningCheckTranslation(_),
    });
};
const de_AutomatedReasoningCheckSatisfiableFinding = (output, context) => {
    return smithyClient.take(output, {
        claimsFalseScenario: smithyClient._json,
        claimsTrueScenario: smithyClient._json,
        logicWarning: smithyClient._json,
        translation: (_) => de_AutomatedReasoningCheckTranslation(_),
    });
};
const de_AutomatedReasoningCheckTranslation = (output, context) => {
    return smithyClient.take(output, {
        claims: smithyClient._json,
        confidence: smithyClient.limitedParseDouble,
        premises: smithyClient._json,
        untranslatedClaims: smithyClient._json,
        untranslatedPremises: smithyClient._json,
    });
};
const de_AutomatedReasoningCheckTranslationAmbiguousFinding = (output, context) => {
    return smithyClient.take(output, {
        differenceScenarios: smithyClient._json,
        options: (_) => de_AutomatedReasoningCheckTranslationOptionList(_),
    });
};
const de_AutomatedReasoningCheckTranslationList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AutomatedReasoningCheckTranslation(entry);
    });
    return retVal;
};
const de_AutomatedReasoningCheckTranslationOption = (output, context) => {
    return smithyClient.take(output, {
        translations: (_) => de_AutomatedReasoningCheckTranslationList(_),
    });
};
const de_AutomatedReasoningCheckTranslationOptionList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AutomatedReasoningCheckTranslationOption(entry);
    });
    return retVal;
};
const de_AutomatedReasoningCheckValidFinding = (output, context) => {
    return smithyClient.take(output, {
        claimsTrueScenario: smithyClient._json,
        logicWarning: smithyClient._json,
        supportingRules: smithyClient._json,
        translation: (_) => de_AutomatedReasoningCheckTranslation(_),
    });
};
const de_AutomatedReasoningPolicyBuildLog = (output, context) => {
    return smithyClient.take(output, {
        entries: smithyClient._json,
    });
};
const de_AutomatedReasoningPolicyBuildResultAssets = (output, context) => {
    if (output.buildLog != null) {
        return {
            buildLog: de_AutomatedReasoningPolicyBuildLog(output.buildLog),
        };
    }
    if (output.policyDefinition != null) {
        return {
            policyDefinition: smithyClient._json(output.policyDefinition),
        };
    }
    if (output.qualityReport != null) {
        return {
            qualityReport: smithyClient._json(output.qualityReport),
        };
    }
    return { $unknown: Object.entries(output)[0] };
};
const de_AutomatedReasoningPolicyBuildWorkflowSummaries = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AutomatedReasoningPolicyBuildWorkflowSummary(entry);
    });
    return retVal;
};
const de_AutomatedReasoningPolicyBuildWorkflowSummary = (output, context) => {
    return smithyClient.take(output, {
        buildWorkflowId: smithyClient.expectString,
        buildWorkflowType: smithyClient.expectString,
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        policyArn: smithyClient.expectString,
        status: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
    });
};
const de_AutomatedReasoningPolicySummaries = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AutomatedReasoningPolicySummary(entry);
    });
    return retVal;
};
const de_AutomatedReasoningPolicySummary = (output, context) => {
    return smithyClient.take(output, {
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        description: smithyClient.expectString,
        name: smithyClient.expectString,
        policyArn: smithyClient.expectString,
        policyId: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        version: smithyClient.expectString,
    });
};
const de_AutomatedReasoningPolicyTestCase = (output, context) => {
    return smithyClient.take(output, {
        confidenceThreshold: smithyClient.limitedParseDouble,
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        expectedAggregatedFindingsResult: smithyClient.expectString,
        guardContent: smithyClient.expectString,
        queryContent: smithyClient.expectString,
        testCaseId: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
    });
};
const de_AutomatedReasoningPolicyTestCaseList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AutomatedReasoningPolicyTestCase(entry);
    });
    return retVal;
};
const de_AutomatedReasoningPolicyTestList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AutomatedReasoningPolicyTestResult(entry);
    });
    return retVal;
};
const de_AutomatedReasoningPolicyTestResult = (output, context) => {
    return smithyClient.take(output, {
        aggregatedTestFindingsResult: smithyClient.expectString,
        policyArn: smithyClient.expectString,
        testCase: (_) => de_AutomatedReasoningPolicyTestCase(_),
        testFindings: (_) => de_AutomatedReasoningCheckFindingList(_),
        testRunResult: smithyClient.expectString,
        testRunStatus: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
    });
};
const de_ByteContentDoc = (output, context) => {
    return smithyClient.take(output, {
        contentType: smithyClient.expectString,
        data: context.base64Decoder,
        identifier: smithyClient.expectString,
    });
};
const de_CustomMetricDefinition = (output, context) => {
    return smithyClient.take(output, {
        instructions: smithyClient.expectString,
        name: smithyClient.expectString,
        ratingScale: (_) => de_RatingScale(_),
    });
};
const de_CustomModelDeploymentSummary = (output, context) => {
    return smithyClient.take(output, {
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        customModelDeploymentArn: smithyClient.expectString,
        customModelDeploymentName: smithyClient.expectString,
        failureMessage: smithyClient.expectString,
        lastUpdatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        modelArn: smithyClient.expectString,
        status: smithyClient.expectString,
    });
};
const de_CustomModelDeploymentSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_CustomModelDeploymentSummary(entry);
    });
    return retVal;
};
const de_CustomModelSummary = (output, context) => {
    return smithyClient.take(output, {
        baseModelArn: smithyClient.expectString,
        baseModelName: smithyClient.expectString,
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        customizationType: smithyClient.expectString,
        modelArn: smithyClient.expectString,
        modelName: smithyClient.expectString,
        modelStatus: smithyClient.expectString,
        ownerAccountId: smithyClient.expectString,
    });
};
const de_CustomModelSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_CustomModelSummary(entry);
    });
    return retVal;
};
const de_DataProcessingDetails = (output, context) => {
    return smithyClient.take(output, {
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        lastModifiedTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        status: smithyClient.expectString,
    });
};
const de_EvaluationConfig = (output, context) => {
    if (output.automated != null) {
        return {
            automated: de_AutomatedEvaluationConfig(output.automated),
        };
    }
    if (output.human != null) {
        return {
            human: smithyClient._json(output.human),
        };
    }
    return { $unknown: Object.entries(output)[0] };
};
const de_EvaluationInferenceConfig = (output, context) => {
    if (output.models != null) {
        return {
            models: smithyClient._json(output.models),
        };
    }
    if (output.ragConfigs != null) {
        return {
            ragConfigs: de_RagConfigs(output.ragConfigs, context),
        };
    }
    return { $unknown: Object.entries(output)[0] };
};
const de_EvaluationSummaries = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_EvaluationSummary(entry);
    });
    return retVal;
};
const de_EvaluationSummary = (output, context) => {
    return smithyClient.take(output, {
        applicationType: smithyClient.expectString,
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        customMetricsEvaluatorModelIdentifiers: smithyClient._json,
        evaluationTaskTypes: smithyClient._json,
        evaluatorModelIdentifiers: smithyClient._json,
        inferenceConfigSummary: smithyClient._json,
        jobArn: smithyClient.expectString,
        jobName: smithyClient.expectString,
        jobType: smithyClient.expectString,
        modelIdentifiers: smithyClient._json,
        ragIdentifiers: smithyClient._json,
        status: smithyClient.expectString,
    });
};
const de_ExternalSource = (output, context) => {
    return smithyClient.take(output, {
        byteContent: (_) => de_ByteContentDoc(_, context),
        s3Location: smithyClient._json,
        sourceType: smithyClient.expectString,
    });
};
const de_ExternalSources = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ExternalSource(entry, context);
    });
    return retVal;
};
const de_ExternalSourcesGenerationConfiguration = (output, context) => {
    return smithyClient.take(output, {
        additionalModelRequestFields: (_) => de_AdditionalModelRequestFields(_),
        guardrailConfiguration: smithyClient._json,
        kbInferenceConfig: (_) => de_KbInferenceConfig(_),
        promptTemplate: smithyClient._json,
    });
};
const de_ExternalSourcesRetrieveAndGenerateConfiguration = (output, context) => {
    return smithyClient.take(output, {
        generationConfiguration: (_) => de_ExternalSourcesGenerationConfiguration(_),
        modelArn: smithyClient.expectString,
        sources: (_) => de_ExternalSources(_, context),
    });
};
const de_FilterAttribute = (output, context) => {
    return smithyClient.take(output, {
        key: smithyClient.expectString,
        value: (_) => de_FilterValue(_),
    });
};
const de_FilterValue = (output, context) => {
    return output;
};
const de_GenerationConfiguration = (output, context) => {
    return smithyClient.take(output, {
        additionalModelRequestFields: (_) => de_AdditionalModelRequestFields(_),
        guardrailConfiguration: smithyClient._json,
        kbInferenceConfig: (_) => de_KbInferenceConfig(_),
        promptTemplate: smithyClient._json,
    });
};
const de_GuardrailAutomatedReasoningPolicy = (output, context) => {
    return smithyClient.take(output, {
        confidenceThreshold: smithyClient.limitedParseDouble,
        policies: smithyClient._json,
    });
};
const de_GuardrailContextualGroundingFilter = (output, context) => {
    return smithyClient.take(output, {
        action: smithyClient.expectString,
        enabled: smithyClient.expectBoolean,
        threshold: smithyClient.limitedParseDouble,
        type: smithyClient.expectString,
    });
};
const de_GuardrailContextualGroundingFilters = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_GuardrailContextualGroundingFilter(entry);
    });
    return retVal;
};
const de_GuardrailContextualGroundingPolicy = (output, context) => {
    return smithyClient.take(output, {
        filters: (_) => de_GuardrailContextualGroundingFilters(_),
    });
};
const de_GuardrailSummaries = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_GuardrailSummary(entry);
    });
    return retVal;
};
const de_GuardrailSummary = (output, context) => {
    return smithyClient.take(output, {
        arn: smithyClient.expectString,
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        crossRegionDetails: smithyClient._json,
        description: smithyClient.expectString,
        id: smithyClient.expectString,
        name: smithyClient.expectString,
        status: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        version: smithyClient.expectString,
    });
};
const de_ImportedModelSummary = (output, context) => {
    return smithyClient.take(output, {
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        instructSupported: smithyClient.expectBoolean,
        modelArchitecture: smithyClient.expectString,
        modelArn: smithyClient.expectString,
        modelName: smithyClient.expectString,
    });
};
const de_ImportedModelSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ImportedModelSummary(entry);
    });
    return retVal;
};
const de_InferenceProfileSummaries = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_InferenceProfileSummary(entry);
    });
    return retVal;
};
const de_InferenceProfileSummary = (output, context) => {
    return smithyClient.take(output, {
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        description: smithyClient.expectString,
        inferenceProfileArn: smithyClient.expectString,
        inferenceProfileId: smithyClient.expectString,
        inferenceProfileName: smithyClient.expectString,
        models: smithyClient._json,
        status: smithyClient.expectString,
        type: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
    });
};
const de_KbInferenceConfig = (output, context) => {
    return smithyClient.take(output, {
        textInferenceConfig: (_) => de_TextInferenceConfig(_),
    });
};
const de_KnowledgeBaseConfig = (output, context) => {
    if (output.retrieveAndGenerateConfig != null) {
        return {
            retrieveAndGenerateConfig: de_RetrieveAndGenerateConfiguration(output.retrieveAndGenerateConfig, context),
        };
    }
    if (output.retrieveConfig != null) {
        return {
            retrieveConfig: de_RetrieveConfig(output.retrieveConfig),
        };
    }
    return { $unknown: Object.entries(output)[0] };
};
const de_KnowledgeBaseRetrievalConfiguration = (output, context) => {
    return smithyClient.take(output, {
        vectorSearchConfiguration: (_) => de_KnowledgeBaseVectorSearchConfiguration(_),
    });
};
const de_KnowledgeBaseRetrieveAndGenerateConfiguration = (output, context) => {
    return smithyClient.take(output, {
        generationConfiguration: (_) => de_GenerationConfiguration(_),
        knowledgeBaseId: smithyClient.expectString,
        modelArn: smithyClient.expectString,
        orchestrationConfiguration: smithyClient._json,
        retrievalConfiguration: (_) => de_KnowledgeBaseRetrievalConfiguration(_),
    });
};
const de_KnowledgeBaseVectorSearchConfiguration = (output, context) => {
    return smithyClient.take(output, {
        filter: (_) => de_RetrievalFilter(core$1.awsExpectUnion(_)),
        implicitFilterConfiguration: smithyClient._json,
        numberOfResults: smithyClient.expectInt32,
        overrideSearchType: smithyClient.expectString,
        rerankingConfiguration: (_) => de_VectorSearchRerankingConfiguration(_),
    });
};
const de_MarketplaceModelEndpoint = (output, context) => {
    return smithyClient.take(output, {
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        endpointArn: smithyClient.expectString,
        endpointConfig: (_) => smithyClient._json(core$1.awsExpectUnion(_)),
        endpointStatus: smithyClient.expectString,
        endpointStatusMessage: smithyClient.expectString,
        modelSourceIdentifier: smithyClient.expectString,
        status: smithyClient.expectString,
        statusMessage: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
    });
};
const de_MarketplaceModelEndpointSummaries = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_MarketplaceModelEndpointSummary(entry);
    });
    return retVal;
};
const de_MarketplaceModelEndpointSummary = (output, context) => {
    return smithyClient.take(output, {
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        endpointArn: smithyClient.expectString,
        modelSourceIdentifier: smithyClient.expectString,
        status: smithyClient.expectString,
        statusMessage: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
    });
};
const de_ModelCopyJobSummaries = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ModelCopyJobSummary(entry);
    });
    return retVal;
};
const de_ModelCopyJobSummary = (output, context) => {
    return smithyClient.take(output, {
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        failureMessage: smithyClient.expectString,
        jobArn: smithyClient.expectString,
        sourceAccountId: smithyClient.expectString,
        sourceModelArn: smithyClient.expectString,
        sourceModelName: smithyClient.expectString,
        status: smithyClient.expectString,
        targetModelArn: smithyClient.expectString,
        targetModelKmsKeyArn: smithyClient.expectString,
        targetModelName: smithyClient.expectString,
        targetModelTags: smithyClient._json,
    });
};
const de_ModelCustomizationJobSummaries = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ModelCustomizationJobSummary(entry);
    });
    return retVal;
};
const de_ModelCustomizationJobSummary = (output, context) => {
    return smithyClient.take(output, {
        baseModelArn: smithyClient.expectString,
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        customModelArn: smithyClient.expectString,
        customModelName: smithyClient.expectString,
        customizationType: smithyClient.expectString,
        endTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        jobArn: smithyClient.expectString,
        jobName: smithyClient.expectString,
        lastModifiedTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        status: smithyClient.expectString,
        statusDetails: (_) => de_StatusDetails(_),
    });
};
const de_ModelImportJobSummaries = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ModelImportJobSummary(entry);
    });
    return retVal;
};
const de_ModelImportJobSummary = (output, context) => {
    return smithyClient.take(output, {
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        endTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        importedModelArn: smithyClient.expectString,
        importedModelName: smithyClient.expectString,
        jobArn: smithyClient.expectString,
        jobName: smithyClient.expectString,
        lastModifiedTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        status: smithyClient.expectString,
    });
};
const de_ModelInvocationJobSummaries = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ModelInvocationJobSummary(entry);
    });
    return retVal;
};
const de_ModelInvocationJobSummary = (output, context) => {
    return smithyClient.take(output, {
        clientRequestToken: smithyClient.expectString,
        endTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        inputDataConfig: (_) => smithyClient._json(core$1.awsExpectUnion(_)),
        jobArn: smithyClient.expectString,
        jobExpirationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        jobName: smithyClient.expectString,
        lastModifiedTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        message: smithyClient.expectString,
        modelId: smithyClient.expectString,
        outputDataConfig: (_) => smithyClient._json(core$1.awsExpectUnion(_)),
        roleArn: smithyClient.expectString,
        status: smithyClient.expectString,
        submitTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        timeoutDurationInHours: smithyClient.expectInt32,
        vpcConfig: smithyClient._json,
    });
};
const de_PromptRouterSummaries = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_PromptRouterSummary(entry);
    });
    return retVal;
};
const de_PromptRouterSummary = (output, context) => {
    return smithyClient.take(output, {
        createdAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        description: smithyClient.expectString,
        fallbackModel: smithyClient._json,
        models: smithyClient._json,
        promptRouterArn: smithyClient.expectString,
        promptRouterName: smithyClient.expectString,
        routingCriteria: (_) => de_RoutingCriteria(_),
        status: smithyClient.expectString,
        type: smithyClient.expectString,
        updatedAt: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
    });
};
const de_ProvisionedModelSummaries = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ProvisionedModelSummary(entry);
    });
    return retVal;
};
const de_ProvisionedModelSummary = (output, context) => {
    return smithyClient.take(output, {
        commitmentDuration: smithyClient.expectString,
        commitmentExpirationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        desiredModelArn: smithyClient.expectString,
        desiredModelUnits: smithyClient.expectInt32,
        foundationModelArn: smithyClient.expectString,
        lastModifiedTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        modelArn: smithyClient.expectString,
        modelUnits: smithyClient.expectInt32,
        provisionedModelArn: smithyClient.expectString,
        provisionedModelName: smithyClient.expectString,
        status: smithyClient.expectString,
    });
};
const de_RAGConfig = (output, context) => {
    if (output.knowledgeBaseConfig != null) {
        return {
            knowledgeBaseConfig: de_KnowledgeBaseConfig(core$1.awsExpectUnion(output.knowledgeBaseConfig), context),
        };
    }
    if (output.precomputedRagSourceConfig != null) {
        return {
            precomputedRagSourceConfig: smithyClient._json(core$1.awsExpectUnion(output.precomputedRagSourceConfig)),
        };
    }
    return { $unknown: Object.entries(output)[0] };
};
const de_RagConfigs = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_RAGConfig(core$1.awsExpectUnion(entry), context);
    });
    return retVal;
};
const de_RatingScale = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_RatingScaleItem(entry);
    });
    return retVal;
};
const de_RatingScaleItem = (output, context) => {
    return smithyClient.take(output, {
        definition: smithyClient.expectString,
        value: (_) => de_RatingScaleItemValue(core$1.awsExpectUnion(_)),
    });
};
const de_RatingScaleItemValue = (output, context) => {
    if (smithyClient.limitedParseFloat32(output.floatValue) !== undefined) {
        return { floatValue: smithyClient.limitedParseFloat32(output.floatValue) };
    }
    if (smithyClient.expectString(output.stringValue) !== undefined) {
        return { stringValue: smithyClient.expectString(output.stringValue) };
    }
    return { $unknown: Object.entries(output)[0] };
};
const de_RetrievalFilter = (output, context) => {
    if (output.andAll != null) {
        return {
            andAll: de_RetrievalFilterList(output.andAll),
        };
    }
    if (output.equals != null) {
        return {
            equals: de_FilterAttribute(output.equals),
        };
    }
    if (output.greaterThan != null) {
        return {
            greaterThan: de_FilterAttribute(output.greaterThan),
        };
    }
    if (output.greaterThanOrEquals != null) {
        return {
            greaterThanOrEquals: de_FilterAttribute(output.greaterThanOrEquals),
        };
    }
    if (output.in != null) {
        return {
            in: de_FilterAttribute(output.in),
        };
    }
    if (output.lessThan != null) {
        return {
            lessThan: de_FilterAttribute(output.lessThan),
        };
    }
    if (output.lessThanOrEquals != null) {
        return {
            lessThanOrEquals: de_FilterAttribute(output.lessThanOrEquals),
        };
    }
    if (output.listContains != null) {
        return {
            listContains: de_FilterAttribute(output.listContains),
        };
    }
    if (output.notEquals != null) {
        return {
            notEquals: de_FilterAttribute(output.notEquals),
        };
    }
    if (output.notIn != null) {
        return {
            notIn: de_FilterAttribute(output.notIn),
        };
    }
    if (output.orAll != null) {
        return {
            orAll: de_RetrievalFilterList(output.orAll),
        };
    }
    if (output.startsWith != null) {
        return {
            startsWith: de_FilterAttribute(output.startsWith),
        };
    }
    if (output.stringContains != null) {
        return {
            stringContains: de_FilterAttribute(output.stringContains),
        };
    }
    return { $unknown: Object.entries(output)[0] };
};
const de_RetrievalFilterList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_RetrievalFilter(core$1.awsExpectUnion(entry));
    });
    return retVal;
};
const de_RetrieveAndGenerateConfiguration = (output, context) => {
    return smithyClient.take(output, {
        externalSourcesConfiguration: (_) => de_ExternalSourcesRetrieveAndGenerateConfiguration(_, context),
        knowledgeBaseConfiguration: (_) => de_KnowledgeBaseRetrieveAndGenerateConfiguration(_),
        type: smithyClient.expectString,
    });
};
const de_RetrieveConfig = (output, context) => {
    return smithyClient.take(output, {
        knowledgeBaseId: smithyClient.expectString,
        knowledgeBaseRetrievalConfiguration: (_) => de_KnowledgeBaseRetrievalConfiguration(_),
    });
};
const de_RoutingCriteria = (output, context) => {
    return smithyClient.take(output, {
        responseQualityDifference: smithyClient.limitedParseDouble,
    });
};
const de_StatusDetails = (output, context) => {
    return smithyClient.take(output, {
        dataProcessingDetails: (_) => de_DataProcessingDetails(_),
        trainingDetails: (_) => de_TrainingDetails(_),
        validationDetails: (_) => de_ValidationDetails(_),
    });
};
const de_TextInferenceConfig = (output, context) => {
    return smithyClient.take(output, {
        maxTokens: smithyClient.expectInt32,
        stopSequences: smithyClient._json,
        temperature: smithyClient.limitedParseFloat32,
        topP: smithyClient.limitedParseFloat32,
    });
};
const de_TrainingDetails = (output, context) => {
    return smithyClient.take(output, {
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        lastModifiedTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        status: smithyClient.expectString,
    });
};
const de_TrainingMetrics = (output, context) => {
    return smithyClient.take(output, {
        trainingLoss: smithyClient.limitedParseFloat32,
    });
};
const de_ValidationDetails = (output, context) => {
    return smithyClient.take(output, {
        creationTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        lastModifiedTime: (_) => smithyClient.expectNonNull(smithyClient.parseRfc3339DateTimeWithOffset(_)),
        status: smithyClient.expectString,
    });
};
const de_ValidationMetrics = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ValidatorMetric(entry);
    });
    return retVal;
};
const de_ValidatorMetric = (output, context) => {
    return smithyClient.take(output, {
        validationLoss: smithyClient.limitedParseFloat32,
    });
};
const de_VectorSearchBedrockRerankingConfiguration = (output, context) => {
    return smithyClient.take(output, {
        metadataConfiguration: smithyClient._json,
        modelConfiguration: (_) => de_VectorSearchBedrockRerankingModelConfiguration(_),
        numberOfRerankedResults: smithyClient.expectInt32,
    });
};
const de_VectorSearchBedrockRerankingModelConfiguration = (output, context) => {
    return smithyClient.take(output, {
        additionalModelRequestFields: (_) => de_AdditionalModelRequestFields(_),
        modelArn: smithyClient.expectString,
    });
};
const de_VectorSearchRerankingConfiguration = (output, context) => {
    return smithyClient.take(output, {
        bedrockRerankingConfiguration: (_) => de_VectorSearchBedrockRerankingConfiguration(_),
        type: smithyClient.expectString,
    });
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const _aT = "assetType";
const _aTE = "applicationTypeEquals";
const _bCT = "byCustomizationType";
const _bIT = "byInferenceType";
const _bMAE = "baseModelArnEquals";
const _bOM = "byOutputModality";
const _bP = "byProvider";
const _cA = "createdAfter";
const _cB = "createdBefore";
const _cRT = "clientRequestToken";
const _cTA = "creationTimeAfter";
const _cTB = "creationTimeBefore";
const _f = "force";
const _fMAE = "foundationModelArnEquals";
const _gI = "guardrailIdentifier";
const _gV = "guardrailVersion";
const _iO = "isOwned";
const _lUA = "lastUpdatedAt";
const _mAE = "modelArnEquals";
const _mR = "maxResults";
const _mS = "modelStatus";
const _mSE = "modelSourceEquals";
const _mSI = "modelSourceIdentifier";
const _nC = "nameContains";
const _nT = "nextToken";
const _oMNC = "outputModelNameContains";
const _oT = "offerType";
const _pA = "policyArn";
const _sAE = "sourceAccountEquals";
const _sB = "sortBy";
const _sE = "statusEquals";
const _sMAE = "sourceModelArnEquals";
const _sO = "sortOrder";
const _sTA = "submitTimeAfter";
const _sTB = "submitTimeBefore";
const _t = "type";
const _tE = "typeEquals";
const _tMNC = "targetModelNameContains";
const _uA = "updatedAt";
const _xact = "x-amz-client-token";

class BatchDeleteEvaluationJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "BatchDeleteEvaluationJob", {})
    .n("BedrockClient", "BatchDeleteEvaluationJobCommand")
    .f(BatchDeleteEvaluationJobRequestFilterSensitiveLog, BatchDeleteEvaluationJobResponseFilterSensitiveLog)
    .ser(se_BatchDeleteEvaluationJobCommand)
    .de(de_BatchDeleteEvaluationJobCommand)
    .build() {
}

class CancelAutomatedReasoningPolicyBuildWorkflowCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CancelAutomatedReasoningPolicyBuildWorkflow", {})
    .n("BedrockClient", "CancelAutomatedReasoningPolicyBuildWorkflowCommand")
    .f(void 0, void 0)
    .ser(se_CancelAutomatedReasoningPolicyBuildWorkflowCommand)
    .de(de_CancelAutomatedReasoningPolicyBuildWorkflowCommand)
    .build() {
}

class CreateAutomatedReasoningPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateAutomatedReasoningPolicy", {})
    .n("BedrockClient", "CreateAutomatedReasoningPolicyCommand")
    .f(CreateAutomatedReasoningPolicyRequestFilterSensitiveLog, CreateAutomatedReasoningPolicyResponseFilterSensitiveLog)
    .ser(se_CreateAutomatedReasoningPolicyCommand)
    .de(de_CreateAutomatedReasoningPolicyCommand)
    .build() {
}

class CreateAutomatedReasoningPolicyTestCaseCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateAutomatedReasoningPolicyTestCase", {})
    .n("BedrockClient", "CreateAutomatedReasoningPolicyTestCaseCommand")
    .f(CreateAutomatedReasoningPolicyTestCaseRequestFilterSensitiveLog, void 0)
    .ser(se_CreateAutomatedReasoningPolicyTestCaseCommand)
    .de(de_CreateAutomatedReasoningPolicyTestCaseCommand)
    .build() {
}

class CreateAutomatedReasoningPolicyVersionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateAutomatedReasoningPolicyVersion", {})
    .n("BedrockClient", "CreateAutomatedReasoningPolicyVersionCommand")
    .f(void 0, CreateAutomatedReasoningPolicyVersionResponseFilterSensitiveLog)
    .ser(se_CreateAutomatedReasoningPolicyVersionCommand)
    .de(de_CreateAutomatedReasoningPolicyVersionCommand)
    .build() {
}

class CreateCustomModelCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateCustomModel", {})
    .n("BedrockClient", "CreateCustomModelCommand")
    .f(void 0, void 0)
    .ser(se_CreateCustomModelCommand)
    .de(de_CreateCustomModelCommand)
    .build() {
}

class CreateCustomModelDeploymentCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateCustomModelDeployment", {})
    .n("BedrockClient", "CreateCustomModelDeploymentCommand")
    .f(void 0, void 0)
    .ser(se_CreateCustomModelDeploymentCommand)
    .de(de_CreateCustomModelDeploymentCommand)
    .build() {
}

class CreateEvaluationJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateEvaluationJob", {})
    .n("BedrockClient", "CreateEvaluationJobCommand")
    .f(CreateEvaluationJobRequestFilterSensitiveLog, void 0)
    .ser(se_CreateEvaluationJobCommand)
    .de(de_CreateEvaluationJobCommand)
    .build() {
}

class CreateFoundationModelAgreementCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateFoundationModelAgreement", {})
    .n("BedrockClient", "CreateFoundationModelAgreementCommand")
    .f(void 0, void 0)
    .ser(se_CreateFoundationModelAgreementCommand)
    .de(de_CreateFoundationModelAgreementCommand)
    .build() {
}

class CreateGuardrailCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateGuardrail", {})
    .n("BedrockClient", "CreateGuardrailCommand")
    .f(CreateGuardrailRequestFilterSensitiveLog, void 0)
    .ser(se_CreateGuardrailCommand)
    .de(de_CreateGuardrailCommand)
    .build() {
}

class CreateGuardrailVersionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateGuardrailVersion", {})
    .n("BedrockClient", "CreateGuardrailVersionCommand")
    .f(CreateGuardrailVersionRequestFilterSensitiveLog, void 0)
    .ser(se_CreateGuardrailVersionCommand)
    .de(de_CreateGuardrailVersionCommand)
    .build() {
}

class CreateInferenceProfileCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateInferenceProfile", {})
    .n("BedrockClient", "CreateInferenceProfileCommand")
    .f(CreateInferenceProfileRequestFilterSensitiveLog, void 0)
    .ser(se_CreateInferenceProfileCommand)
    .de(de_CreateInferenceProfileCommand)
    .build() {
}

class CreateMarketplaceModelEndpointCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateMarketplaceModelEndpoint", {})
    .n("BedrockClient", "CreateMarketplaceModelEndpointCommand")
    .f(void 0, void 0)
    .ser(se_CreateMarketplaceModelEndpointCommand)
    .de(de_CreateMarketplaceModelEndpointCommand)
    .build() {
}

class CreateModelCopyJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateModelCopyJob", {})
    .n("BedrockClient", "CreateModelCopyJobCommand")
    .f(void 0, void 0)
    .ser(se_CreateModelCopyJobCommand)
    .de(de_CreateModelCopyJobCommand)
    .build() {
}

class CreateModelCustomizationJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateModelCustomizationJob", {})
    .n("BedrockClient", "CreateModelCustomizationJobCommand")
    .f(CreateModelCustomizationJobRequestFilterSensitiveLog, void 0)
    .ser(se_CreateModelCustomizationJobCommand)
    .de(de_CreateModelCustomizationJobCommand)
    .build() {
}

class CreateModelImportJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateModelImportJob", {})
    .n("BedrockClient", "CreateModelImportJobCommand")
    .f(void 0, void 0)
    .ser(se_CreateModelImportJobCommand)
    .de(de_CreateModelImportJobCommand)
    .build() {
}

class CreateModelInvocationJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateModelInvocationJob", {})
    .n("BedrockClient", "CreateModelInvocationJobCommand")
    .f(void 0, void 0)
    .ser(se_CreateModelInvocationJobCommand)
    .de(de_CreateModelInvocationJobCommand)
    .build() {
}

class CreatePromptRouterCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreatePromptRouter", {})
    .n("BedrockClient", "CreatePromptRouterCommand")
    .f(CreatePromptRouterRequestFilterSensitiveLog, void 0)
    .ser(se_CreatePromptRouterCommand)
    .de(de_CreatePromptRouterCommand)
    .build() {
}

class CreateProvisionedModelThroughputCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateProvisionedModelThroughput", {})
    .n("BedrockClient", "CreateProvisionedModelThroughputCommand")
    .f(void 0, void 0)
    .ser(se_CreateProvisionedModelThroughputCommand)
    .de(de_CreateProvisionedModelThroughputCommand)
    .build() {
}

class DeleteAutomatedReasoningPolicyBuildWorkflowCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeleteAutomatedReasoningPolicyBuildWorkflow", {})
    .n("BedrockClient", "DeleteAutomatedReasoningPolicyBuildWorkflowCommand")
    .f(void 0, void 0)
    .ser(se_DeleteAutomatedReasoningPolicyBuildWorkflowCommand)
    .de(de_DeleteAutomatedReasoningPolicyBuildWorkflowCommand)
    .build() {
}

class DeleteAutomatedReasoningPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeleteAutomatedReasoningPolicy", {})
    .n("BedrockClient", "DeleteAutomatedReasoningPolicyCommand")
    .f(void 0, void 0)
    .ser(se_DeleteAutomatedReasoningPolicyCommand)
    .de(de_DeleteAutomatedReasoningPolicyCommand)
    .build() {
}

class DeleteAutomatedReasoningPolicyTestCaseCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeleteAutomatedReasoningPolicyTestCase", {})
    .n("BedrockClient", "DeleteAutomatedReasoningPolicyTestCaseCommand")
    .f(void 0, void 0)
    .ser(se_DeleteAutomatedReasoningPolicyTestCaseCommand)
    .de(de_DeleteAutomatedReasoningPolicyTestCaseCommand)
    .build() {
}

class DeleteCustomModelCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeleteCustomModel", {})
    .n("BedrockClient", "DeleteCustomModelCommand")
    .f(void 0, void 0)
    .ser(se_DeleteCustomModelCommand)
    .de(de_DeleteCustomModelCommand)
    .build() {
}

class DeleteCustomModelDeploymentCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeleteCustomModelDeployment", {})
    .n("BedrockClient", "DeleteCustomModelDeploymentCommand")
    .f(void 0, void 0)
    .ser(se_DeleteCustomModelDeploymentCommand)
    .de(de_DeleteCustomModelDeploymentCommand)
    .build() {
}

class DeleteFoundationModelAgreementCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeleteFoundationModelAgreement", {})
    .n("BedrockClient", "DeleteFoundationModelAgreementCommand")
    .f(void 0, void 0)
    .ser(se_DeleteFoundationModelAgreementCommand)
    .de(de_DeleteFoundationModelAgreementCommand)
    .build() {
}

class DeleteGuardrailCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeleteGuardrail", {})
    .n("BedrockClient", "DeleteGuardrailCommand")
    .f(void 0, void 0)
    .ser(se_DeleteGuardrailCommand)
    .de(de_DeleteGuardrailCommand)
    .build() {
}

class DeleteImportedModelCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeleteImportedModel", {})
    .n("BedrockClient", "DeleteImportedModelCommand")
    .f(void 0, void 0)
    .ser(se_DeleteImportedModelCommand)
    .de(de_DeleteImportedModelCommand)
    .build() {
}

class DeleteInferenceProfileCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeleteInferenceProfile", {})
    .n("BedrockClient", "DeleteInferenceProfileCommand")
    .f(void 0, void 0)
    .ser(se_DeleteInferenceProfileCommand)
    .de(de_DeleteInferenceProfileCommand)
    .build() {
}

class DeleteMarketplaceModelEndpointCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeleteMarketplaceModelEndpoint", {})
    .n("BedrockClient", "DeleteMarketplaceModelEndpointCommand")
    .f(void 0, void 0)
    .ser(se_DeleteMarketplaceModelEndpointCommand)
    .de(de_DeleteMarketplaceModelEndpointCommand)
    .build() {
}

class DeleteModelInvocationLoggingConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeleteModelInvocationLoggingConfiguration", {})
    .n("BedrockClient", "DeleteModelInvocationLoggingConfigurationCommand")
    .f(void 0, void 0)
    .ser(se_DeleteModelInvocationLoggingConfigurationCommand)
    .de(de_DeleteModelInvocationLoggingConfigurationCommand)
    .build() {
}

class DeletePromptRouterCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeletePromptRouter", {})
    .n("BedrockClient", "DeletePromptRouterCommand")
    .f(void 0, void 0)
    .ser(se_DeletePromptRouterCommand)
    .de(de_DeletePromptRouterCommand)
    .build() {
}

class DeleteProvisionedModelThroughputCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeleteProvisionedModelThroughput", {})
    .n("BedrockClient", "DeleteProvisionedModelThroughputCommand")
    .f(void 0, void 0)
    .ser(se_DeleteProvisionedModelThroughputCommand)
    .de(de_DeleteProvisionedModelThroughputCommand)
    .build() {
}

class DeregisterMarketplaceModelEndpointCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "DeregisterMarketplaceModelEndpoint", {})
    .n("BedrockClient", "DeregisterMarketplaceModelEndpointCommand")
    .f(void 0, void 0)
    .ser(se_DeregisterMarketplaceModelEndpointCommand)
    .de(de_DeregisterMarketplaceModelEndpointCommand)
    .build() {
}

class ExportAutomatedReasoningPolicyVersionCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ExportAutomatedReasoningPolicyVersion", {})
    .n("BedrockClient", "ExportAutomatedReasoningPolicyVersionCommand")
    .f(void 0, ExportAutomatedReasoningPolicyVersionResponseFilterSensitiveLog)
    .ser(se_ExportAutomatedReasoningPolicyVersionCommand)
    .de(de_ExportAutomatedReasoningPolicyVersionCommand)
    .build() {
}

class GetAutomatedReasoningPolicyAnnotationsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetAutomatedReasoningPolicyAnnotations", {})
    .n("BedrockClient", "GetAutomatedReasoningPolicyAnnotationsCommand")
    .f(void 0, GetAutomatedReasoningPolicyAnnotationsResponseFilterSensitiveLog)
    .ser(se_GetAutomatedReasoningPolicyAnnotationsCommand)
    .de(de_GetAutomatedReasoningPolicyAnnotationsCommand)
    .build() {
}

class GetAutomatedReasoningPolicyBuildWorkflowCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetAutomatedReasoningPolicyBuildWorkflow", {})
    .n("BedrockClient", "GetAutomatedReasoningPolicyBuildWorkflowCommand")
    .f(void 0, GetAutomatedReasoningPolicyBuildWorkflowResponseFilterSensitiveLog)
    .ser(se_GetAutomatedReasoningPolicyBuildWorkflowCommand)
    .de(de_GetAutomatedReasoningPolicyBuildWorkflowCommand)
    .build() {
}

class GetAutomatedReasoningPolicyBuildWorkflowResultAssetsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetAutomatedReasoningPolicyBuildWorkflowResultAssets", {})
    .n("BedrockClient", "GetAutomatedReasoningPolicyBuildWorkflowResultAssetsCommand")
    .f(void 0, GetAutomatedReasoningPolicyBuildWorkflowResultAssetsResponseFilterSensitiveLog)
    .ser(se_GetAutomatedReasoningPolicyBuildWorkflowResultAssetsCommand)
    .de(de_GetAutomatedReasoningPolicyBuildWorkflowResultAssetsCommand)
    .build() {
}

class GetAutomatedReasoningPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetAutomatedReasoningPolicy", {})
    .n("BedrockClient", "GetAutomatedReasoningPolicyCommand")
    .f(void 0, GetAutomatedReasoningPolicyResponseFilterSensitiveLog)
    .ser(se_GetAutomatedReasoningPolicyCommand)
    .de(de_GetAutomatedReasoningPolicyCommand)
    .build() {
}

class GetAutomatedReasoningPolicyNextScenarioCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetAutomatedReasoningPolicyNextScenario", {})
    .n("BedrockClient", "GetAutomatedReasoningPolicyNextScenarioCommand")
    .f(void 0, GetAutomatedReasoningPolicyNextScenarioResponseFilterSensitiveLog)
    .ser(se_GetAutomatedReasoningPolicyNextScenarioCommand)
    .de(de_GetAutomatedReasoningPolicyNextScenarioCommand)
    .build() {
}

class GetAutomatedReasoningPolicyTestCaseCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetAutomatedReasoningPolicyTestCase", {})
    .n("BedrockClient", "GetAutomatedReasoningPolicyTestCaseCommand")
    .f(void 0, GetAutomatedReasoningPolicyTestCaseResponseFilterSensitiveLog)
    .ser(se_GetAutomatedReasoningPolicyTestCaseCommand)
    .de(de_GetAutomatedReasoningPolicyTestCaseCommand)
    .build() {
}

class GetAutomatedReasoningPolicyTestResultCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetAutomatedReasoningPolicyTestResult", {})
    .n("BedrockClient", "GetAutomatedReasoningPolicyTestResultCommand")
    .f(void 0, GetAutomatedReasoningPolicyTestResultResponseFilterSensitiveLog)
    .ser(se_GetAutomatedReasoningPolicyTestResultCommand)
    .de(de_GetAutomatedReasoningPolicyTestResultCommand)
    .build() {
}

class GetCustomModelCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetCustomModel", {})
    .n("BedrockClient", "GetCustomModelCommand")
    .f(void 0, GetCustomModelResponseFilterSensitiveLog)
    .ser(se_GetCustomModelCommand)
    .de(de_GetCustomModelCommand)
    .build() {
}

class GetCustomModelDeploymentCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetCustomModelDeployment", {})
    .n("BedrockClient", "GetCustomModelDeploymentCommand")
    .f(void 0, void 0)
    .ser(se_GetCustomModelDeploymentCommand)
    .de(de_GetCustomModelDeploymentCommand)
    .build() {
}

class GetEvaluationJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetEvaluationJob", {})
    .n("BedrockClient", "GetEvaluationJobCommand")
    .f(GetEvaluationJobRequestFilterSensitiveLog, GetEvaluationJobResponseFilterSensitiveLog)
    .ser(se_GetEvaluationJobCommand)
    .de(de_GetEvaluationJobCommand)
    .build() {
}

class GetFoundationModelAvailabilityCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetFoundationModelAvailability", {})
    .n("BedrockClient", "GetFoundationModelAvailabilityCommand")
    .f(void 0, void 0)
    .ser(se_GetFoundationModelAvailabilityCommand)
    .de(de_GetFoundationModelAvailabilityCommand)
    .build() {
}

class GetFoundationModelCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetFoundationModel", {})
    .n("BedrockClient", "GetFoundationModelCommand")
    .f(void 0, void 0)
    .ser(se_GetFoundationModelCommand)
    .de(de_GetFoundationModelCommand)
    .build() {
}

class GetGuardrailCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetGuardrail", {})
    .n("BedrockClient", "GetGuardrailCommand")
    .f(void 0, GetGuardrailResponseFilterSensitiveLog)
    .ser(se_GetGuardrailCommand)
    .de(de_GetGuardrailCommand)
    .build() {
}

class GetImportedModelCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetImportedModel", {})
    .n("BedrockClient", "GetImportedModelCommand")
    .f(void 0, void 0)
    .ser(se_GetImportedModelCommand)
    .de(de_GetImportedModelCommand)
    .build() {
}

class GetInferenceProfileCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetInferenceProfile", {})
    .n("BedrockClient", "GetInferenceProfileCommand")
    .f(void 0, GetInferenceProfileResponseFilterSensitiveLog)
    .ser(se_GetInferenceProfileCommand)
    .de(de_GetInferenceProfileCommand)
    .build() {
}

class GetMarketplaceModelEndpointCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetMarketplaceModelEndpoint", {})
    .n("BedrockClient", "GetMarketplaceModelEndpointCommand")
    .f(void 0, void 0)
    .ser(se_GetMarketplaceModelEndpointCommand)
    .de(de_GetMarketplaceModelEndpointCommand)
    .build() {
}

class GetModelCopyJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetModelCopyJob", {})
    .n("BedrockClient", "GetModelCopyJobCommand")
    .f(void 0, void 0)
    .ser(se_GetModelCopyJobCommand)
    .de(de_GetModelCopyJobCommand)
    .build() {
}

class GetModelCustomizationJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetModelCustomizationJob", {})
    .n("BedrockClient", "GetModelCustomizationJobCommand")
    .f(void 0, GetModelCustomizationJobResponseFilterSensitiveLog)
    .ser(se_GetModelCustomizationJobCommand)
    .de(de_GetModelCustomizationJobCommand)
    .build() {
}

class GetModelImportJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetModelImportJob", {})
    .n("BedrockClient", "GetModelImportJobCommand")
    .f(void 0, void 0)
    .ser(se_GetModelImportJobCommand)
    .de(de_GetModelImportJobCommand)
    .build() {
}

class GetModelInvocationJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetModelInvocationJob", {})
    .n("BedrockClient", "GetModelInvocationJobCommand")
    .f(void 0, GetModelInvocationJobResponseFilterSensitiveLog)
    .ser(se_GetModelInvocationJobCommand)
    .de(de_GetModelInvocationJobCommand)
    .build() {
}

class GetModelInvocationLoggingConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetModelInvocationLoggingConfiguration", {})
    .n("BedrockClient", "GetModelInvocationLoggingConfigurationCommand")
    .f(void 0, void 0)
    .ser(se_GetModelInvocationLoggingConfigurationCommand)
    .de(de_GetModelInvocationLoggingConfigurationCommand)
    .build() {
}

class GetPromptRouterCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetPromptRouter", {})
    .n("BedrockClient", "GetPromptRouterCommand")
    .f(void 0, GetPromptRouterResponseFilterSensitiveLog)
    .ser(se_GetPromptRouterCommand)
    .de(de_GetPromptRouterCommand)
    .build() {
}

class GetProvisionedModelThroughputCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetProvisionedModelThroughput", {})
    .n("BedrockClient", "GetProvisionedModelThroughputCommand")
    .f(void 0, void 0)
    .ser(se_GetProvisionedModelThroughputCommand)
    .de(de_GetProvisionedModelThroughputCommand)
    .build() {
}

class GetUseCaseForModelAccessCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetUseCaseForModelAccess", {})
    .n("BedrockClient", "GetUseCaseForModelAccessCommand")
    .f(void 0, void 0)
    .ser(se_GetUseCaseForModelAccessCommand)
    .de(de_GetUseCaseForModelAccessCommand)
    .build() {
}

class ListAutomatedReasoningPoliciesCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListAutomatedReasoningPolicies", {})
    .n("BedrockClient", "ListAutomatedReasoningPoliciesCommand")
    .f(void 0, ListAutomatedReasoningPoliciesResponseFilterSensitiveLog)
    .ser(se_ListAutomatedReasoningPoliciesCommand)
    .de(de_ListAutomatedReasoningPoliciesCommand)
    .build() {
}

class ListAutomatedReasoningPolicyBuildWorkflowsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListAutomatedReasoningPolicyBuildWorkflows", {})
    .n("BedrockClient", "ListAutomatedReasoningPolicyBuildWorkflowsCommand")
    .f(void 0, void 0)
    .ser(se_ListAutomatedReasoningPolicyBuildWorkflowsCommand)
    .de(de_ListAutomatedReasoningPolicyBuildWorkflowsCommand)
    .build() {
}

class ListAutomatedReasoningPolicyTestCasesCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListAutomatedReasoningPolicyTestCases", {})
    .n("BedrockClient", "ListAutomatedReasoningPolicyTestCasesCommand")
    .f(void 0, ListAutomatedReasoningPolicyTestCasesResponseFilterSensitiveLog)
    .ser(se_ListAutomatedReasoningPolicyTestCasesCommand)
    .de(de_ListAutomatedReasoningPolicyTestCasesCommand)
    .build() {
}

class ListAutomatedReasoningPolicyTestResultsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListAutomatedReasoningPolicyTestResults", {})
    .n("BedrockClient", "ListAutomatedReasoningPolicyTestResultsCommand")
    .f(void 0, ListAutomatedReasoningPolicyTestResultsResponseFilterSensitiveLog)
    .ser(se_ListAutomatedReasoningPolicyTestResultsCommand)
    .de(de_ListAutomatedReasoningPolicyTestResultsCommand)
    .build() {
}

class ListCustomModelDeploymentsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListCustomModelDeployments", {})
    .n("BedrockClient", "ListCustomModelDeploymentsCommand")
    .f(void 0, void 0)
    .ser(se_ListCustomModelDeploymentsCommand)
    .de(de_ListCustomModelDeploymentsCommand)
    .build() {
}

class ListCustomModelsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListCustomModels", {})
    .n("BedrockClient", "ListCustomModelsCommand")
    .f(void 0, void 0)
    .ser(se_ListCustomModelsCommand)
    .de(de_ListCustomModelsCommand)
    .build() {
}

class ListEvaluationJobsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListEvaluationJobs", {})
    .n("BedrockClient", "ListEvaluationJobsCommand")
    .f(void 0, void 0)
    .ser(se_ListEvaluationJobsCommand)
    .de(de_ListEvaluationJobsCommand)
    .build() {
}

class ListFoundationModelAgreementOffersCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListFoundationModelAgreementOffers", {})
    .n("BedrockClient", "ListFoundationModelAgreementOffersCommand")
    .f(void 0, void 0)
    .ser(se_ListFoundationModelAgreementOffersCommand)
    .de(de_ListFoundationModelAgreementOffersCommand)
    .build() {
}

class ListFoundationModelsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListFoundationModels", {})
    .n("BedrockClient", "ListFoundationModelsCommand")
    .f(void 0, void 0)
    .ser(se_ListFoundationModelsCommand)
    .de(de_ListFoundationModelsCommand)
    .build() {
}

class ListGuardrailsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListGuardrails", {})
    .n("BedrockClient", "ListGuardrailsCommand")
    .f(void 0, ListGuardrailsResponseFilterSensitiveLog)
    .ser(se_ListGuardrailsCommand)
    .de(de_ListGuardrailsCommand)
    .build() {
}

class ListImportedModelsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListImportedModels", {})
    .n("BedrockClient", "ListImportedModelsCommand")
    .f(void 0, void 0)
    .ser(se_ListImportedModelsCommand)
    .de(de_ListImportedModelsCommand)
    .build() {
}

class ListInferenceProfilesCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListInferenceProfiles", {})
    .n("BedrockClient", "ListInferenceProfilesCommand")
    .f(void 0, ListInferenceProfilesResponseFilterSensitiveLog)
    .ser(se_ListInferenceProfilesCommand)
    .de(de_ListInferenceProfilesCommand)
    .build() {
}

class ListMarketplaceModelEndpointsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListMarketplaceModelEndpoints", {})
    .n("BedrockClient", "ListMarketplaceModelEndpointsCommand")
    .f(void 0, void 0)
    .ser(se_ListMarketplaceModelEndpointsCommand)
    .de(de_ListMarketplaceModelEndpointsCommand)
    .build() {
}

class ListModelCopyJobsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListModelCopyJobs", {})
    .n("BedrockClient", "ListModelCopyJobsCommand")
    .f(void 0, void 0)
    .ser(se_ListModelCopyJobsCommand)
    .de(de_ListModelCopyJobsCommand)
    .build() {
}

class ListModelCustomizationJobsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListModelCustomizationJobs", {})
    .n("BedrockClient", "ListModelCustomizationJobsCommand")
    .f(void 0, void 0)
    .ser(se_ListModelCustomizationJobsCommand)
    .de(de_ListModelCustomizationJobsCommand)
    .build() {
}

class ListModelImportJobsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListModelImportJobs", {})
    .n("BedrockClient", "ListModelImportJobsCommand")
    .f(void 0, void 0)
    .ser(se_ListModelImportJobsCommand)
    .de(de_ListModelImportJobsCommand)
    .build() {
}

class ListModelInvocationJobsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListModelInvocationJobs", {})
    .n("BedrockClient", "ListModelInvocationJobsCommand")
    .f(void 0, ListModelInvocationJobsResponseFilterSensitiveLog)
    .ser(se_ListModelInvocationJobsCommand)
    .de(de_ListModelInvocationJobsCommand)
    .build() {
}

class ListPromptRoutersCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListPromptRouters", {})
    .n("BedrockClient", "ListPromptRoutersCommand")
    .f(void 0, ListPromptRoutersResponseFilterSensitiveLog)
    .ser(se_ListPromptRoutersCommand)
    .de(de_ListPromptRoutersCommand)
    .build() {
}

class ListProvisionedModelThroughputsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListProvisionedModelThroughputs", {})
    .n("BedrockClient", "ListProvisionedModelThroughputsCommand")
    .f(void 0, void 0)
    .ser(se_ListProvisionedModelThroughputsCommand)
    .de(de_ListProvisionedModelThroughputsCommand)
    .build() {
}

class ListTagsForResourceCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListTagsForResource", {})
    .n("BedrockClient", "ListTagsForResourceCommand")
    .f(void 0, void 0)
    .ser(se_ListTagsForResourceCommand)
    .de(de_ListTagsForResourceCommand)
    .build() {
}

class PutModelInvocationLoggingConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "PutModelInvocationLoggingConfiguration", {})
    .n("BedrockClient", "PutModelInvocationLoggingConfigurationCommand")
    .f(void 0, void 0)
    .ser(se_PutModelInvocationLoggingConfigurationCommand)
    .de(de_PutModelInvocationLoggingConfigurationCommand)
    .build() {
}

class PutUseCaseForModelAccessCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "PutUseCaseForModelAccess", {})
    .n("BedrockClient", "PutUseCaseForModelAccessCommand")
    .f(void 0, void 0)
    .ser(se_PutUseCaseForModelAccessCommand)
    .de(de_PutUseCaseForModelAccessCommand)
    .build() {
}

class RegisterMarketplaceModelEndpointCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "RegisterMarketplaceModelEndpoint", {})
    .n("BedrockClient", "RegisterMarketplaceModelEndpointCommand")
    .f(void 0, void 0)
    .ser(se_RegisterMarketplaceModelEndpointCommand)
    .de(de_RegisterMarketplaceModelEndpointCommand)
    .build() {
}

class StartAutomatedReasoningPolicyBuildWorkflowCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "StartAutomatedReasoningPolicyBuildWorkflow", {})
    .n("BedrockClient", "StartAutomatedReasoningPolicyBuildWorkflowCommand")
    .f(StartAutomatedReasoningPolicyBuildWorkflowRequestFilterSensitiveLog, void 0)
    .ser(se_StartAutomatedReasoningPolicyBuildWorkflowCommand)
    .de(de_StartAutomatedReasoningPolicyBuildWorkflowCommand)
    .build() {
}

class StartAutomatedReasoningPolicyTestWorkflowCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "StartAutomatedReasoningPolicyTestWorkflow", {})
    .n("BedrockClient", "StartAutomatedReasoningPolicyTestWorkflowCommand")
    .f(void 0, void 0)
    .ser(se_StartAutomatedReasoningPolicyTestWorkflowCommand)
    .de(de_StartAutomatedReasoningPolicyTestWorkflowCommand)
    .build() {
}

class StopEvaluationJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "StopEvaluationJob", {})
    .n("BedrockClient", "StopEvaluationJobCommand")
    .f(StopEvaluationJobRequestFilterSensitiveLog, void 0)
    .ser(se_StopEvaluationJobCommand)
    .de(de_StopEvaluationJobCommand)
    .build() {
}

class StopModelCustomizationJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "StopModelCustomizationJob", {})
    .n("BedrockClient", "StopModelCustomizationJobCommand")
    .f(void 0, void 0)
    .ser(se_StopModelCustomizationJobCommand)
    .de(de_StopModelCustomizationJobCommand)
    .build() {
}

class StopModelInvocationJobCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "StopModelInvocationJob", {})
    .n("BedrockClient", "StopModelInvocationJobCommand")
    .f(void 0, void 0)
    .ser(se_StopModelInvocationJobCommand)
    .de(de_StopModelInvocationJobCommand)
    .build() {
}

class TagResourceCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "TagResource", {})
    .n("BedrockClient", "TagResourceCommand")
    .f(void 0, void 0)
    .ser(se_TagResourceCommand)
    .de(de_TagResourceCommand)
    .build() {
}

class UntagResourceCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "UntagResource", {})
    .n("BedrockClient", "UntagResourceCommand")
    .f(void 0, void 0)
    .ser(se_UntagResourceCommand)
    .de(de_UntagResourceCommand)
    .build() {
}

class UpdateAutomatedReasoningPolicyAnnotationsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "UpdateAutomatedReasoningPolicyAnnotations", {})
    .n("BedrockClient", "UpdateAutomatedReasoningPolicyAnnotationsCommand")
    .f(UpdateAutomatedReasoningPolicyAnnotationsRequestFilterSensitiveLog, void 0)
    .ser(se_UpdateAutomatedReasoningPolicyAnnotationsCommand)
    .de(de_UpdateAutomatedReasoningPolicyAnnotationsCommand)
    .build() {
}

class UpdateAutomatedReasoningPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "UpdateAutomatedReasoningPolicy", {})
    .n("BedrockClient", "UpdateAutomatedReasoningPolicyCommand")
    .f(UpdateAutomatedReasoningPolicyRequestFilterSensitiveLog, UpdateAutomatedReasoningPolicyResponseFilterSensitiveLog)
    .ser(se_UpdateAutomatedReasoningPolicyCommand)
    .de(de_UpdateAutomatedReasoningPolicyCommand)
    .build() {
}

class UpdateAutomatedReasoningPolicyTestCaseCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "UpdateAutomatedReasoningPolicyTestCase", {})
    .n("BedrockClient", "UpdateAutomatedReasoningPolicyTestCaseCommand")
    .f(UpdateAutomatedReasoningPolicyTestCaseRequestFilterSensitiveLog, void 0)
    .ser(se_UpdateAutomatedReasoningPolicyTestCaseCommand)
    .de(de_UpdateAutomatedReasoningPolicyTestCaseCommand)
    .build() {
}

class UpdateGuardrailCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "UpdateGuardrail", {})
    .n("BedrockClient", "UpdateGuardrailCommand")
    .f(UpdateGuardrailRequestFilterSensitiveLog, void 0)
    .ser(se_UpdateGuardrailCommand)
    .de(de_UpdateGuardrailCommand)
    .build() {
}

class UpdateMarketplaceModelEndpointCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "UpdateMarketplaceModelEndpoint", {})
    .n("BedrockClient", "UpdateMarketplaceModelEndpointCommand")
    .f(void 0, void 0)
    .ser(se_UpdateMarketplaceModelEndpointCommand)
    .de(de_UpdateMarketplaceModelEndpointCommand)
    .build() {
}

class UpdateProvisionedModelThroughputCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        middlewareSerde.getSerdePlugin(config, this.serialize, this.deserialize),
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "UpdateProvisionedModelThroughput", {})
    .n("BedrockClient", "UpdateProvisionedModelThroughputCommand")
    .f(void 0, void 0)
    .ser(se_UpdateProvisionedModelThroughputCommand)
    .de(de_UpdateProvisionedModelThroughputCommand)
    .build() {
}

const commands = {
    BatchDeleteEvaluationJobCommand,
    CancelAutomatedReasoningPolicyBuildWorkflowCommand,
    CreateAutomatedReasoningPolicyCommand,
    CreateAutomatedReasoningPolicyTestCaseCommand,
    CreateAutomatedReasoningPolicyVersionCommand,
    CreateCustomModelCommand,
    CreateCustomModelDeploymentCommand,
    CreateEvaluationJobCommand,
    CreateFoundationModelAgreementCommand,
    CreateGuardrailCommand,
    CreateGuardrailVersionCommand,
    CreateInferenceProfileCommand,
    CreateMarketplaceModelEndpointCommand,
    CreateModelCopyJobCommand,
    CreateModelCustomizationJobCommand,
    CreateModelImportJobCommand,
    CreateModelInvocationJobCommand,
    CreatePromptRouterCommand,
    CreateProvisionedModelThroughputCommand,
    DeleteAutomatedReasoningPolicyCommand,
    DeleteAutomatedReasoningPolicyBuildWorkflowCommand,
    DeleteAutomatedReasoningPolicyTestCaseCommand,
    DeleteCustomModelCommand,
    DeleteCustomModelDeploymentCommand,
    DeleteFoundationModelAgreementCommand,
    DeleteGuardrailCommand,
    DeleteImportedModelCommand,
    DeleteInferenceProfileCommand,
    DeleteMarketplaceModelEndpointCommand,
    DeleteModelInvocationLoggingConfigurationCommand,
    DeletePromptRouterCommand,
    DeleteProvisionedModelThroughputCommand,
    DeregisterMarketplaceModelEndpointCommand,
    ExportAutomatedReasoningPolicyVersionCommand,
    GetAutomatedReasoningPolicyCommand,
    GetAutomatedReasoningPolicyAnnotationsCommand,
    GetAutomatedReasoningPolicyBuildWorkflowCommand,
    GetAutomatedReasoningPolicyBuildWorkflowResultAssetsCommand,
    GetAutomatedReasoningPolicyNextScenarioCommand,
    GetAutomatedReasoningPolicyTestCaseCommand,
    GetAutomatedReasoningPolicyTestResultCommand,
    GetCustomModelCommand,
    GetCustomModelDeploymentCommand,
    GetEvaluationJobCommand,
    GetFoundationModelCommand,
    GetFoundationModelAvailabilityCommand,
    GetGuardrailCommand,
    GetImportedModelCommand,
    GetInferenceProfileCommand,
    GetMarketplaceModelEndpointCommand,
    GetModelCopyJobCommand,
    GetModelCustomizationJobCommand,
    GetModelImportJobCommand,
    GetModelInvocationJobCommand,
    GetModelInvocationLoggingConfigurationCommand,
    GetPromptRouterCommand,
    GetProvisionedModelThroughputCommand,
    GetUseCaseForModelAccessCommand,
    ListAutomatedReasoningPoliciesCommand,
    ListAutomatedReasoningPolicyBuildWorkflowsCommand,
    ListAutomatedReasoningPolicyTestCasesCommand,
    ListAutomatedReasoningPolicyTestResultsCommand,
    ListCustomModelDeploymentsCommand,
    ListCustomModelsCommand,
    ListEvaluationJobsCommand,
    ListFoundationModelAgreementOffersCommand,
    ListFoundationModelsCommand,
    ListGuardrailsCommand,
    ListImportedModelsCommand,
    ListInferenceProfilesCommand,
    ListMarketplaceModelEndpointsCommand,
    ListModelCopyJobsCommand,
    ListModelCustomizationJobsCommand,
    ListModelImportJobsCommand,
    ListModelInvocationJobsCommand,
    ListPromptRoutersCommand,
    ListProvisionedModelThroughputsCommand,
    ListTagsForResourceCommand,
    PutModelInvocationLoggingConfigurationCommand,
    PutUseCaseForModelAccessCommand,
    RegisterMarketplaceModelEndpointCommand,
    StartAutomatedReasoningPolicyBuildWorkflowCommand,
    StartAutomatedReasoningPolicyTestWorkflowCommand,
    StopEvaluationJobCommand,
    StopModelCustomizationJobCommand,
    StopModelInvocationJobCommand,
    TagResourceCommand,
    UntagResourceCommand,
    UpdateAutomatedReasoningPolicyCommand,
    UpdateAutomatedReasoningPolicyAnnotationsCommand,
    UpdateAutomatedReasoningPolicyTestCaseCommand,
    UpdateGuardrailCommand,
    UpdateMarketplaceModelEndpointCommand,
    UpdateProvisionedModelThroughputCommand,
};
class Bedrock extends BedrockClient {
}
smithyClient.createAggregatedClient(commands, Bedrock);

const paginateListAutomatedReasoningPolicies = core.createPaginator(BedrockClient, ListAutomatedReasoningPoliciesCommand, "nextToken", "nextToken", "maxResults");

const paginateListAutomatedReasoningPolicyBuildWorkflows = core.createPaginator(BedrockClient, ListAutomatedReasoningPolicyBuildWorkflowsCommand, "nextToken", "nextToken", "maxResults");

const paginateListAutomatedReasoningPolicyTestCases = core.createPaginator(BedrockClient, ListAutomatedReasoningPolicyTestCasesCommand, "nextToken", "nextToken", "maxResults");

const paginateListAutomatedReasoningPolicyTestResults = core.createPaginator(BedrockClient, ListAutomatedReasoningPolicyTestResultsCommand, "nextToken", "nextToken", "maxResults");

const paginateListCustomModelDeployments = core.createPaginator(BedrockClient, ListCustomModelDeploymentsCommand, "nextToken", "nextToken", "maxResults");

const paginateListCustomModels = core.createPaginator(BedrockClient, ListCustomModelsCommand, "nextToken", "nextToken", "maxResults");

const paginateListEvaluationJobs = core.createPaginator(BedrockClient, ListEvaluationJobsCommand, "nextToken", "nextToken", "maxResults");

const paginateListGuardrails = core.createPaginator(BedrockClient, ListGuardrailsCommand, "nextToken", "nextToken", "maxResults");

const paginateListImportedModels = core.createPaginator(BedrockClient, ListImportedModelsCommand, "nextToken", "nextToken", "maxResults");

const paginateListInferenceProfiles = core.createPaginator(BedrockClient, ListInferenceProfilesCommand, "nextToken", "nextToken", "maxResults");

const paginateListMarketplaceModelEndpoints = core.createPaginator(BedrockClient, ListMarketplaceModelEndpointsCommand, "nextToken", "nextToken", "maxResults");

const paginateListModelCopyJobs = core.createPaginator(BedrockClient, ListModelCopyJobsCommand, "nextToken", "nextToken", "maxResults");

const paginateListModelCustomizationJobs = core.createPaginator(BedrockClient, ListModelCustomizationJobsCommand, "nextToken", "nextToken", "maxResults");

const paginateListModelImportJobs = core.createPaginator(BedrockClient, ListModelImportJobsCommand, "nextToken", "nextToken", "maxResults");

const paginateListModelInvocationJobs = core.createPaginator(BedrockClient, ListModelInvocationJobsCommand, "nextToken", "nextToken", "maxResults");

const paginateListPromptRouters = core.createPaginator(BedrockClient, ListPromptRoutersCommand, "nextToken", "nextToken", "maxResults");

const paginateListProvisionedModelThroughputs = core.createPaginator(BedrockClient, ListProvisionedModelThroughputsCommand, "nextToken", "nextToken", "maxResults");

Object.defineProperty(exports, "$Command", {
    enumerable: true,
    get: function () { return smithyClient.Command; }
});
Object.defineProperty(exports, "__Client", {
    enumerable: true,
    get: function () { return smithyClient.Client; }
});
exports.AccessDeniedException = AccessDeniedException;
exports.AgreementStatus = AgreementStatus;
exports.ApplicationType = ApplicationType;
exports.AttributeType = AttributeType;
exports.AuthorizationStatus = AuthorizationStatus;
exports.AutomatedEvaluationConfigFilterSensitiveLog = AutomatedEvaluationConfigFilterSensitiveLog;
exports.AutomatedEvaluationCustomMetricConfigFilterSensitiveLog = AutomatedEvaluationCustomMetricConfigFilterSensitiveLog;
exports.AutomatedEvaluationCustomMetricSourceFilterSensitiveLog = AutomatedEvaluationCustomMetricSourceFilterSensitiveLog;
exports.AutomatedReasoningCheckFindingFilterSensitiveLog = AutomatedReasoningCheckFindingFilterSensitiveLog;
exports.AutomatedReasoningCheckImpossibleFindingFilterSensitiveLog = AutomatedReasoningCheckImpossibleFindingFilterSensitiveLog;
exports.AutomatedReasoningCheckInputTextReferenceFilterSensitiveLog = AutomatedReasoningCheckInputTextReferenceFilterSensitiveLog;
exports.AutomatedReasoningCheckInvalidFindingFilterSensitiveLog = AutomatedReasoningCheckInvalidFindingFilterSensitiveLog;
exports.AutomatedReasoningCheckLogicWarningFilterSensitiveLog = AutomatedReasoningCheckLogicWarningFilterSensitiveLog;
exports.AutomatedReasoningCheckLogicWarningType = AutomatedReasoningCheckLogicWarningType;
exports.AutomatedReasoningCheckResult = AutomatedReasoningCheckResult;
exports.AutomatedReasoningCheckSatisfiableFindingFilterSensitiveLog = AutomatedReasoningCheckSatisfiableFindingFilterSensitiveLog;
exports.AutomatedReasoningCheckScenarioFilterSensitiveLog = AutomatedReasoningCheckScenarioFilterSensitiveLog;
exports.AutomatedReasoningCheckTranslationAmbiguousFindingFilterSensitiveLog = AutomatedReasoningCheckTranslationAmbiguousFindingFilterSensitiveLog;
exports.AutomatedReasoningCheckTranslationFilterSensitiveLog = AutomatedReasoningCheckTranslationFilterSensitiveLog;
exports.AutomatedReasoningCheckTranslationOptionFilterSensitiveLog = AutomatedReasoningCheckTranslationOptionFilterSensitiveLog;
exports.AutomatedReasoningCheckValidFindingFilterSensitiveLog = AutomatedReasoningCheckValidFindingFilterSensitiveLog;
exports.AutomatedReasoningLogicStatementFilterSensitiveLog = AutomatedReasoningLogicStatementFilterSensitiveLog;
exports.AutomatedReasoningPolicyAddRuleAnnotationFilterSensitiveLog = AutomatedReasoningPolicyAddRuleAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotationFilterSensitiveLog = AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyAddRuleMutationFilterSensitiveLog = AutomatedReasoningPolicyAddRuleMutationFilterSensitiveLog;
exports.AutomatedReasoningPolicyAddTypeAnnotationFilterSensitiveLog = AutomatedReasoningPolicyAddTypeAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyAddTypeMutationFilterSensitiveLog = AutomatedReasoningPolicyAddTypeMutationFilterSensitiveLog;
exports.AutomatedReasoningPolicyAddTypeValueFilterSensitiveLog = AutomatedReasoningPolicyAddTypeValueFilterSensitiveLog;
exports.AutomatedReasoningPolicyAddVariableAnnotationFilterSensitiveLog = AutomatedReasoningPolicyAddVariableAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyAddVariableMutationFilterSensitiveLog = AutomatedReasoningPolicyAddVariableMutationFilterSensitiveLog;
exports.AutomatedReasoningPolicyAnnotationFilterSensitiveLog = AutomatedReasoningPolicyAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyAnnotationStatus = AutomatedReasoningPolicyAnnotationStatus;
exports.AutomatedReasoningPolicyBuildDocumentContentType = AutomatedReasoningPolicyBuildDocumentContentType;
exports.AutomatedReasoningPolicyBuildLogEntryFilterSensitiveLog = AutomatedReasoningPolicyBuildLogEntryFilterSensitiveLog;
exports.AutomatedReasoningPolicyBuildLogFilterSensitiveLog = AutomatedReasoningPolicyBuildLogFilterSensitiveLog;
exports.AutomatedReasoningPolicyBuildMessageType = AutomatedReasoningPolicyBuildMessageType;
exports.AutomatedReasoningPolicyBuildResultAssetType = AutomatedReasoningPolicyBuildResultAssetType;
exports.AutomatedReasoningPolicyBuildResultAssetsFilterSensitiveLog = AutomatedReasoningPolicyBuildResultAssetsFilterSensitiveLog;
exports.AutomatedReasoningPolicyBuildStepContextFilterSensitiveLog = AutomatedReasoningPolicyBuildStepContextFilterSensitiveLog;
exports.AutomatedReasoningPolicyBuildStepFilterSensitiveLog = AutomatedReasoningPolicyBuildStepFilterSensitiveLog;
exports.AutomatedReasoningPolicyBuildWorkflowDocumentFilterSensitiveLog = AutomatedReasoningPolicyBuildWorkflowDocumentFilterSensitiveLog;
exports.AutomatedReasoningPolicyBuildWorkflowRepairContentFilterSensitiveLog = AutomatedReasoningPolicyBuildWorkflowRepairContentFilterSensitiveLog;
exports.AutomatedReasoningPolicyBuildWorkflowSourceFilterSensitiveLog = AutomatedReasoningPolicyBuildWorkflowSourceFilterSensitiveLog;
exports.AutomatedReasoningPolicyBuildWorkflowStatus = AutomatedReasoningPolicyBuildWorkflowStatus;
exports.AutomatedReasoningPolicyBuildWorkflowType = AutomatedReasoningPolicyBuildWorkflowType;
exports.AutomatedReasoningPolicyDefinitionElementFilterSensitiveLog = AutomatedReasoningPolicyDefinitionElementFilterSensitiveLog;
exports.AutomatedReasoningPolicyDefinitionFilterSensitiveLog = AutomatedReasoningPolicyDefinitionFilterSensitiveLog;
exports.AutomatedReasoningPolicyDefinitionQualityReportFilterSensitiveLog = AutomatedReasoningPolicyDefinitionQualityReportFilterSensitiveLog;
exports.AutomatedReasoningPolicyDefinitionRuleFilterSensitiveLog = AutomatedReasoningPolicyDefinitionRuleFilterSensitiveLog;
exports.AutomatedReasoningPolicyDefinitionTypeFilterSensitiveLog = AutomatedReasoningPolicyDefinitionTypeFilterSensitiveLog;
exports.AutomatedReasoningPolicyDefinitionTypeValueFilterSensitiveLog = AutomatedReasoningPolicyDefinitionTypeValueFilterSensitiveLog;
exports.AutomatedReasoningPolicyDefinitionTypeValuePairFilterSensitiveLog = AutomatedReasoningPolicyDefinitionTypeValuePairFilterSensitiveLog;
exports.AutomatedReasoningPolicyDefinitionVariableFilterSensitiveLog = AutomatedReasoningPolicyDefinitionVariableFilterSensitiveLog;
exports.AutomatedReasoningPolicyDeleteTypeAnnotationFilterSensitiveLog = AutomatedReasoningPolicyDeleteTypeAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyDeleteTypeMutationFilterSensitiveLog = AutomatedReasoningPolicyDeleteTypeMutationFilterSensitiveLog;
exports.AutomatedReasoningPolicyDeleteVariableAnnotationFilterSensitiveLog = AutomatedReasoningPolicyDeleteVariableAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyDeleteVariableMutationFilterSensitiveLog = AutomatedReasoningPolicyDeleteVariableMutationFilterSensitiveLog;
exports.AutomatedReasoningPolicyDisjointRuleSetFilterSensitiveLog = AutomatedReasoningPolicyDisjointRuleSetFilterSensitiveLog;
exports.AutomatedReasoningPolicyIngestContentAnnotationFilterSensitiveLog = AutomatedReasoningPolicyIngestContentAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyMutationFilterSensitiveLog = AutomatedReasoningPolicyMutationFilterSensitiveLog;
exports.AutomatedReasoningPolicyScenarioFilterSensitiveLog = AutomatedReasoningPolicyScenarioFilterSensitiveLog;
exports.AutomatedReasoningPolicySummaryFilterSensitiveLog = AutomatedReasoningPolicySummaryFilterSensitiveLog;
exports.AutomatedReasoningPolicyTestCaseFilterSensitiveLog = AutomatedReasoningPolicyTestCaseFilterSensitiveLog;
exports.AutomatedReasoningPolicyTestResultFilterSensitiveLog = AutomatedReasoningPolicyTestResultFilterSensitiveLog;
exports.AutomatedReasoningPolicyTestRunResult = AutomatedReasoningPolicyTestRunResult;
exports.AutomatedReasoningPolicyTestRunStatus = AutomatedReasoningPolicyTestRunStatus;
exports.AutomatedReasoningPolicyTypeValueAnnotationFilterSensitiveLog = AutomatedReasoningPolicyTypeValueAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotationFilterSensitiveLog = AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotationFilterSensitiveLog = AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyUpdateRuleAnnotationFilterSensitiveLog = AutomatedReasoningPolicyUpdateRuleAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyUpdateRuleMutationFilterSensitiveLog = AutomatedReasoningPolicyUpdateRuleMutationFilterSensitiveLog;
exports.AutomatedReasoningPolicyUpdateTypeAnnotationFilterSensitiveLog = AutomatedReasoningPolicyUpdateTypeAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyUpdateTypeMutationFilterSensitiveLog = AutomatedReasoningPolicyUpdateTypeMutationFilterSensitiveLog;
exports.AutomatedReasoningPolicyUpdateTypeValueFilterSensitiveLog = AutomatedReasoningPolicyUpdateTypeValueFilterSensitiveLog;
exports.AutomatedReasoningPolicyUpdateVariableAnnotationFilterSensitiveLog = AutomatedReasoningPolicyUpdateVariableAnnotationFilterSensitiveLog;
exports.AutomatedReasoningPolicyUpdateVariableMutationFilterSensitiveLog = AutomatedReasoningPolicyUpdateVariableMutationFilterSensitiveLog;
exports.AutomatedReasoningPolicyWorkflowTypeContentFilterSensitiveLog = AutomatedReasoningPolicyWorkflowTypeContentFilterSensitiveLog;
exports.BatchDeleteEvaluationJobCommand = BatchDeleteEvaluationJobCommand;
exports.BatchDeleteEvaluationJobErrorFilterSensitiveLog = BatchDeleteEvaluationJobErrorFilterSensitiveLog;
exports.BatchDeleteEvaluationJobItemFilterSensitiveLog = BatchDeleteEvaluationJobItemFilterSensitiveLog;
exports.BatchDeleteEvaluationJobRequestFilterSensitiveLog = BatchDeleteEvaluationJobRequestFilterSensitiveLog;
exports.BatchDeleteEvaluationJobResponseFilterSensitiveLog = BatchDeleteEvaluationJobResponseFilterSensitiveLog;
exports.Bedrock = Bedrock;
exports.BedrockClient = BedrockClient;
exports.BedrockServiceException = BedrockServiceException;
exports.ByteContentDocFilterSensitiveLog = ByteContentDocFilterSensitiveLog;
exports.CancelAutomatedReasoningPolicyBuildWorkflowCommand = CancelAutomatedReasoningPolicyBuildWorkflowCommand;
exports.CommitmentDuration = CommitmentDuration;
exports.ConflictException = ConflictException;
exports.CreateAutomatedReasoningPolicyCommand = CreateAutomatedReasoningPolicyCommand;
exports.CreateAutomatedReasoningPolicyRequestFilterSensitiveLog = CreateAutomatedReasoningPolicyRequestFilterSensitiveLog;
exports.CreateAutomatedReasoningPolicyResponseFilterSensitiveLog = CreateAutomatedReasoningPolicyResponseFilterSensitiveLog;
exports.CreateAutomatedReasoningPolicyTestCaseCommand = CreateAutomatedReasoningPolicyTestCaseCommand;
exports.CreateAutomatedReasoningPolicyTestCaseRequestFilterSensitiveLog = CreateAutomatedReasoningPolicyTestCaseRequestFilterSensitiveLog;
exports.CreateAutomatedReasoningPolicyVersionCommand = CreateAutomatedReasoningPolicyVersionCommand;
exports.CreateAutomatedReasoningPolicyVersionResponseFilterSensitiveLog = CreateAutomatedReasoningPolicyVersionResponseFilterSensitiveLog;
exports.CreateCustomModelCommand = CreateCustomModelCommand;
exports.CreateCustomModelDeploymentCommand = CreateCustomModelDeploymentCommand;
exports.CreateEvaluationJobCommand = CreateEvaluationJobCommand;
exports.CreateEvaluationJobRequestFilterSensitiveLog = CreateEvaluationJobRequestFilterSensitiveLog;
exports.CreateFoundationModelAgreementCommand = CreateFoundationModelAgreementCommand;
exports.CreateGuardrailCommand = CreateGuardrailCommand;
exports.CreateGuardrailRequestFilterSensitiveLog = CreateGuardrailRequestFilterSensitiveLog;
exports.CreateGuardrailVersionCommand = CreateGuardrailVersionCommand;
exports.CreateGuardrailVersionRequestFilterSensitiveLog = CreateGuardrailVersionRequestFilterSensitiveLog;
exports.CreateInferenceProfileCommand = CreateInferenceProfileCommand;
exports.CreateInferenceProfileRequestFilterSensitiveLog = CreateInferenceProfileRequestFilterSensitiveLog;
exports.CreateMarketplaceModelEndpointCommand = CreateMarketplaceModelEndpointCommand;
exports.CreateModelCopyJobCommand = CreateModelCopyJobCommand;
exports.CreateModelCustomizationJobCommand = CreateModelCustomizationJobCommand;
exports.CreateModelCustomizationJobRequestFilterSensitiveLog = CreateModelCustomizationJobRequestFilterSensitiveLog;
exports.CreateModelImportJobCommand = CreateModelImportJobCommand;
exports.CreateModelInvocationJobCommand = CreateModelInvocationJobCommand;
exports.CreatePromptRouterCommand = CreatePromptRouterCommand;
exports.CreatePromptRouterRequestFilterSensitiveLog = CreatePromptRouterRequestFilterSensitiveLog;
exports.CreateProvisionedModelThroughputCommand = CreateProvisionedModelThroughputCommand;
exports.CustomMetricDefinitionFilterSensitiveLog = CustomMetricDefinitionFilterSensitiveLog;
exports.CustomModelDeploymentStatus = CustomModelDeploymentStatus;
exports.CustomizationType = CustomizationType;
exports.DeleteAutomatedReasoningPolicyBuildWorkflowCommand = DeleteAutomatedReasoningPolicyBuildWorkflowCommand;
exports.DeleteAutomatedReasoningPolicyCommand = DeleteAutomatedReasoningPolicyCommand;
exports.DeleteAutomatedReasoningPolicyTestCaseCommand = DeleteAutomatedReasoningPolicyTestCaseCommand;
exports.DeleteCustomModelCommand = DeleteCustomModelCommand;
exports.DeleteCustomModelDeploymentCommand = DeleteCustomModelDeploymentCommand;
exports.DeleteFoundationModelAgreementCommand = DeleteFoundationModelAgreementCommand;
exports.DeleteGuardrailCommand = DeleteGuardrailCommand;
exports.DeleteImportedModelCommand = DeleteImportedModelCommand;
exports.DeleteInferenceProfileCommand = DeleteInferenceProfileCommand;
exports.DeleteMarketplaceModelEndpointCommand = DeleteMarketplaceModelEndpointCommand;
exports.DeleteModelInvocationLoggingConfigurationCommand = DeleteModelInvocationLoggingConfigurationCommand;
exports.DeletePromptRouterCommand = DeletePromptRouterCommand;
exports.DeleteProvisionedModelThroughputCommand = DeleteProvisionedModelThroughputCommand;
exports.DeregisterMarketplaceModelEndpointCommand = DeregisterMarketplaceModelEndpointCommand;
exports.EntitlementAvailability = EntitlementAvailability;
exports.EvaluationBedrockModelFilterSensitiveLog = EvaluationBedrockModelFilterSensitiveLog;
exports.EvaluationConfigFilterSensitiveLog = EvaluationConfigFilterSensitiveLog;
exports.EvaluationDatasetFilterSensitiveLog = EvaluationDatasetFilterSensitiveLog;
exports.EvaluationDatasetMetricConfigFilterSensitiveLog = EvaluationDatasetMetricConfigFilterSensitiveLog;
exports.EvaluationInferenceConfigFilterSensitiveLog = EvaluationInferenceConfigFilterSensitiveLog;
exports.EvaluationJobStatus = EvaluationJobStatus;
exports.EvaluationJobType = EvaluationJobType;
exports.EvaluationModelConfigFilterSensitiveLog = EvaluationModelConfigFilterSensitiveLog;
exports.EvaluationTaskType = EvaluationTaskType;
exports.ExportAutomatedReasoningPolicyVersionCommand = ExportAutomatedReasoningPolicyVersionCommand;
exports.ExportAutomatedReasoningPolicyVersionResponseFilterSensitiveLog = ExportAutomatedReasoningPolicyVersionResponseFilterSensitiveLog;
exports.ExternalSourceFilterSensitiveLog = ExternalSourceFilterSensitiveLog;
exports.ExternalSourceType = ExternalSourceType;
exports.ExternalSourcesGenerationConfigurationFilterSensitiveLog = ExternalSourcesGenerationConfigurationFilterSensitiveLog;
exports.ExternalSourcesRetrieveAndGenerateConfigurationFilterSensitiveLog = ExternalSourcesRetrieveAndGenerateConfigurationFilterSensitiveLog;
exports.FineTuningJobStatus = FineTuningJobStatus;
exports.FoundationModelLifecycleStatus = FoundationModelLifecycleStatus;
exports.GenerationConfigurationFilterSensitiveLog = GenerationConfigurationFilterSensitiveLog;
exports.GetAutomatedReasoningPolicyAnnotationsCommand = GetAutomatedReasoningPolicyAnnotationsCommand;
exports.GetAutomatedReasoningPolicyAnnotationsResponseFilterSensitiveLog = GetAutomatedReasoningPolicyAnnotationsResponseFilterSensitiveLog;
exports.GetAutomatedReasoningPolicyBuildWorkflowCommand = GetAutomatedReasoningPolicyBuildWorkflowCommand;
exports.GetAutomatedReasoningPolicyBuildWorkflowResponseFilterSensitiveLog = GetAutomatedReasoningPolicyBuildWorkflowResponseFilterSensitiveLog;
exports.GetAutomatedReasoningPolicyBuildWorkflowResultAssetsCommand = GetAutomatedReasoningPolicyBuildWorkflowResultAssetsCommand;
exports.GetAutomatedReasoningPolicyBuildWorkflowResultAssetsResponseFilterSensitiveLog = GetAutomatedReasoningPolicyBuildWorkflowResultAssetsResponseFilterSensitiveLog;
exports.GetAutomatedReasoningPolicyCommand = GetAutomatedReasoningPolicyCommand;
exports.GetAutomatedReasoningPolicyNextScenarioCommand = GetAutomatedReasoningPolicyNextScenarioCommand;
exports.GetAutomatedReasoningPolicyNextScenarioResponseFilterSensitiveLog = GetAutomatedReasoningPolicyNextScenarioResponseFilterSensitiveLog;
exports.GetAutomatedReasoningPolicyResponseFilterSensitiveLog = GetAutomatedReasoningPolicyResponseFilterSensitiveLog;
exports.GetAutomatedReasoningPolicyTestCaseCommand = GetAutomatedReasoningPolicyTestCaseCommand;
exports.GetAutomatedReasoningPolicyTestCaseResponseFilterSensitiveLog = GetAutomatedReasoningPolicyTestCaseResponseFilterSensitiveLog;
exports.GetAutomatedReasoningPolicyTestResultCommand = GetAutomatedReasoningPolicyTestResultCommand;
exports.GetAutomatedReasoningPolicyTestResultResponseFilterSensitiveLog = GetAutomatedReasoningPolicyTestResultResponseFilterSensitiveLog;
exports.GetCustomModelCommand = GetCustomModelCommand;
exports.GetCustomModelDeploymentCommand = GetCustomModelDeploymentCommand;
exports.GetCustomModelResponseFilterSensitiveLog = GetCustomModelResponseFilterSensitiveLog;
exports.GetEvaluationJobCommand = GetEvaluationJobCommand;
exports.GetEvaluationJobRequestFilterSensitiveLog = GetEvaluationJobRequestFilterSensitiveLog;
exports.GetEvaluationJobResponseFilterSensitiveLog = GetEvaluationJobResponseFilterSensitiveLog;
exports.GetFoundationModelAvailabilityCommand = GetFoundationModelAvailabilityCommand;
exports.GetFoundationModelCommand = GetFoundationModelCommand;
exports.GetGuardrailCommand = GetGuardrailCommand;
exports.GetGuardrailResponseFilterSensitiveLog = GetGuardrailResponseFilterSensitiveLog;
exports.GetImportedModelCommand = GetImportedModelCommand;
exports.GetInferenceProfileCommand = GetInferenceProfileCommand;
exports.GetInferenceProfileResponseFilterSensitiveLog = GetInferenceProfileResponseFilterSensitiveLog;
exports.GetMarketplaceModelEndpointCommand = GetMarketplaceModelEndpointCommand;
exports.GetModelCopyJobCommand = GetModelCopyJobCommand;
exports.GetModelCustomizationJobCommand = GetModelCustomizationJobCommand;
exports.GetModelCustomizationJobResponseFilterSensitiveLog = GetModelCustomizationJobResponseFilterSensitiveLog;
exports.GetModelImportJobCommand = GetModelImportJobCommand;
exports.GetModelInvocationJobCommand = GetModelInvocationJobCommand;
exports.GetModelInvocationJobResponseFilterSensitiveLog = GetModelInvocationJobResponseFilterSensitiveLog;
exports.GetModelInvocationLoggingConfigurationCommand = GetModelInvocationLoggingConfigurationCommand;
exports.GetPromptRouterCommand = GetPromptRouterCommand;
exports.GetPromptRouterResponseFilterSensitiveLog = GetPromptRouterResponseFilterSensitiveLog;
exports.GetProvisionedModelThroughputCommand = GetProvisionedModelThroughputCommand;
exports.GetUseCaseForModelAccessCommand = GetUseCaseForModelAccessCommand;
exports.GuardrailContentFilterAction = GuardrailContentFilterAction;
exports.GuardrailContentFilterConfigFilterSensitiveLog = GuardrailContentFilterConfigFilterSensitiveLog;
exports.GuardrailContentFilterFilterSensitiveLog = GuardrailContentFilterFilterSensitiveLog;
exports.GuardrailContentFilterType = GuardrailContentFilterType;
exports.GuardrailContentFiltersTierConfigFilterSensitiveLog = GuardrailContentFiltersTierConfigFilterSensitiveLog;
exports.GuardrailContentFiltersTierFilterSensitiveLog = GuardrailContentFiltersTierFilterSensitiveLog;
exports.GuardrailContentFiltersTierName = GuardrailContentFiltersTierName;
exports.GuardrailContentPolicyConfigFilterSensitiveLog = GuardrailContentPolicyConfigFilterSensitiveLog;
exports.GuardrailContentPolicyFilterSensitiveLog = GuardrailContentPolicyFilterSensitiveLog;
exports.GuardrailContextualGroundingAction = GuardrailContextualGroundingAction;
exports.GuardrailContextualGroundingFilterConfigFilterSensitiveLog = GuardrailContextualGroundingFilterConfigFilterSensitiveLog;
exports.GuardrailContextualGroundingFilterFilterSensitiveLog = GuardrailContextualGroundingFilterFilterSensitiveLog;
exports.GuardrailContextualGroundingFilterType = GuardrailContextualGroundingFilterType;
exports.GuardrailContextualGroundingPolicyConfigFilterSensitiveLog = GuardrailContextualGroundingPolicyConfigFilterSensitiveLog;
exports.GuardrailContextualGroundingPolicyFilterSensitiveLog = GuardrailContextualGroundingPolicyFilterSensitiveLog;
exports.GuardrailFilterStrength = GuardrailFilterStrength;
exports.GuardrailManagedWordsConfigFilterSensitiveLog = GuardrailManagedWordsConfigFilterSensitiveLog;
exports.GuardrailManagedWordsFilterSensitiveLog = GuardrailManagedWordsFilterSensitiveLog;
exports.GuardrailManagedWordsType = GuardrailManagedWordsType;
exports.GuardrailModality = GuardrailModality;
exports.GuardrailPiiEntityType = GuardrailPiiEntityType;
exports.GuardrailSensitiveInformationAction = GuardrailSensitiveInformationAction;
exports.GuardrailStatus = GuardrailStatus;
exports.GuardrailSummaryFilterSensitiveLog = GuardrailSummaryFilterSensitiveLog;
exports.GuardrailTopicAction = GuardrailTopicAction;
exports.GuardrailTopicConfigFilterSensitiveLog = GuardrailTopicConfigFilterSensitiveLog;
exports.GuardrailTopicFilterSensitiveLog = GuardrailTopicFilterSensitiveLog;
exports.GuardrailTopicPolicyConfigFilterSensitiveLog = GuardrailTopicPolicyConfigFilterSensitiveLog;
exports.GuardrailTopicPolicyFilterSensitiveLog = GuardrailTopicPolicyFilterSensitiveLog;
exports.GuardrailTopicType = GuardrailTopicType;
exports.GuardrailTopicsTierConfigFilterSensitiveLog = GuardrailTopicsTierConfigFilterSensitiveLog;
exports.GuardrailTopicsTierFilterSensitiveLog = GuardrailTopicsTierFilterSensitiveLog;
exports.GuardrailTopicsTierName = GuardrailTopicsTierName;
exports.GuardrailWordAction = GuardrailWordAction;
exports.GuardrailWordConfigFilterSensitiveLog = GuardrailWordConfigFilterSensitiveLog;
exports.GuardrailWordFilterSensitiveLog = GuardrailWordFilterSensitiveLog;
exports.GuardrailWordPolicyConfigFilterSensitiveLog = GuardrailWordPolicyConfigFilterSensitiveLog;
exports.GuardrailWordPolicyFilterSensitiveLog = GuardrailWordPolicyFilterSensitiveLog;
exports.HumanEvaluationConfigFilterSensitiveLog = HumanEvaluationConfigFilterSensitiveLog;
exports.HumanEvaluationCustomMetricFilterSensitiveLog = HumanEvaluationCustomMetricFilterSensitiveLog;
exports.HumanWorkflowConfigFilterSensitiveLog = HumanWorkflowConfigFilterSensitiveLog;
exports.ImplicitFilterConfigurationFilterSensitiveLog = ImplicitFilterConfigurationFilterSensitiveLog;
exports.InferenceProfileStatus = InferenceProfileStatus;
exports.InferenceProfileSummaryFilterSensitiveLog = InferenceProfileSummaryFilterSensitiveLog;
exports.InferenceProfileType = InferenceProfileType;
exports.InferenceType = InferenceType;
exports.InternalServerException = InternalServerException;
exports.InvocationLogsConfigFilterSensitiveLog = InvocationLogsConfigFilterSensitiveLog;
exports.JobStatusDetails = JobStatusDetails;
exports.KnowledgeBaseConfigFilterSensitiveLog = KnowledgeBaseConfigFilterSensitiveLog;
exports.KnowledgeBaseRetrievalConfigurationFilterSensitiveLog = KnowledgeBaseRetrievalConfigurationFilterSensitiveLog;
exports.KnowledgeBaseRetrieveAndGenerateConfigurationFilterSensitiveLog = KnowledgeBaseRetrieveAndGenerateConfigurationFilterSensitiveLog;
exports.KnowledgeBaseVectorSearchConfigurationFilterSensitiveLog = KnowledgeBaseVectorSearchConfigurationFilterSensitiveLog;
exports.ListAutomatedReasoningPoliciesCommand = ListAutomatedReasoningPoliciesCommand;
exports.ListAutomatedReasoningPoliciesResponseFilterSensitiveLog = ListAutomatedReasoningPoliciesResponseFilterSensitiveLog;
exports.ListAutomatedReasoningPolicyBuildWorkflowsCommand = ListAutomatedReasoningPolicyBuildWorkflowsCommand;
exports.ListAutomatedReasoningPolicyTestCasesCommand = ListAutomatedReasoningPolicyTestCasesCommand;
exports.ListAutomatedReasoningPolicyTestCasesResponseFilterSensitiveLog = ListAutomatedReasoningPolicyTestCasesResponseFilterSensitiveLog;
exports.ListAutomatedReasoningPolicyTestResultsCommand = ListAutomatedReasoningPolicyTestResultsCommand;
exports.ListAutomatedReasoningPolicyTestResultsResponseFilterSensitiveLog = ListAutomatedReasoningPolicyTestResultsResponseFilterSensitiveLog;
exports.ListCustomModelDeploymentsCommand = ListCustomModelDeploymentsCommand;
exports.ListCustomModelsCommand = ListCustomModelsCommand;
exports.ListEvaluationJobsCommand = ListEvaluationJobsCommand;
exports.ListFoundationModelAgreementOffersCommand = ListFoundationModelAgreementOffersCommand;
exports.ListFoundationModelsCommand = ListFoundationModelsCommand;
exports.ListGuardrailsCommand = ListGuardrailsCommand;
exports.ListGuardrailsResponseFilterSensitiveLog = ListGuardrailsResponseFilterSensitiveLog;
exports.ListImportedModelsCommand = ListImportedModelsCommand;
exports.ListInferenceProfilesCommand = ListInferenceProfilesCommand;
exports.ListInferenceProfilesResponseFilterSensitiveLog = ListInferenceProfilesResponseFilterSensitiveLog;
exports.ListMarketplaceModelEndpointsCommand = ListMarketplaceModelEndpointsCommand;
exports.ListModelCopyJobsCommand = ListModelCopyJobsCommand;
exports.ListModelCustomizationJobsCommand = ListModelCustomizationJobsCommand;
exports.ListModelImportJobsCommand = ListModelImportJobsCommand;
exports.ListModelInvocationJobsCommand = ListModelInvocationJobsCommand;
exports.ListModelInvocationJobsResponseFilterSensitiveLog = ListModelInvocationJobsResponseFilterSensitiveLog;
exports.ListPromptRoutersCommand = ListPromptRoutersCommand;
exports.ListPromptRoutersResponseFilterSensitiveLog = ListPromptRoutersResponseFilterSensitiveLog;
exports.ListProvisionedModelThroughputsCommand = ListProvisionedModelThroughputsCommand;
exports.ListTagsForResourceCommand = ListTagsForResourceCommand;
exports.MetadataAttributeSchemaFilterSensitiveLog = MetadataAttributeSchemaFilterSensitiveLog;
exports.MetadataConfigurationForRerankingFilterSensitiveLog = MetadataConfigurationForRerankingFilterSensitiveLog;
exports.ModelCopyJobStatus = ModelCopyJobStatus;
exports.ModelCustomization = ModelCustomization;
exports.ModelCustomizationJobStatus = ModelCustomizationJobStatus;
exports.ModelImportJobStatus = ModelImportJobStatus;
exports.ModelInvocationJobStatus = ModelInvocationJobStatus;
exports.ModelInvocationJobSummaryFilterSensitiveLog = ModelInvocationJobSummaryFilterSensitiveLog;
exports.ModelModality = ModelModality;
exports.ModelStatus = ModelStatus;
exports.OfferType = OfferType;
exports.PerformanceConfigLatency = PerformanceConfigLatency;
exports.PromptRouterStatus = PromptRouterStatus;
exports.PromptRouterSummaryFilterSensitiveLog = PromptRouterSummaryFilterSensitiveLog;
exports.PromptRouterType = PromptRouterType;
exports.PromptTemplateFilterSensitiveLog = PromptTemplateFilterSensitiveLog;
exports.ProvisionedModelStatus = ProvisionedModelStatus;
exports.PutModelInvocationLoggingConfigurationCommand = PutModelInvocationLoggingConfigurationCommand;
exports.PutUseCaseForModelAccessCommand = PutUseCaseForModelAccessCommand;
exports.QueryTransformationType = QueryTransformationType;
exports.RAGConfigFilterSensitiveLog = RAGConfigFilterSensitiveLog;
exports.RegionAvailability = RegionAvailability;
exports.RegisterMarketplaceModelEndpointCommand = RegisterMarketplaceModelEndpointCommand;
exports.RequestMetadataBaseFiltersFilterSensitiveLog = RequestMetadataBaseFiltersFilterSensitiveLog;
exports.RequestMetadataFiltersFilterSensitiveLog = RequestMetadataFiltersFilterSensitiveLog;
exports.RerankingMetadataSelectionMode = RerankingMetadataSelectionMode;
exports.RerankingMetadataSelectiveModeConfigurationFilterSensitiveLog = RerankingMetadataSelectiveModeConfigurationFilterSensitiveLog;
exports.ResourceInUseException = ResourceInUseException;
exports.ResourceNotFoundException = ResourceNotFoundException;
exports.RetrievalFilterFilterSensitiveLog = RetrievalFilterFilterSensitiveLog;
exports.RetrieveAndGenerateConfigurationFilterSensitiveLog = RetrieveAndGenerateConfigurationFilterSensitiveLog;
exports.RetrieveAndGenerateType = RetrieveAndGenerateType;
exports.RetrieveConfigFilterSensitiveLog = RetrieveConfigFilterSensitiveLog;
exports.S3InputFormat = S3InputFormat;
exports.SearchType = SearchType;
exports.ServiceQuotaExceededException = ServiceQuotaExceededException;
exports.ServiceUnavailableException = ServiceUnavailableException;
exports.SortByProvisionedModels = SortByProvisionedModels;
exports.SortJobsBy = SortJobsBy;
exports.SortModelsBy = SortModelsBy;
exports.SortOrder = SortOrder;
exports.StartAutomatedReasoningPolicyBuildWorkflowCommand = StartAutomatedReasoningPolicyBuildWorkflowCommand;
exports.StartAutomatedReasoningPolicyBuildWorkflowRequestFilterSensitiveLog = StartAutomatedReasoningPolicyBuildWorkflowRequestFilterSensitiveLog;
exports.StartAutomatedReasoningPolicyTestWorkflowCommand = StartAutomatedReasoningPolicyTestWorkflowCommand;
exports.Status = Status;
exports.StopEvaluationJobCommand = StopEvaluationJobCommand;
exports.StopEvaluationJobRequestFilterSensitiveLog = StopEvaluationJobRequestFilterSensitiveLog;
exports.StopModelCustomizationJobCommand = StopModelCustomizationJobCommand;
exports.StopModelInvocationJobCommand = StopModelInvocationJobCommand;
exports.TagResourceCommand = TagResourceCommand;
exports.ThrottlingException = ThrottlingException;
exports.TooManyTagsException = TooManyTagsException;
exports.TrainingDataConfigFilterSensitiveLog = TrainingDataConfigFilterSensitiveLog;
exports.UntagResourceCommand = UntagResourceCommand;
exports.UpdateAutomatedReasoningPolicyAnnotationsCommand = UpdateAutomatedReasoningPolicyAnnotationsCommand;
exports.UpdateAutomatedReasoningPolicyAnnotationsRequestFilterSensitiveLog = UpdateAutomatedReasoningPolicyAnnotationsRequestFilterSensitiveLog;
exports.UpdateAutomatedReasoningPolicyCommand = UpdateAutomatedReasoningPolicyCommand;
exports.UpdateAutomatedReasoningPolicyRequestFilterSensitiveLog = UpdateAutomatedReasoningPolicyRequestFilterSensitiveLog;
exports.UpdateAutomatedReasoningPolicyResponseFilterSensitiveLog = UpdateAutomatedReasoningPolicyResponseFilterSensitiveLog;
exports.UpdateAutomatedReasoningPolicyTestCaseCommand = UpdateAutomatedReasoningPolicyTestCaseCommand;
exports.UpdateAutomatedReasoningPolicyTestCaseRequestFilterSensitiveLog = UpdateAutomatedReasoningPolicyTestCaseRequestFilterSensitiveLog;
exports.UpdateGuardrailCommand = UpdateGuardrailCommand;
exports.UpdateGuardrailRequestFilterSensitiveLog = UpdateGuardrailRequestFilterSensitiveLog;
exports.UpdateMarketplaceModelEndpointCommand = UpdateMarketplaceModelEndpointCommand;
exports.UpdateProvisionedModelThroughputCommand = UpdateProvisionedModelThroughputCommand;
exports.ValidationException = ValidationException;
exports.VectorSearchBedrockRerankingConfigurationFilterSensitiveLog = VectorSearchBedrockRerankingConfigurationFilterSensitiveLog;
exports.VectorSearchRerankingConfigurationFilterSensitiveLog = VectorSearchRerankingConfigurationFilterSensitiveLog;
exports.VectorSearchRerankingConfigurationType = VectorSearchRerankingConfigurationType;
exports.paginateListAutomatedReasoningPolicies = paginateListAutomatedReasoningPolicies;
exports.paginateListAutomatedReasoningPolicyBuildWorkflows = paginateListAutomatedReasoningPolicyBuildWorkflows;
exports.paginateListAutomatedReasoningPolicyTestCases = paginateListAutomatedReasoningPolicyTestCases;
exports.paginateListAutomatedReasoningPolicyTestResults = paginateListAutomatedReasoningPolicyTestResults;
exports.paginateListCustomModelDeployments = paginateListCustomModelDeployments;
exports.paginateListCustomModels = paginateListCustomModels;
exports.paginateListEvaluationJobs = paginateListEvaluationJobs;
exports.paginateListGuardrails = paginateListGuardrails;
exports.paginateListImportedModels = paginateListImportedModels;
exports.paginateListInferenceProfiles = paginateListInferenceProfiles;
exports.paginateListMarketplaceModelEndpoints = paginateListMarketplaceModelEndpoints;
exports.paginateListModelCopyJobs = paginateListModelCopyJobs;
exports.paginateListModelCustomizationJobs = paginateListModelCustomizationJobs;
exports.paginateListModelImportJobs = paginateListModelImportJobs;
exports.paginateListModelInvocationJobs = paginateListModelInvocationJobs;
exports.paginateListPromptRouters = paginateListPromptRouters;
exports.paginateListProvisionedModelThroughputs = paginateListProvisionedModelThroughputs;
