import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { BedrockServiceException as __BaseException } from "./BedrockServiceException";
export class AccessDeniedException extends __BaseException {
    name = "AccessDeniedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "AccessDeniedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, AccessDeniedException.prototype);
    }
}
export const AgreementStatus = {
    AVAILABLE: "AVAILABLE",
    ERROR: "ERROR",
    NOT_AVAILABLE: "NOT_AVAILABLE",
    PENDING: "PENDING",
};
export class InternalServerException extends __BaseException {
    name = "InternalServerException";
    $fault = "server";
    constructor(opts) {
        super({
            name: "InternalServerException",
            $fault: "server",
            ...opts,
        });
        Object.setPrototypeOf(this, InternalServerException.prototype);
    }
}
export class ResourceNotFoundException extends __BaseException {
    name = "ResourceNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ResourceNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceNotFoundException.prototype);
    }
}
export class ThrottlingException extends __BaseException {
    name = "ThrottlingException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ThrottlingException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ThrottlingException.prototype);
    }
}
export class ValidationException extends __BaseException {
    name = "ValidationException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ValidationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ValidationException.prototype);
    }
}
export class ConflictException extends __BaseException {
    name = "ConflictException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ConflictException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ConflictException.prototype);
    }
}
export class ServiceQuotaExceededException extends __BaseException {
    name = "ServiceQuotaExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ServiceQuotaExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ServiceQuotaExceededException.prototype);
    }
}
export class TooManyTagsException extends __BaseException {
    name = "TooManyTagsException";
    $fault = "client";
    resourceName;
    constructor(opts) {
        super({
            name: "TooManyTagsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyTagsException.prototype);
        this.resourceName = opts.resourceName;
    }
}
export const AutomatedReasoningCheckResult = {
    IMPOSSIBLE: "IMPOSSIBLE",
    INVALID: "INVALID",
    NO_TRANSLATION: "NO_TRANSLATION",
    SATISFIABLE: "SATISFIABLE",
    TOO_COMPLEX: "TOO_COMPLEX",
    TRANSLATION_AMBIGUOUS: "TRANSLATION_AMBIGUOUS",
    VALID: "VALID",
};
export class ResourceInUseException extends __BaseException {
    name = "ResourceInUseException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ResourceInUseException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceInUseException.prototype);
    }
}
export var AutomatedReasoningPolicyTypeValueAnnotation;
(function (AutomatedReasoningPolicyTypeValueAnnotation) {
    AutomatedReasoningPolicyTypeValueAnnotation.visit = (value, visitor) => {
        if (value.addTypeValue !== undefined)
            return visitor.addTypeValue(value.addTypeValue);
        if (value.updateTypeValue !== undefined)
            return visitor.updateTypeValue(value.updateTypeValue);
        if (value.deleteTypeValue !== undefined)
            return visitor.deleteTypeValue(value.deleteTypeValue);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(AutomatedReasoningPolicyTypeValueAnnotation || (AutomatedReasoningPolicyTypeValueAnnotation = {}));
export var AutomatedReasoningPolicyAnnotation;
(function (AutomatedReasoningPolicyAnnotation) {
    AutomatedReasoningPolicyAnnotation.visit = (value, visitor) => {
        if (value.addType !== undefined)
            return visitor.addType(value.addType);
        if (value.updateType !== undefined)
            return visitor.updateType(value.updateType);
        if (value.deleteType !== undefined)
            return visitor.deleteType(value.deleteType);
        if (value.addVariable !== undefined)
            return visitor.addVariable(value.addVariable);
        if (value.updateVariable !== undefined)
            return visitor.updateVariable(value.updateVariable);
        if (value.deleteVariable !== undefined)
            return visitor.deleteVariable(value.deleteVariable);
        if (value.addRule !== undefined)
            return visitor.addRule(value.addRule);
        if (value.updateRule !== undefined)
            return visitor.updateRule(value.updateRule);
        if (value.deleteRule !== undefined)
            return visitor.deleteRule(value.deleteRule);
        if (value.addRuleFromNaturalLanguage !== undefined)
            return visitor.addRuleFromNaturalLanguage(value.addRuleFromNaturalLanguage);
        if (value.updateFromRulesFeedback !== undefined)
            return visitor.updateFromRulesFeedback(value.updateFromRulesFeedback);
        if (value.updateFromScenarioFeedback !== undefined)
            return visitor.updateFromScenarioFeedback(value.updateFromScenarioFeedback);
        if (value.ingestContent !== undefined)
            return visitor.ingestContent(value.ingestContent);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(AutomatedReasoningPolicyAnnotation || (AutomatedReasoningPolicyAnnotation = {}));
export const AutomatedReasoningPolicyBuildWorkflowType = {
    IMPORT_POLICY: "IMPORT_POLICY",
    INGEST_CONTENT: "INGEST_CONTENT",
    REFINE_POLICY: "REFINE_POLICY",
};
export const AutomatedReasoningPolicyBuildDocumentContentType = {
    PDF: "pdf",
    TEXT: "txt",
};
export const AutomatedReasoningPolicyBuildWorkflowStatus = {
    BUILDING: "BUILDING",
    CANCELLED: "CANCELLED",
    CANCEL_REQUESTED: "CANCEL_REQUESTED",
    COMPLETED: "COMPLETED",
    FAILED: "FAILED",
    PREPROCESSING: "PREPROCESSING",
    SCHEDULED: "SCHEDULED",
    TESTING: "TESTING",
};
export const AutomatedReasoningPolicyBuildResultAssetType = {
    BUILD_LOG: "BUILD_LOG",
    POLICY_DEFINITION: "POLICY_DEFINITION",
    QUALITY_REPORT: "QUALITY_REPORT",
};
export var AutomatedReasoningPolicyMutation;
(function (AutomatedReasoningPolicyMutation) {
    AutomatedReasoningPolicyMutation.visit = (value, visitor) => {
        if (value.addType !== undefined)
            return visitor.addType(value.addType);
        if (value.updateType !== undefined)
            return visitor.updateType(value.updateType);
        if (value.deleteType !== undefined)
            return visitor.deleteType(value.deleteType);
        if (value.addVariable !== undefined)
            return visitor.addVariable(value.addVariable);
        if (value.updateVariable !== undefined)
            return visitor.updateVariable(value.updateVariable);
        if (value.deleteVariable !== undefined)
            return visitor.deleteVariable(value.deleteVariable);
        if (value.addRule !== undefined)
            return visitor.addRule(value.addRule);
        if (value.updateRule !== undefined)
            return visitor.updateRule(value.updateRule);
        if (value.deleteRule !== undefined)
            return visitor.deleteRule(value.deleteRule);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(AutomatedReasoningPolicyMutation || (AutomatedReasoningPolicyMutation = {}));
export var AutomatedReasoningPolicyBuildStepContext;
(function (AutomatedReasoningPolicyBuildStepContext) {
    AutomatedReasoningPolicyBuildStepContext.visit = (value, visitor) => {
        if (value.planning !== undefined)
            return visitor.planning(value.planning);
        if (value.mutation !== undefined)
            return visitor.mutation(value.mutation);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(AutomatedReasoningPolicyBuildStepContext || (AutomatedReasoningPolicyBuildStepContext = {}));
export const AutomatedReasoningPolicyBuildMessageType = {
    ERROR: "ERROR",
    INFO: "INFO",
    WARNING: "WARNING",
};
export var AutomatedReasoningPolicyDefinitionElement;
(function (AutomatedReasoningPolicyDefinitionElement) {
    AutomatedReasoningPolicyDefinitionElement.visit = (value, visitor) => {
        if (value.policyDefinitionVariable !== undefined)
            return visitor.policyDefinitionVariable(value.policyDefinitionVariable);
        if (value.policyDefinitionType !== undefined)
            return visitor.policyDefinitionType(value.policyDefinitionType);
        if (value.policyDefinitionRule !== undefined)
            return visitor.policyDefinitionRule(value.policyDefinitionRule);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(AutomatedReasoningPolicyDefinitionElement || (AutomatedReasoningPolicyDefinitionElement = {}));
export const AutomatedReasoningPolicyAnnotationStatus = {
    APPLIED: "APPLIED",
    FAILED: "FAILED",
};
export var AutomatedReasoningPolicyBuildResultAssets;
(function (AutomatedReasoningPolicyBuildResultAssets) {
    AutomatedReasoningPolicyBuildResultAssets.visit = (value, visitor) => {
        if (value.policyDefinition !== undefined)
            return visitor.policyDefinition(value.policyDefinition);
        if (value.qualityReport !== undefined)
            return visitor.qualityReport(value.qualityReport);
        if (value.buildLog !== undefined)
            return visitor.buildLog(value.buildLog);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(AutomatedReasoningPolicyBuildResultAssets || (AutomatedReasoningPolicyBuildResultAssets = {}));
export const AutomatedReasoningCheckLogicWarningType = {
    ALWAYS_FALSE: "ALWAYS_FALSE",
    ALWAYS_TRUE: "ALWAYS_TRUE",
};
export var AutomatedReasoningCheckFinding;
(function (AutomatedReasoningCheckFinding) {
    AutomatedReasoningCheckFinding.visit = (value, visitor) => {
        if (value.valid !== undefined)
            return visitor.valid(value.valid);
        if (value.invalid !== undefined)
            return visitor.invalid(value.invalid);
        if (value.satisfiable !== undefined)
            return visitor.satisfiable(value.satisfiable);
        if (value.impossible !== undefined)
            return visitor.impossible(value.impossible);
        if (value.translationAmbiguous !== undefined)
            return visitor.translationAmbiguous(value.translationAmbiguous);
        if (value.tooComplex !== undefined)
            return visitor.tooComplex(value.tooComplex);
        if (value.noTranslations !== undefined)
            return visitor.noTranslations(value.noTranslations);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(AutomatedReasoningCheckFinding || (AutomatedReasoningCheckFinding = {}));
export const AutomatedReasoningPolicyTestRunResult = {
    FAILED: "FAILED",
    PASSED: "PASSED",
};
export const AutomatedReasoningPolicyTestRunStatus = {
    COMPLETED: "COMPLETED",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
    NOT_STARTED: "NOT_STARTED",
    SCHEDULED: "SCHEDULED",
};
export var AutomatedReasoningPolicyWorkflowTypeContent;
(function (AutomatedReasoningPolicyWorkflowTypeContent) {
    AutomatedReasoningPolicyWorkflowTypeContent.visit = (value, visitor) => {
        if (value.documents !== undefined)
            return visitor.documents(value.documents);
        if (value.policyRepairAssets !== undefined)
            return visitor.policyRepairAssets(value.policyRepairAssets);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(AutomatedReasoningPolicyWorkflowTypeContent || (AutomatedReasoningPolicyWorkflowTypeContent = {}));
export var EndpointConfig;
(function (EndpointConfig) {
    EndpointConfig.visit = (value, visitor) => {
        if (value.sageMaker !== undefined)
            return visitor.sageMaker(value.sageMaker);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(EndpointConfig || (EndpointConfig = {}));
export const Status = {
    INCOMPATIBLE_ENDPOINT: "INCOMPATIBLE_ENDPOINT",
    REGISTERED: "REGISTERED",
};
export class ServiceUnavailableException extends __BaseException {
    name = "ServiceUnavailableException";
    $fault = "server";
    constructor(opts) {
        super({
            name: "ServiceUnavailableException",
            $fault: "server",
            ...opts,
        });
        Object.setPrototypeOf(this, ServiceUnavailableException.prototype);
    }
}
export const CustomModelDeploymentStatus = {
    ACTIVE: "Active",
    CREATING: "Creating",
    FAILED: "Failed",
};
export const SortModelsBy = {
    CREATION_TIME: "CreationTime",
};
export const SortOrder = {
    ASCENDING: "Ascending",
    DESCENDING: "Descending",
};
export var ModelDataSource;
(function (ModelDataSource) {
    ModelDataSource.visit = (value, visitor) => {
        if (value.s3DataSource !== undefined)
            return visitor.s3DataSource(value.s3DataSource);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(ModelDataSource || (ModelDataSource = {}));
export var CustomizationConfig;
(function (CustomizationConfig) {
    CustomizationConfig.visit = (value, visitor) => {
        if (value.distillationConfig !== undefined)
            return visitor.distillationConfig(value.distillationConfig);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(CustomizationConfig || (CustomizationConfig = {}));
export const CustomizationType = {
    CONTINUED_PRE_TRAINING: "CONTINUED_PRE_TRAINING",
    DISTILLATION: "DISTILLATION",
    FINE_TUNING: "FINE_TUNING",
    IMPORTED: "IMPORTED",
};
export const ModelStatus = {
    ACTIVE: "Active",
    CREATING: "Creating",
    FAILED: "Failed",
};
export var InvocationLogSource;
(function (InvocationLogSource) {
    InvocationLogSource.visit = (value, visitor) => {
        if (value.s3Uri !== undefined)
            return visitor.s3Uri(value.s3Uri);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(InvocationLogSource || (InvocationLogSource = {}));
export var RequestMetadataFilters;
(function (RequestMetadataFilters) {
    RequestMetadataFilters.visit = (value, visitor) => {
        if (value.equals !== undefined)
            return visitor.equals(value.equals);
        if (value.notEquals !== undefined)
            return visitor.notEquals(value.notEquals);
        if (value.andAll !== undefined)
            return visitor.andAll(value.andAll);
        if (value.orAll !== undefined)
            return visitor.orAll(value.orAll);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(RequestMetadataFilters || (RequestMetadataFilters = {}));
export const EvaluationJobStatus = {
    COMPLETED: "Completed",
    DELETING: "Deleting",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    STOPPED: "Stopped",
    STOPPING: "Stopping",
};
export const ApplicationType = {
    MODEL_EVALUATION: "ModelEvaluation",
    RAG_EVALUATION: "RagEvaluation",
};
export var RatingScaleItemValue;
(function (RatingScaleItemValue) {
    RatingScaleItemValue.visit = (value, visitor) => {
        if (value.stringValue !== undefined)
            return visitor.stringValue(value.stringValue);
        if (value.floatValue !== undefined)
            return visitor.floatValue(value.floatValue);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(RatingScaleItemValue || (RatingScaleItemValue = {}));
export var AutomatedEvaluationCustomMetricSource;
(function (AutomatedEvaluationCustomMetricSource) {
    AutomatedEvaluationCustomMetricSource.visit = (value, visitor) => {
        if (value.customMetricDefinition !== undefined)
            return visitor.customMetricDefinition(value.customMetricDefinition);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(AutomatedEvaluationCustomMetricSource || (AutomatedEvaluationCustomMetricSource = {}));
export var EvaluationDatasetLocation;
(function (EvaluationDatasetLocation) {
    EvaluationDatasetLocation.visit = (value, visitor) => {
        if (value.s3Uri !== undefined)
            return visitor.s3Uri(value.s3Uri);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(EvaluationDatasetLocation || (EvaluationDatasetLocation = {}));
export const EvaluationTaskType = {
    CLASSIFICATION: "Classification",
    CUSTOM: "Custom",
    GENERATION: "Generation",
    QUESTION_AND_ANSWER: "QuestionAndAnswer",
    SUMMARIZATION: "Summarization",
};
export var EvaluatorModelConfig;
(function (EvaluatorModelConfig) {
    EvaluatorModelConfig.visit = (value, visitor) => {
        if (value.bedrockEvaluatorModels !== undefined)
            return visitor.bedrockEvaluatorModels(value.bedrockEvaluatorModels);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(EvaluatorModelConfig || (EvaluatorModelConfig = {}));
export var EvaluationConfig;
(function (EvaluationConfig) {
    EvaluationConfig.visit = (value, visitor) => {
        if (value.automated !== undefined)
            return visitor.automated(value.automated);
        if (value.human !== undefined)
            return visitor.human(value.human);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(EvaluationConfig || (EvaluationConfig = {}));
export const PerformanceConfigLatency = {
    OPTIMIZED: "optimized",
    STANDARD: "standard",
};
export var EvaluationModelConfig;
(function (EvaluationModelConfig) {
    EvaluationModelConfig.visit = (value, visitor) => {
        if (value.bedrockModel !== undefined)
            return visitor.bedrockModel(value.bedrockModel);
        if (value.precomputedInferenceSource !== undefined)
            return visitor.precomputedInferenceSource(value.precomputedInferenceSource);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(EvaluationModelConfig || (EvaluationModelConfig = {}));
export const ExternalSourceType = {
    BYTE_CONTENT: "BYTE_CONTENT",
    S3: "S3",
};
export const QueryTransformationType = {
    QUERY_DECOMPOSITION: "QUERY_DECOMPOSITION",
};
export const AttributeType = {
    BOOLEAN: "BOOLEAN",
    NUMBER: "NUMBER",
    STRING: "STRING",
    STRING_LIST: "STRING_LIST",
};
export const SearchType = {
    HYBRID: "HYBRID",
    SEMANTIC: "SEMANTIC",
};
export const RerankingMetadataSelectionMode = {
    ALL: "ALL",
    SELECTIVE: "SELECTIVE",
};
export var RerankingMetadataSelectiveModeConfiguration;
(function (RerankingMetadataSelectiveModeConfiguration) {
    RerankingMetadataSelectiveModeConfiguration.visit = (value, visitor) => {
        if (value.fieldsToInclude !== undefined)
            return visitor.fieldsToInclude(value.fieldsToInclude);
        if (value.fieldsToExclude !== undefined)
            return visitor.fieldsToExclude(value.fieldsToExclude);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(RerankingMetadataSelectiveModeConfiguration || (RerankingMetadataSelectiveModeConfiguration = {}));
export const VectorSearchRerankingConfigurationType = {
    BEDROCK_RERANKING_MODEL: "BEDROCK_RERANKING_MODEL",
};
export const RetrieveAndGenerateType = {
    EXTERNAL_SOURCES: "EXTERNAL_SOURCES",
    KNOWLEDGE_BASE: "KNOWLEDGE_BASE",
};
export var EvaluationPrecomputedRagSourceConfig;
(function (EvaluationPrecomputedRagSourceConfig) {
    EvaluationPrecomputedRagSourceConfig.visit = (value, visitor) => {
        if (value.retrieveSourceConfig !== undefined)
            return visitor.retrieveSourceConfig(value.retrieveSourceConfig);
        if (value.retrieveAndGenerateSourceConfig !== undefined)
            return visitor.retrieveAndGenerateSourceConfig(value.retrieveAndGenerateSourceConfig);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(EvaluationPrecomputedRagSourceConfig || (EvaluationPrecomputedRagSourceConfig = {}));
export const EvaluationJobType = {
    AUTOMATED: "Automated",
    HUMAN: "Human",
};
export const SortJobsBy = {
    CREATION_TIME: "CreationTime",
};
export const GuardrailContentFilterAction = {
    BLOCK: "BLOCK",
    NONE: "NONE",
};
export const GuardrailModality = {
    IMAGE: "IMAGE",
    TEXT: "TEXT",
};
export const GuardrailFilterStrength = {
    HIGH: "HIGH",
    LOW: "LOW",
    MEDIUM: "MEDIUM",
    NONE: "NONE",
};
export const GuardrailContentFilterType = {
    HATE: "HATE",
    INSULTS: "INSULTS",
    MISCONDUCT: "MISCONDUCT",
    PROMPT_ATTACK: "PROMPT_ATTACK",
    SEXUAL: "SEXUAL",
    VIOLENCE: "VIOLENCE",
};
export const GuardrailContentFiltersTierName = {
    CLASSIC: "CLASSIC",
    STANDARD: "STANDARD",
};
export const GuardrailContextualGroundingAction = {
    BLOCK: "BLOCK",
    NONE: "NONE",
};
export const GuardrailContextualGroundingFilterType = {
    GROUNDING: "GROUNDING",
    RELEVANCE: "RELEVANCE",
};
export const GuardrailSensitiveInformationAction = {
    ANONYMIZE: "ANONYMIZE",
    BLOCK: "BLOCK",
    NONE: "NONE",
};
export const GuardrailPiiEntityType = {
    ADDRESS: "ADDRESS",
    AGE: "AGE",
    AWS_ACCESS_KEY: "AWS_ACCESS_KEY",
    AWS_SECRET_KEY: "AWS_SECRET_KEY",
    CA_HEALTH_NUMBER: "CA_HEALTH_NUMBER",
    CA_SOCIAL_INSURANCE_NUMBER: "CA_SOCIAL_INSURANCE_NUMBER",
    CREDIT_DEBIT_CARD_CVV: "CREDIT_DEBIT_CARD_CVV",
    CREDIT_DEBIT_CARD_EXPIRY: "CREDIT_DEBIT_CARD_EXPIRY",
    CREDIT_DEBIT_CARD_NUMBER: "CREDIT_DEBIT_CARD_NUMBER",
    DRIVER_ID: "DRIVER_ID",
    EMAIL: "EMAIL",
    INTERNATIONAL_BANK_ACCOUNT_NUMBER: "INTERNATIONAL_BANK_ACCOUNT_NUMBER",
    IP_ADDRESS: "IP_ADDRESS",
    LICENSE_PLATE: "LICENSE_PLATE",
    MAC_ADDRESS: "MAC_ADDRESS",
    NAME: "NAME",
    PASSWORD: "PASSWORD",
    PHONE: "PHONE",
    PIN: "PIN",
    SWIFT_CODE: "SWIFT_CODE",
    UK_NATIONAL_HEALTH_SERVICE_NUMBER: "UK_NATIONAL_HEALTH_SERVICE_NUMBER",
    UK_NATIONAL_INSURANCE_NUMBER: "UK_NATIONAL_INSURANCE_NUMBER",
    UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER: "UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER",
    URL: "URL",
    USERNAME: "USERNAME",
    US_BANK_ACCOUNT_NUMBER: "US_BANK_ACCOUNT_NUMBER",
    US_BANK_ROUTING_NUMBER: "US_BANK_ROUTING_NUMBER",
    US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER: "US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER",
    US_PASSPORT_NUMBER: "US_PASSPORT_NUMBER",
    US_SOCIAL_SECURITY_NUMBER: "US_SOCIAL_SECURITY_NUMBER",
    VEHICLE_IDENTIFICATION_NUMBER: "VEHICLE_IDENTIFICATION_NUMBER",
};
export const GuardrailTopicsTierName = {
    CLASSIC: "CLASSIC",
    STANDARD: "STANDARD",
};
export const GuardrailTopicAction = {
    BLOCK: "BLOCK",
    NONE: "NONE",
};
export const GuardrailTopicType = {
    DENY: "DENY",
};
export const GuardrailWordAction = {
    BLOCK: "BLOCK",
    NONE: "NONE",
};
export const AutomatedReasoningPolicyDefinitionRuleFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.expression && { expression: SENSITIVE_STRING }),
    ...(obj.alternateExpression && { alternateExpression: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyDefinitionTypeValueFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyDefinitionTypeFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
    ...(obj.values && {
        values: obj.values.map((item) => AutomatedReasoningPolicyDefinitionTypeValueFilterSensitiveLog(item)),
    }),
});
export const AutomatedReasoningPolicyDefinitionVariableFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.type && { type: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyDefinitionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.types && { types: obj.types.map((item) => AutomatedReasoningPolicyDefinitionTypeFilterSensitiveLog(item)) }),
    ...(obj.rules && { rules: obj.rules.map((item) => AutomatedReasoningPolicyDefinitionRuleFilterSensitiveLog(item)) }),
    ...(obj.variables && {
        variables: obj.variables.map((item) => AutomatedReasoningPolicyDefinitionVariableFilterSensitiveLog(item)),
    }),
});
export const CreateAutomatedReasoningPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
    ...(obj.policyDefinition && {
        policyDefinition: AutomatedReasoningPolicyDefinitionFilterSensitiveLog(obj.policyDefinition),
    }),
});
export const CreateAutomatedReasoningPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const CreateAutomatedReasoningPolicyTestCaseRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.guardContent && { guardContent: SENSITIVE_STRING }),
    ...(obj.queryContent && { queryContent: SENSITIVE_STRING }),
});
export const CreateAutomatedReasoningPolicyVersionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const ExportAutomatedReasoningPolicyVersionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.policyDefinition && {
        policyDefinition: AutomatedReasoningPolicyDefinitionFilterSensitiveLog(obj.policyDefinition),
    }),
});
export const GetAutomatedReasoningPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyAddRuleAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.expression && { expression: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.naturalLanguage && { naturalLanguage: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyAddTypeAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
    ...(obj.values && {
        values: obj.values.map((item) => AutomatedReasoningPolicyDefinitionTypeValueFilterSensitiveLog(item)),
    }),
});
export const AutomatedReasoningPolicyAddVariableAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.type && { type: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyDeleteTypeAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyDeleteVariableAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyIngestContentAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.content && { content: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.feedback && { feedback: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.scenarioExpression && { scenarioExpression: SENSITIVE_STRING }),
    ...(obj.feedback && { feedback: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyUpdateRuleAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.expression && { expression: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyAddTypeValueFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyUpdateTypeValueFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyTypeValueAnnotationFilterSensitiveLog = (obj) => {
    if (obj.addTypeValue !== undefined)
        return { addTypeValue: AutomatedReasoningPolicyAddTypeValueFilterSensitiveLog(obj.addTypeValue) };
    if (obj.updateTypeValue !== undefined)
        return { updateTypeValue: AutomatedReasoningPolicyUpdateTypeValueFilterSensitiveLog(obj.updateTypeValue) };
    if (obj.deleteTypeValue !== undefined)
        return { deleteTypeValue: obj.deleteTypeValue };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const AutomatedReasoningPolicyUpdateTypeAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.newName && { newName: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
    ...(obj.values && {
        values: obj.values.map((item) => AutomatedReasoningPolicyTypeValueAnnotationFilterSensitiveLog(item)),
    }),
});
export const AutomatedReasoningPolicyUpdateVariableAnnotationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.newName && { newName: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyAnnotationFilterSensitiveLog = (obj) => {
    if (obj.addType !== undefined)
        return { addType: AutomatedReasoningPolicyAddTypeAnnotationFilterSensitiveLog(obj.addType) };
    if (obj.updateType !== undefined)
        return { updateType: AutomatedReasoningPolicyUpdateTypeAnnotationFilterSensitiveLog(obj.updateType) };
    if (obj.deleteType !== undefined)
        return { deleteType: AutomatedReasoningPolicyDeleteTypeAnnotationFilterSensitiveLog(obj.deleteType) };
    if (obj.addVariable !== undefined)
        return { addVariable: AutomatedReasoningPolicyAddVariableAnnotationFilterSensitiveLog(obj.addVariable) };
    if (obj.updateVariable !== undefined)
        return { updateVariable: AutomatedReasoningPolicyUpdateVariableAnnotationFilterSensitiveLog(obj.updateVariable) };
    if (obj.deleteVariable !== undefined)
        return { deleteVariable: AutomatedReasoningPolicyDeleteVariableAnnotationFilterSensitiveLog(obj.deleteVariable) };
    if (obj.addRule !== undefined)
        return { addRule: AutomatedReasoningPolicyAddRuleAnnotationFilterSensitiveLog(obj.addRule) };
    if (obj.updateRule !== undefined)
        return { updateRule: AutomatedReasoningPolicyUpdateRuleAnnotationFilterSensitiveLog(obj.updateRule) };
    if (obj.deleteRule !== undefined)
        return { deleteRule: obj.deleteRule };
    if (obj.addRuleFromNaturalLanguage !== undefined)
        return {
            addRuleFromNaturalLanguage: AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotationFilterSensitiveLog(obj.addRuleFromNaturalLanguage),
        };
    if (obj.updateFromRulesFeedback !== undefined)
        return {
            updateFromRulesFeedback: AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotationFilterSensitiveLog(obj.updateFromRulesFeedback),
        };
    if (obj.updateFromScenarioFeedback !== undefined)
        return {
            updateFromScenarioFeedback: AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotationFilterSensitiveLog(obj.updateFromScenarioFeedback),
        };
    if (obj.ingestContent !== undefined)
        return { ingestContent: AutomatedReasoningPolicyIngestContentAnnotationFilterSensitiveLog(obj.ingestContent) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const GetAutomatedReasoningPolicyAnnotationsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.annotations && {
        annotations: obj.annotations.map((item) => AutomatedReasoningPolicyAnnotationFilterSensitiveLog(item)),
    }),
});
export const GetAutomatedReasoningPolicyBuildWorkflowResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.documentName && { documentName: SENSITIVE_STRING }),
    ...(obj.documentDescription && { documentDescription: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyAddRuleMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.rule && { rule: AutomatedReasoningPolicyDefinitionRuleFilterSensitiveLog(obj.rule) }),
});
export const AutomatedReasoningPolicyAddTypeMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.type && { type: AutomatedReasoningPolicyDefinitionTypeFilterSensitiveLog(obj.type) }),
});
export const AutomatedReasoningPolicyAddVariableMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.variable && { variable: AutomatedReasoningPolicyDefinitionVariableFilterSensitiveLog(obj.variable) }),
});
export const AutomatedReasoningPolicyDeleteTypeMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyDeleteVariableMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyUpdateRuleMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.rule && { rule: AutomatedReasoningPolicyDefinitionRuleFilterSensitiveLog(obj.rule) }),
});
export const AutomatedReasoningPolicyUpdateTypeMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.type && { type: AutomatedReasoningPolicyDefinitionTypeFilterSensitiveLog(obj.type) }),
});
export const AutomatedReasoningPolicyUpdateVariableMutationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.variable && { variable: AutomatedReasoningPolicyDefinitionVariableFilterSensitiveLog(obj.variable) }),
});
export const AutomatedReasoningPolicyMutationFilterSensitiveLog = (obj) => {
    if (obj.addType !== undefined)
        return { addType: AutomatedReasoningPolicyAddTypeMutationFilterSensitiveLog(obj.addType) };
    if (obj.updateType !== undefined)
        return { updateType: AutomatedReasoningPolicyUpdateTypeMutationFilterSensitiveLog(obj.updateType) };
    if (obj.deleteType !== undefined)
        return { deleteType: AutomatedReasoningPolicyDeleteTypeMutationFilterSensitiveLog(obj.deleteType) };
    if (obj.addVariable !== undefined)
        return { addVariable: AutomatedReasoningPolicyAddVariableMutationFilterSensitiveLog(obj.addVariable) };
    if (obj.updateVariable !== undefined)
        return { updateVariable: AutomatedReasoningPolicyUpdateVariableMutationFilterSensitiveLog(obj.updateVariable) };
    if (obj.deleteVariable !== undefined)
        return { deleteVariable: AutomatedReasoningPolicyDeleteVariableMutationFilterSensitiveLog(obj.deleteVariable) };
    if (obj.addRule !== undefined)
        return { addRule: AutomatedReasoningPolicyAddRuleMutationFilterSensitiveLog(obj.addRule) };
    if (obj.updateRule !== undefined)
        return { updateRule: AutomatedReasoningPolicyUpdateRuleMutationFilterSensitiveLog(obj.updateRule) };
    if (obj.deleteRule !== undefined)
        return { deleteRule: obj.deleteRule };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const AutomatedReasoningPolicyBuildStepContextFilterSensitiveLog = (obj) => {
    if (obj.planning !== undefined)
        return { planning: obj.planning };
    if (obj.mutation !== undefined)
        return { mutation: AutomatedReasoningPolicyMutationFilterSensitiveLog(obj.mutation) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const AutomatedReasoningPolicyDefinitionElementFilterSensitiveLog = (obj) => {
    if (obj.policyDefinitionVariable !== undefined)
        return {
            policyDefinitionVariable: AutomatedReasoningPolicyDefinitionVariableFilterSensitiveLog(obj.policyDefinitionVariable),
        };
    if (obj.policyDefinitionType !== undefined)
        return { policyDefinitionType: AutomatedReasoningPolicyDefinitionTypeFilterSensitiveLog(obj.policyDefinitionType) };
    if (obj.policyDefinitionRule !== undefined)
        return { policyDefinitionRule: AutomatedReasoningPolicyDefinitionRuleFilterSensitiveLog(obj.policyDefinitionRule) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const AutomatedReasoningPolicyBuildStepFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.context && { context: AutomatedReasoningPolicyBuildStepContextFilterSensitiveLog(obj.context) }),
    ...(obj.priorElement && {
        priorElement: AutomatedReasoningPolicyDefinitionElementFilterSensitiveLog(obj.priorElement),
    }),
});
export const AutomatedReasoningPolicyBuildLogEntryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.annotation && { annotation: AutomatedReasoningPolicyAnnotationFilterSensitiveLog(obj.annotation) }),
    ...(obj.buildSteps && {
        buildSteps: obj.buildSteps.map((item) => AutomatedReasoningPolicyBuildStepFilterSensitiveLog(item)),
    }),
});
export const AutomatedReasoningPolicyBuildLogFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.entries && {
        entries: obj.entries.map((item) => AutomatedReasoningPolicyBuildLogEntryFilterSensitiveLog(item)),
    }),
});
export const AutomatedReasoningPolicyDisjointRuleSetFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.variables && { variables: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyDefinitionTypeValuePairFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.typeName && { typeName: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyDefinitionQualityReportFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.unusedTypes && { unusedTypes: SENSITIVE_STRING }),
    ...(obj.unusedTypeValues && {
        unusedTypeValues: obj.unusedTypeValues.map((item) => AutomatedReasoningPolicyDefinitionTypeValuePairFilterSensitiveLog(item)),
    }),
    ...(obj.unusedVariables && { unusedVariables: SENSITIVE_STRING }),
    ...(obj.disjointRuleSets && {
        disjointRuleSets: obj.disjointRuleSets.map((item) => AutomatedReasoningPolicyDisjointRuleSetFilterSensitiveLog(item)),
    }),
});
export const AutomatedReasoningPolicyBuildResultAssetsFilterSensitiveLog = (obj) => {
    if (obj.policyDefinition !== undefined)
        return { policyDefinition: AutomatedReasoningPolicyDefinitionFilterSensitiveLog(obj.policyDefinition) };
    if (obj.qualityReport !== undefined)
        return { qualityReport: AutomatedReasoningPolicyDefinitionQualityReportFilterSensitiveLog(obj.qualityReport) };
    if (obj.buildLog !== undefined)
        return { buildLog: AutomatedReasoningPolicyBuildLogFilterSensitiveLog(obj.buildLog) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const GetAutomatedReasoningPolicyBuildWorkflowResultAssetsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.buildWorkflowAssets && {
        buildWorkflowAssets: AutomatedReasoningPolicyBuildResultAssetsFilterSensitiveLog(obj.buildWorkflowAssets),
    }),
});
export const AutomatedReasoningPolicyScenarioFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.expression && { expression: SENSITIVE_STRING }),
    ...(obj.alternateExpression && { alternateExpression: SENSITIVE_STRING }),
});
export const GetAutomatedReasoningPolicyNextScenarioResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.scenario && { scenario: AutomatedReasoningPolicyScenarioFilterSensitiveLog(obj.scenario) }),
});
export const AutomatedReasoningPolicyTestCaseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.guardContent && { guardContent: SENSITIVE_STRING }),
    ...(obj.queryContent && { queryContent: SENSITIVE_STRING }),
});
export const GetAutomatedReasoningPolicyTestCaseResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.testCase && { testCase: AutomatedReasoningPolicyTestCaseFilterSensitiveLog(obj.testCase) }),
});
export const AutomatedReasoningLogicStatementFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.logic && { logic: SENSITIVE_STRING }),
    ...(obj.naturalLanguage && { naturalLanguage: SENSITIVE_STRING }),
});
export const AutomatedReasoningCheckLogicWarningFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.premises && {
        premises: obj.premises.map((item) => AutomatedReasoningLogicStatementFilterSensitiveLog(item)),
    }),
    ...(obj.claims && { claims: obj.claims.map((item) => AutomatedReasoningLogicStatementFilterSensitiveLog(item)) }),
});
export const AutomatedReasoningCheckInputTextReferenceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.text && { text: SENSITIVE_STRING }),
});
export const AutomatedReasoningCheckTranslationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.premises && {
        premises: obj.premises.map((item) => AutomatedReasoningLogicStatementFilterSensitiveLog(item)),
    }),
    ...(obj.claims && { claims: obj.claims.map((item) => AutomatedReasoningLogicStatementFilterSensitiveLog(item)) }),
    ...(obj.untranslatedPremises && {
        untranslatedPremises: obj.untranslatedPremises.map((item) => AutomatedReasoningCheckInputTextReferenceFilterSensitiveLog(item)),
    }),
    ...(obj.untranslatedClaims && {
        untranslatedClaims: obj.untranslatedClaims.map((item) => AutomatedReasoningCheckInputTextReferenceFilterSensitiveLog(item)),
    }),
});
export const AutomatedReasoningCheckImpossibleFindingFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.translation && { translation: AutomatedReasoningCheckTranslationFilterSensitiveLog(obj.translation) }),
    ...(obj.logicWarning && { logicWarning: AutomatedReasoningCheckLogicWarningFilterSensitiveLog(obj.logicWarning) }),
});
export const AutomatedReasoningCheckInvalidFindingFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.translation && { translation: AutomatedReasoningCheckTranslationFilterSensitiveLog(obj.translation) }),
    ...(obj.logicWarning && { logicWarning: AutomatedReasoningCheckLogicWarningFilterSensitiveLog(obj.logicWarning) }),
});
export const AutomatedReasoningCheckScenarioFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.statements && {
        statements: obj.statements.map((item) => AutomatedReasoningLogicStatementFilterSensitiveLog(item)),
    }),
});
export const AutomatedReasoningCheckSatisfiableFindingFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.translation && { translation: AutomatedReasoningCheckTranslationFilterSensitiveLog(obj.translation) }),
    ...(obj.claimsTrueScenario && {
        claimsTrueScenario: AutomatedReasoningCheckScenarioFilterSensitiveLog(obj.claimsTrueScenario),
    }),
    ...(obj.claimsFalseScenario && {
        claimsFalseScenario: AutomatedReasoningCheckScenarioFilterSensitiveLog(obj.claimsFalseScenario),
    }),
    ...(obj.logicWarning && { logicWarning: AutomatedReasoningCheckLogicWarningFilterSensitiveLog(obj.logicWarning) }),
});
export const AutomatedReasoningCheckTranslationOptionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AutomatedReasoningCheckTranslationAmbiguousFindingFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AutomatedReasoningCheckValidFindingFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.translation && { translation: AutomatedReasoningCheckTranslationFilterSensitiveLog(obj.translation) }),
    ...(obj.claimsTrueScenario && {
        claimsTrueScenario: AutomatedReasoningCheckScenarioFilterSensitiveLog(obj.claimsTrueScenario),
    }),
    ...(obj.logicWarning && { logicWarning: AutomatedReasoningCheckLogicWarningFilterSensitiveLog(obj.logicWarning) }),
});
export const AutomatedReasoningCheckFindingFilterSensitiveLog = (obj) => {
    if (obj.valid !== undefined)
        return { valid: AutomatedReasoningCheckValidFindingFilterSensitiveLog(obj.valid) };
    if (obj.invalid !== undefined)
        return { invalid: AutomatedReasoningCheckInvalidFindingFilterSensitiveLog(obj.invalid) };
    if (obj.satisfiable !== undefined)
        return { satisfiable: AutomatedReasoningCheckSatisfiableFindingFilterSensitiveLog(obj.satisfiable) };
    if (obj.impossible !== undefined)
        return { impossible: AutomatedReasoningCheckImpossibleFindingFilterSensitiveLog(obj.impossible) };
    if (obj.translationAmbiguous !== undefined)
        return {
            translationAmbiguous: AutomatedReasoningCheckTranslationAmbiguousFindingFilterSensitiveLog(obj.translationAmbiguous),
        };
    if (obj.tooComplex !== undefined)
        return { tooComplex: obj.tooComplex };
    if (obj.noTranslations !== undefined)
        return { noTranslations: obj.noTranslations };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const AutomatedReasoningPolicyTestResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.testCase && { testCase: AutomatedReasoningPolicyTestCaseFilterSensitiveLog(obj.testCase) }),
    ...(obj.testFindings && {
        testFindings: obj.testFindings.map((item) => AutomatedReasoningCheckFindingFilterSensitiveLog(item)),
    }),
});
export const GetAutomatedReasoningPolicyTestResultResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.testResult && { testResult: AutomatedReasoningPolicyTestResultFilterSensitiveLog(obj.testResult) }),
});
export const AutomatedReasoningPolicySummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const ListAutomatedReasoningPoliciesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.automatedReasoningPolicySummaries && {
        automatedReasoningPolicySummaries: obj.automatedReasoningPolicySummaries.map((item) => AutomatedReasoningPolicySummaryFilterSensitiveLog(item)),
    }),
});
export const ListAutomatedReasoningPolicyTestCasesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.testCases && {
        testCases: obj.testCases.map((item) => AutomatedReasoningPolicyTestCaseFilterSensitiveLog(item)),
    }),
});
export const ListAutomatedReasoningPolicyTestResultsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.testResults && {
        testResults: obj.testResults.map((item) => AutomatedReasoningPolicyTestResultFilterSensitiveLog(item)),
    }),
});
export const AutomatedReasoningPolicyBuildWorkflowDocumentFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.document && { document: SENSITIVE_STRING }),
    ...(obj.documentName && { documentName: SENSITIVE_STRING }),
    ...(obj.documentDescription && { documentDescription: SENSITIVE_STRING }),
});
export const AutomatedReasoningPolicyBuildWorkflowRepairContentFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.annotations && {
        annotations: obj.annotations.map((item) => AutomatedReasoningPolicyAnnotationFilterSensitiveLog(item)),
    }),
});
export const AutomatedReasoningPolicyWorkflowTypeContentFilterSensitiveLog = (obj) => {
    if (obj.documents !== undefined)
        return {
            documents: obj.documents.map((item) => AutomatedReasoningPolicyBuildWorkflowDocumentFilterSensitiveLog(item)),
        };
    if (obj.policyRepairAssets !== undefined)
        return {
            policyRepairAssets: AutomatedReasoningPolicyBuildWorkflowRepairContentFilterSensitiveLog(obj.policyRepairAssets),
        };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const AutomatedReasoningPolicyBuildWorkflowSourceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.policyDefinition && {
        policyDefinition: AutomatedReasoningPolicyDefinitionFilterSensitiveLog(obj.policyDefinition),
    }),
    ...(obj.workflowContent && {
        workflowContent: AutomatedReasoningPolicyWorkflowTypeContentFilterSensitiveLog(obj.workflowContent),
    }),
});
export const StartAutomatedReasoningPolicyBuildWorkflowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.sourceContent && {
        sourceContent: AutomatedReasoningPolicyBuildWorkflowSourceFilterSensitiveLog(obj.sourceContent),
    }),
});
export const UpdateAutomatedReasoningPolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.policyDefinition && {
        policyDefinition: AutomatedReasoningPolicyDefinitionFilterSensitiveLog(obj.policyDefinition),
    }),
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const UpdateAutomatedReasoningPolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
});
export const UpdateAutomatedReasoningPolicyAnnotationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.annotations && {
        annotations: obj.annotations.map((item) => AutomatedReasoningPolicyAnnotationFilterSensitiveLog(item)),
    }),
});
export const UpdateAutomatedReasoningPolicyTestCaseRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.guardContent && { guardContent: SENSITIVE_STRING }),
    ...(obj.queryContent && { queryContent: SENSITIVE_STRING }),
});
export const RequestMetadataBaseFiltersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.equals && { equals: SENSITIVE_STRING }),
    ...(obj.notEquals && { notEquals: SENSITIVE_STRING }),
});
export const RequestMetadataFiltersFilterSensitiveLog = (obj) => {
    if (obj.equals !== undefined)
        return { equals: SENSITIVE_STRING };
    if (obj.notEquals !== undefined)
        return { notEquals: SENSITIVE_STRING };
    if (obj.andAll !== undefined)
        return { andAll: obj.andAll.map((item) => RequestMetadataBaseFiltersFilterSensitiveLog(item)) };
    if (obj.orAll !== undefined)
        return { orAll: obj.orAll.map((item) => RequestMetadataBaseFiltersFilterSensitiveLog(item)) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const InvocationLogsConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.invocationLogSource && { invocationLogSource: obj.invocationLogSource }),
    ...(obj.requestMetadataFilters && {
        requestMetadataFilters: RequestMetadataFiltersFilterSensitiveLog(obj.requestMetadataFilters),
    }),
});
export const TrainingDataConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.invocationLogsConfig && {
        invocationLogsConfig: InvocationLogsConfigFilterSensitiveLog(obj.invocationLogsConfig),
    }),
});
export const GetCustomModelResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.trainingDataConfig && { trainingDataConfig: TrainingDataConfigFilterSensitiveLog(obj.trainingDataConfig) }),
    ...(obj.customizationConfig && { customizationConfig: obj.customizationConfig }),
});
export const BatchDeleteEvaluationJobRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobIdentifiers && { jobIdentifiers: SENSITIVE_STRING }),
});
export const BatchDeleteEvaluationJobErrorFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobIdentifier && { jobIdentifier: SENSITIVE_STRING }),
});
export const BatchDeleteEvaluationJobItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobIdentifier && { jobIdentifier: SENSITIVE_STRING }),
});
export const BatchDeleteEvaluationJobResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.errors && { errors: obj.errors.map((item) => BatchDeleteEvaluationJobErrorFilterSensitiveLog(item)) }),
    ...(obj.evaluationJobs && {
        evaluationJobs: obj.evaluationJobs.map((item) => BatchDeleteEvaluationJobItemFilterSensitiveLog(item)),
    }),
});
export const CustomMetricDefinitionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.ratingScale && { ratingScale: obj.ratingScale.map((item) => item) }),
});
export const AutomatedEvaluationCustomMetricSourceFilterSensitiveLog = (obj) => {
    if (obj.customMetricDefinition !== undefined)
        return { customMetricDefinition: SENSITIVE_STRING };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const AutomatedEvaluationCustomMetricConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.customMetrics && {
        customMetrics: obj.customMetrics.map((item) => AutomatedEvaluationCustomMetricSourceFilterSensitiveLog(item)),
    }),
});
export const EvaluationDatasetFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.datasetLocation && { datasetLocation: obj.datasetLocation }),
});
export const EvaluationDatasetMetricConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.dataset && { dataset: EvaluationDatasetFilterSensitiveLog(obj.dataset) }),
    ...(obj.metricNames && { metricNames: SENSITIVE_STRING }),
});
export const AutomatedEvaluationConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.datasetMetricConfigs && {
        datasetMetricConfigs: obj.datasetMetricConfigs.map((item) => EvaluationDatasetMetricConfigFilterSensitiveLog(item)),
    }),
    ...(obj.evaluatorModelConfig && { evaluatorModelConfig: obj.evaluatorModelConfig }),
    ...(obj.customMetricConfig && {
        customMetricConfig: AutomatedEvaluationCustomMetricConfigFilterSensitiveLog(obj.customMetricConfig),
    }),
});
export const HumanEvaluationCustomMetricFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const HumanWorkflowConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.instructions && { instructions: SENSITIVE_STRING }),
});
export const HumanEvaluationConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.humanWorkflowConfig && {
        humanWorkflowConfig: HumanWorkflowConfigFilterSensitiveLog(obj.humanWorkflowConfig),
    }),
    ...(obj.customMetrics && {
        customMetrics: obj.customMetrics.map((item) => HumanEvaluationCustomMetricFilterSensitiveLog(item)),
    }),
    ...(obj.datasetMetricConfigs && {
        datasetMetricConfigs: obj.datasetMetricConfigs.map((item) => EvaluationDatasetMetricConfigFilterSensitiveLog(item)),
    }),
});
export const EvaluationConfigFilterSensitiveLog = (obj) => {
    if (obj.automated !== undefined)
        return { automated: AutomatedEvaluationConfigFilterSensitiveLog(obj.automated) };
    if (obj.human !== undefined)
        return { human: HumanEvaluationConfigFilterSensitiveLog(obj.human) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const EvaluationBedrockModelFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inferenceParams && { inferenceParams: SENSITIVE_STRING }),
});
export const EvaluationModelConfigFilterSensitiveLog = (obj) => {
    if (obj.bedrockModel !== undefined)
        return { bedrockModel: EvaluationBedrockModelFilterSensitiveLog(obj.bedrockModel) };
    if (obj.precomputedInferenceSource !== undefined)
        return { precomputedInferenceSource: obj.precomputedInferenceSource };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const PromptTemplateFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.textPromptTemplate && { textPromptTemplate: SENSITIVE_STRING }),
});
export const ExternalSourcesGenerationConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.promptTemplate && { promptTemplate: PromptTemplateFilterSensitiveLog(obj.promptTemplate) }),
});
export const ByteContentDocFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.identifier && { identifier: SENSITIVE_STRING }),
    ...(obj.data && { data: SENSITIVE_STRING }),
});
export const ExternalSourceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.byteContent && { byteContent: ByteContentDocFilterSensitiveLog(obj.byteContent) }),
});
export const ExternalSourcesRetrieveAndGenerateConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.sources && { sources: obj.sources.map((item) => ExternalSourceFilterSensitiveLog(item)) }),
    ...(obj.generationConfiguration && {
        generationConfiguration: ExternalSourcesGenerationConfigurationFilterSensitiveLog(obj.generationConfiguration),
    }),
});
export const GenerationConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.promptTemplate && { promptTemplate: PromptTemplateFilterSensitiveLog(obj.promptTemplate) }),
});
export const MetadataAttributeSchemaFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ImplicitFilterConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.metadataAttributes && { metadataAttributes: SENSITIVE_STRING }),
});
export const RerankingMetadataSelectiveModeConfigurationFilterSensitiveLog = (obj) => {
    if (obj.fieldsToInclude !== undefined)
        return { fieldsToInclude: SENSITIVE_STRING };
    if (obj.fieldsToExclude !== undefined)
        return { fieldsToExclude: SENSITIVE_STRING };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const MetadataConfigurationForRerankingFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.selectiveModeConfiguration && {
        selectiveModeConfiguration: RerankingMetadataSelectiveModeConfigurationFilterSensitiveLog(obj.selectiveModeConfiguration),
    }),
});
export const VectorSearchBedrockRerankingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.metadataConfiguration && {
        metadataConfiguration: MetadataConfigurationForRerankingFilterSensitiveLog(obj.metadataConfiguration),
    }),
});
export const VectorSearchRerankingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.bedrockRerankingConfiguration && {
        bedrockRerankingConfiguration: VectorSearchBedrockRerankingConfigurationFilterSensitiveLog(obj.bedrockRerankingConfiguration),
    }),
});
export const GetEvaluationJobRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobIdentifier && { jobIdentifier: SENSITIVE_STRING }),
});
export const StopEvaluationJobRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobIdentifier && { jobIdentifier: SENSITIVE_STRING }),
});
export const GuardrailContentFilterConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inputModalities && { inputModalities: SENSITIVE_STRING }),
    ...(obj.outputModalities && { outputModalities: SENSITIVE_STRING }),
    ...(obj.inputAction && { inputAction: SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: SENSITIVE_STRING }),
});
export const GuardrailContentFiltersTierConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.tierName && { tierName: SENSITIVE_STRING }),
});
export const GuardrailContentPolicyConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.filtersConfig && {
        filtersConfig: obj.filtersConfig.map((item) => GuardrailContentFilterConfigFilterSensitiveLog(item)),
    }),
    ...(obj.tierConfig && { tierConfig: GuardrailContentFiltersTierConfigFilterSensitiveLog(obj.tierConfig) }),
});
export const GuardrailContextualGroundingFilterConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.action && { action: SENSITIVE_STRING }),
});
export const GuardrailContextualGroundingPolicyConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.filtersConfig && {
        filtersConfig: obj.filtersConfig.map((item) => GuardrailContextualGroundingFilterConfigFilterSensitiveLog(item)),
    }),
});
export const GuardrailTopicsTierConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.tierName && { tierName: SENSITIVE_STRING }),
});
export const GuardrailTopicConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.definition && { definition: SENSITIVE_STRING }),
    ...(obj.examples && { examples: SENSITIVE_STRING }),
    ...(obj.inputAction && { inputAction: SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: SENSITIVE_STRING }),
});
export const GuardrailTopicPolicyConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.topicsConfig && {
        topicsConfig: obj.topicsConfig.map((item) => GuardrailTopicConfigFilterSensitiveLog(item)),
    }),
    ...(obj.tierConfig && { tierConfig: GuardrailTopicsTierConfigFilterSensitiveLog(obj.tierConfig) }),
});
