import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ListAutomatedReasoningPolicyTestCasesResponseFilterSensitiveLog, } from "../models/models_0";
import { de_ListAutomatedReasoningPolicyTestCasesCommand, se_ListAutomatedReasoningPolicyTestCasesCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class ListAutomatedReasoningPolicyTestCasesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListAutomatedReasoningPolicyTestCases", {})
    .n("BedrockClient", "ListAutomatedReasoningPolicyTestCasesCommand")
    .f(void 0, ListAutomatedReasoningPolicyTestCasesResponseFilterSensitiveLog)
    .ser(se_ListAutomatedReasoningPolicyTestCasesCommand)
    .de(de_ListAutomatedReasoningPolicyTestCasesCommand)
    .build() {
}
