import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetAutomatedReasoningPolicyNextScenarioResponseFilterSensitiveLog, } from "../models/models_0";
import { de_GetAutomatedReasoningPolicyNextScenarioCommand, se_GetAutomatedReasoningPolicyNextScenarioCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class GetAutomatedReasoningPolicyNextScenarioCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetAutomatedReasoningPolicyNextScenario", {})
    .n("BedrockClient", "GetAutomatedReasoningPolicyNextScenarioCommand")
    .f(void 0, GetAutomatedReasoningPolicyNextScenarioResponseFilterSensitiveLog)
    .ser(se_GetAutomatedReasoningPolicyNextScenarioCommand)
    .de(de_GetAutomatedReasoningPolicyNextScenarioCommand)
    .build() {
}
