"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SNOWFLAKE_AUDIENCE = void 0;
exports.getGcpAttestationToken = getGcpAttestationToken;
const google_auth_library_1 = require("google-auth-library");
const logger_1 = __importDefault(require("../../logger"));
exports.SNOWFLAKE_AUDIENCE = 'snowflakecomputing.com';
async function getGcpAttestationToken(impersonationPath) {
    const auth = new google_auth_library_1.GoogleAuth();
    if (impersonationPath) {
        (0, logger_1.default)().debug(`Getting GCP auth token from impersonation path: ${impersonationPath.join(', ')}`);
        const impersonated = new google_auth_library_1.Impersonated({
            sourceClient: await auth.getClient(),
            targetPrincipal: impersonationPath[impersonationPath.length - 1],
            delegates: impersonationPath.slice(0, -1),
        });
        return await impersonated.fetchIdToken(exports.SNOWFLAKE_AUDIENCE);
    }
    (0, logger_1.default)().debug('Getting GCP auth token from default credentials');
    const client = await auth.getIdTokenClient(exports.SNOWFLAKE_AUDIENCE);
    return await client.idTokenProvider.fetchIdToken(exports.SNOWFLAKE_AUDIENCE);
}
//# sourceMappingURL=attestation_gcp.js.map