import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetAutomatedReasoningPolicyTestResultResponseFilterSensitiveLog, } from "../models/models_0";
import { de_GetAutomatedReasoningPolicyTestResultCommand, se_GetAutomatedReasoningPolicyTestResultCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class GetAutomatedReasoningPolicyTestResultCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetAutomatedReasoningPolicyTestResult", {})
    .n("BedrockClient", "GetAutomatedReasoningPolicyTestResultCommand")
    .f(void 0, GetAutomatedReasoningPolicyTestResultResponseFilterSensitiveLog)
    .ser(se_GetAutomatedReasoningPolicyTestResultCommand)
    .de(de_GetAutomatedReasoningPolicyTestResultCommand)
    .build() {
}
