import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetAutomatedReasoningPolicyTestCaseResponseFilterSensitiveLog, } from "../models/models_0";
import { de_GetAutomatedReasoningPolicyTestCaseCommand, se_GetAutomatedReasoningPolicyTestCaseCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class GetAutomatedReasoningPolicyTestCaseCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetAutomatedReasoningPolicyTestCase", {})
    .n("BedrockClient", "GetAutomatedReasoningPolicyTestCaseCommand")
    .f(void 0, GetAutomatedReasoningPolicyTestCaseResponseFilterSensitiveLog)
    .ser(se_GetAutomatedReasoningPolicyTestCaseCommand)
    .de(de_GetAutomatedReasoningPolicyTestCaseCommand)
    .build() {
}
