import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetAutomatedReasoningPolicyAnnotationsResponseFilterSensitiveLog, } from "../models/models_0";
import { de_GetAutomatedReasoningPolicyAnnotationsCommand, se_GetAutomatedReasoningPolicyAnnotationsCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class GetAutomatedReasoningPolicyAnnotationsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "GetAutomatedReasoningPolicyAnnotations", {})
    .n("BedrockClient", "GetAutomatedReasoningPolicyAnnotationsCommand")
    .f(void 0, GetAutomatedReasoningPolicyAnnotationsResponseFilterSensitiveLog)
    .ser(se_GetAutomatedReasoningPolicyAnnotationsCommand)
    .de(de_GetAutomatedReasoningPolicyAnnotationsCommand)
    .build() {
}
