import { Sha256 as WebCryptoSha256 } from "./webCryptoSha256";
import { Sha256 as JsSha256 } from "@aws-crypto/sha256-js";
import { supportsWebCrypto } from "@aws-crypto/supports-web-crypto";
import { locateWindow } from "@aws-sdk/util-locate-window";
import { convertToBuffer } from "@aws-crypto/util";
var Sha256 = /** @class */ (function () {
    function Sha256(secret) {
        if (supportsWebCrypto(locateWindow())) {
            this.hash = new WebCryptoSha256(secret);
        }
        else {
            this.hash = new JsSha256(secret);
        }
    }
    Sha256.prototype.update = function (data, encoding) {
        this.hash.update(convertToBuffer(data));
    };
    Sha256.prototype.digest = function () {
        return this.hash.digest();
    };
    Sha256.prototype.reset = function () {
        this.hash.reset();
    };
    return Sha256;
}());
export { Sha256 };//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/807acdfca108da6b9b2d96452fe047238da1bd9f/node_modules/@aws-crypto/sha256-browser/build/module/crossPlatformSha256.js.map